/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.BlockChromaTiered;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.StatisticalRandom;
import Reika.DragonAPI.Instantiable.Worldgen.ControllableOreVein;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.ReactorCraft.API.MagneticOreOverride;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTieredOre
extends BlockChromaTiered
implements MagneticOreOverride {
    public static final int ARR_LENGTH = 15;
    private final IIcon[] overlay = new IIcon[15];
    private final IIcon[] back = new IIcon[15];
    private final IIcon[] geode = new IIcon[15];
    private final IIcon[] geodestone = new IIcon[15];
    private static final HashSet<String> geodes = new HashSet(ReikaJavaLibrary.makeListFrom((Object[])new String[]{"BINDING", "FOCAL", "TELEPORT", "FIRAXITE", "THERMITE", "SPACERIFT"}));

    public BlockTieredOre(Material mat) {
        super(mat);
        this.func_149711_c(4.0f);
        this.func_149752_b(5.0f);
    }

    public void func_149666_a(Item item, CreativeTabs c, List li) {
        for (int i = 0; i < TieredOres.list.length; ++i) {
            li.add(new ItemStack(item, 1, i));
        }
    }

    private static NBTTagCompound getStoneHistory(EntityPlayer ep) {
        NBTTagCompound tag = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound ret = tag.func_74775_l("elementalstones");
        tag.func_74782_a("elementalstones", (NBTBase)ret);
        return ret;
    }

    public Collection<ItemStack> getHarvestResources(World world, int x, int y, int z, int fortune, EntityPlayer player) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int n = 1;
        switch (TieredOres.list[world.func_72805_g(x, y, z)]) {
            case INFUSED: {
                n = Math.min(16, 1 + rand.nextInt(5) * (1 + rand.nextInt(1 + fortune)));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.chromaDust.func_77946_l());
                }
                break;
            }
            case STONES: {
                n = Math.min(4, 1 + fortune / 2);
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                NBTTagCompound tag = BlockTieredOre.getStoneHistory(player);
                StatisticalRandom sr = new StatisticalRandom(CrystalElement.class);
                sr.readFromNBT(tag);
                for (int i = 0; i < n; ++i) {
                    CrystalElement e = (CrystalElement)sr.roll();
                    li.add(ChromaItems.ELEMENTAL.getStackOfMetadata(e.ordinal()));
                }
                sr.writeToNBT(tag);
                break;
            }
            case BINDING: {
                n = Math.min(8, 1 + rand.nextInt(3) * (1 + rand.nextInt(1 + fortune / 2)));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.bindingCrystal.func_77946_l());
                }
                break;
            }
            case FOCAL: {
                n = Math.min(32, 1 + rand.nextInt(6) * (1 + rand.nextInt(1 + fortune * 3 / 2)));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.focusDust.func_77946_l());
                }
                break;
            }
            case TELEPORT: {
                n = Math.min(32, 1 + rand.nextInt(1 + fortune) + fortune * fortune / 2);
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.enderDust.func_77946_l());
                }
                break;
            }
            case WATERY: {
                n = Math.min(32, 1 + rand.nextInt(6) + rand.nextInt(1 + 3 * fortune));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.waterDust.func_77946_l());
                }
                break;
            }
            case FIRAXITE: {
                n = Math.min(32, 1 + rand.nextInt(8) + rand.nextInt(1 + fortune) * 4);
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.firaxite.func_77946_l());
                }
                break;
            }
            case LUMA: {
                n = Math.min(32, (1 + fortune) * (1 + 4 * rand.nextInt(5)));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.lumaDust.func_77946_l());
                }
                break;
            }
            case ECHO: {
                n = Math.min(32, (1 + fortune * fortune / 2) * (1 + rand.nextInt(8) + rand.nextInt(8)));
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.echoCrystal.func_77946_l());
                }
                break;
            }
            case FIRESTONE: {
                n = 1 + rand.nextInt(6) * (1 + fortune / 2);
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.fireEssence.func_77946_l());
                }
                break;
            }
            case THERMITE: {
                n = 1 + rand.nextInt(1 + fortune * fortune);
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.thermiticCrystal.func_77946_l());
                }
                break;
            }
            case RESO: {
                n = 1 + fortune * 4;
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.resocrystal.func_77946_l());
                }
                break;
            }
            case SPACERIFT: {
                n = 1 + fortune + rand.nextInt(1 + fortune) * 3 / 2;
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.spaceDust.func_77946_l());
                }
                break;
            }
            case RAINBOW: {
                n = 1 + fortune + rand.nextInt(1 + fortune) / 2;
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.lumenGem.func_77946_l());
                }
                break;
            }
            case AVOLITE: {
                n = 1 + rand.nextInt(1 + fortune / 2) / 2;
                n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 512);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.avolite.func_77946_l());
                }
                break;
            }
        }
        return li;
    }

    @Override
    public ProgressStage getProgressStage(int meta) {
        return TieredOres.list[meta].level;
    }

    public Collection<ItemStack> getNoHarvestResources(World world, int x, int y, int z, int fortune, EntityPlayer player) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        Block b = this.getDisguise(world.func_72805_g(x, y, z));
        ArrayList drops = b.getDrops(world, x, y, z, 0, fortune);
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            drops.clear();
            drops.add(new ItemStack(b));
        }
        li.addAll(drops);
        return li;
    }

    public void func_149651_a(IIconRegister ico) {
        int i;
        ArrayList entries = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(TieredOres.class);
        for (i = 0; i < 15; ++i) {
            String s = "chromaticraft:ore/tier_" + i;
            if (geodes.contains(entries.get(i))) {
                this.geode[i] = ico.func_94245_a(s + "_geode");
                continue;
            }
            this.back[i] = ico.func_94245_a(s + "_underlay");
            this.overlay[i] = ico.func_94245_a(s + "_overlay");
        }
        for (i = 0; i < this.geodestone.length; ++i) {
            if (!geodes.contains(entries.get(i))) continue;
            this.geodestone[i] = ico.func_94245_a("chromaticraft:ore/geodestone/" + i);
        }
        this.field_149761_L = Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon getOverlay(int meta) {
        return this.overlay[meta];
    }

    public IIcon getBacking(int meta) {
        return TieredOres.list[meta].renderAsGeode() ? this.getGeodeIcon(meta) : this.back[meta];
    }

    public IIcon getGeodeIcon(int meta) {
        return this.geode[meta];
    }

    public IIcon getGeodeStoneIcon(int i) {
        return this.geodestone[i];
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.getBacking(meta);
    }

    public int func_149645_b() {
        return ChromaISBRH.ore.getRenderID();
    }

    public Block getDisguise(int meta) {
        return TieredOres.list[meta].genBlock;
    }

    public boolean func_149646_a(IBlockAccess world, int dx, int dy, int dz, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        Block b = world.func_147439_a(dx, dy, dz);
        if (b.func_149662_c()) {
            return false;
        }
        switch (dir) {
            default: 
        }
        return true;
    }

    @Override
    protected ItemStack getWailaDisguise(int meta) {
        return new ItemStack(TieredOres.list[meta].genBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer eff) {
        ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b, (int)0);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addHitEffects(World world, MovingObjectPosition tg, EffectRenderer eff) {
        ReikaRenderHelper.spawnDropParticles((World)world, (int)tg.field_72311_b, (int)tg.field_72312_c, (int)tg.field_72309_d, (Block)Blocks.field_150348_b, (int)0, (int)1);
        return true;
    }

    public boolean showOnHUD(World world, int x, int y, int z, EntityPlayer ep) {
        return world.func_72805_g(x, y, z) == TieredOres.AVOLITE.ordinal() && TieredOres.AVOLITE.level.isPlayerAtStage(ep);
    }

    public IIcon[] getRenderIcons(IBlockAccess world, int x, int y, int z) {
        return new IIcon[]{this.back[TieredOres.AVOLITE.ordinal()], this.overlay[TieredOres.AVOLITE.ordinal()]};
    }

    public static enum TieredOres {
        INFUSED(Blocks.field_150348_b, ProgressStage.CRYSTALS, 1, 4, 12),
        STONES(Blocks.field_150348_b, ProgressStage.RUNEUSE, 1, 4, 8),
        BINDING(Blocks.field_150348_b, ProgressStage.CHARGE, 1, 4, 8),
        FOCAL(Blocks.field_150348_b, ProgressStage.MULTIBLOCK, 1, 4, 8),
        TELEPORT(Blocks.field_150348_b, ProgressStage.END, 1, 2, 8),
        WATERY(Blocks.field_150348_b, ProgressStage.OCEAN, 2, 2, 8),
        FIRAXITE(Blocks.field_150348_b, ProgressStage.NETHER, 1, 2, 8),
        LUMA(Blocks.field_150348_b, ProgressStage.STRUCTCOMPLETE, 1, 1, 8),
        ECHO(Blocks.field_150348_b, ProgressStage.CTM, 2, 1, 8),
        FIRESTONE(Blocks.field_150424_aL, ProgressStage.LINK, 3, 2, 16),
        THERMITE(Blocks.field_150424_aL, ProgressStage.END, 3, 2, 16),
        RESO(Blocks.field_150377_bs, ProgressStage.ABILITY, 1, 8, 8),
        SPACERIFT(Blocks.field_150377_bs, ProgressStage.KILLDRAGON, 2, 9, 8),
        RAINBOW(Blocks.field_150348_b, ProgressStage.USEENERGY, 1, 2, 8),
        AVOLITE(Blocks.field_150348_b, ProgressStage.POWERCRYSTAL, 2, 1, 18);

        public final ProgressStage level;
        public final Block genBlock;
        public final int veinSize;
        public final int veinCount;
        public final int genChance;
        public static final TieredOres[] list;

        private TieredOres(Block b, ProgressStage lvl, int gc, int vc, int vs) {
            this.level = lvl;
            this.genBlock = b;
            this.genChance = gc;
            this.veinCount = vc;
            this.veinSize = vs;
        }

        public boolean generate(World world, int x, int z, Random r) {
            int y;
            int n = this.ordinal() >= FIRESTONE.ordinal() ? r.nextInt(128) : (y = r.nextBoolean() ? r.nextInt(32) : r.nextInt(64));
            if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
                y = r.nextInt(200);
            }
            ControllableOreVein.BlockExcludingOreVein ore = new ControllableOreVein.BlockExcludingOreVein(ChromaBlocks.TIEREDORE.getBlockInstance(), this.ordinal(), this.veinSize, (BlockCheck)new BlockKey(ChromaBlocks.CLIFFSTONE.getBlockInstance()));
            ore.target = this.genBlock;
            return ore.func_76484_a(world, r, x, y, z);
        }

        public boolean renderAsGeode() {
            return geodes.contains(this.name());
        }

        static {
            list = TieredOres.values();
        }
    }
}

