/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LoadRegistry;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PlantDropManager;
import Reika.ChromatiCraft.Base.BlockChromaTiered;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockTieredPlant
extends BlockChromaTiered
implements IPlantable,
LoadRegistry {
    public static final int ARR_LENGTH = 7;
    private final IIcon[] front_icons = new IIcon[7];
    private final IIcon[] back_icons = new IIcon[7];

    public BlockTieredPlant(Material mat) {
        super(mat);
        this.func_149711_c(0.0f);
        this.func_149752_b(2.0f);
        this.field_149762_H = field_149779_h;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TieredPlants p = TieredPlants.list[meta];
        if (p == TieredPlants.POD) {
            float maxX = 0.75f;
            float maxY = 0.75f;
            float maxZ = 0.75f;
            float minX = 0.25f;
            float minY = 0.25f;
            float minZ = 0.25f;
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                minY = 0.0f;
            }
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)(y + 1), (int)z)) {
                maxY = 1.0f;
            }
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)(x - 1), (int)y, (int)z)) {
                minX = 0.0f;
            }
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)(x + 1), (int)y, (int)z)) {
                maxX = 1.0f;
            }
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)y, (int)(z - 1))) {
                minZ = 0.0f;
            }
            if (ReikaBlockHelper.isWood((IBlockAccess)world, (int)x, (int)y, (int)(z + 1))) {
                maxZ = 1.0f;
            }
            this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void onLoad() {
        for (int i = 0; i < TieredPlants.list.length; ++i) {
            TieredPlants.list[i].registerDrops(this);
        }
    }

    public final int getLightValue(IBlockAccess iba, int x, int y, int z) {
        int l = !(iba instanceof World) || ((World)iba).field_72995_K ? 4 : 0;
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)TieredPlants.list[iba.func_72805_g((int)x, (int)y, (int)z)].color, (int)l) : l;
    }

    public void func_149666_a(Item item, CreativeTabs c, List li) {
        for (int i = 0; i < TieredPlants.list.length; ++i) {
            li.add(new ItemStack(item, 1, i));
        }
    }

    public Collection<ItemStack> getHarvestResources(World world, int x, int y, int z, int fortune, EntityPlayer player) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int n = 1;
        fortune = Math.max(fortune, EnchantmentHelper.func_77519_f((EntityLivingBase)player));
        TieredPlants p = TieredPlants.list[world.func_72805_g(x, y, z)];
        ItemStack is = p.getDrop();
        switch (p) {
            case FLOWER: {
                n = 1 + fortune * rand.nextInt(8);
                break;
            }
            case CAVE: {
                n = (1 + rand.nextInt(3)) * (1 + fortune * (1 + rand.nextInt(4)));
                break;
            }
            case LILY: {
                n = 4 * (1 + fortune * fortune / 2);
                break;
            }
            case BULB: {
                n = 1 + fortune * 4 + 2 * rand.nextInt(9);
                break;
            }
            case DESERT: {
                n = 1 + fortune * fortune + 2 * rand.nextInt(5);
                break;
            }
            case POD: {
                n = 2 + rand.nextInt(1 + fortune * 3 / 2);
                break;
            }
            case ROOT: {
                n = 1 + rand.nextInt(1 + fortune) / 2;
            }
        }
        n = DimensionTuningManager.instance.getTunedDropCount(player, n, 0, 384);
        for (int i = 0; i < n; ++i) {
            li.add(is.func_77946_l());
        }
        return li;
    }

    @Override
    public ProgressStage getProgressStage(int meta) {
        return TieredPlants.list[meta].level;
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (this.isPlayerSufficientTier((IBlockAccess)world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return super.func_149633_g(world, x, y, z);
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149645_b() {
        return ChromaISBRH.plant.getRenderID();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.plant.setRenderPass(pass);
        return pass <= 1;
    }

    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        if (world.func_82737_E() % 2L == 0L && this.isPlayerSufficientTier((IBlockAccess)world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int meta = world.func_72805_g(x, y, z);
            switch (meta) {
                case 0: {
                    double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.005);
                    double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.005);
                    int g = r.nextInt(255);
                    EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.95, (double)z + 0.5, vx, 0.0, vz).setGravity(0.015f).setColor(0, g, 255).setScale(2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case 1: {
                    float g = 0.02f + 0.005f * r.nextFloat();
                    EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.65, (double)z + 0.5, 0.0, 0.0, 0.0).setGravity(g).setScale(2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case 2: {
                    float g = 0.04f + 0.01f * r.nextFloat();
                    int red = r.nextInt(255);
                    EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.375, (double)z + 0.5, 0.0, 0.0, 0.0).setColor(red, 0, 255).setGravity(-g).setScale(4.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case 3: {
                    float g = 0.02f + 0.005f * r.nextFloat();
                    int gr = r.nextInt(255);
                    double px = (double)x + rand.nextDouble();
                    double pz = (double)z + rand.nextDouble();
                    EntityBlurFX fx = new EntityCCBlurFX(world, px, (double)y + 0.75, pz, 0.0, 0.0, 0.0).setColor(0, 255, gr).setGravity(g).setScale(2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case 4: {
                    float g = 0.02f + 0.005f * r.nextFloat();
                    int gr = r.nextInt(255);
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.25);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.25);
                    EntityBlurFX fx = new EntityCCBlurFX(world, px, (double)y + 0.75, pz, 0.0, 0.0, 0.0).setColor(255, gr, 0).setGravity(-g).setScale(2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    public IIcon getOverlay(int meta) {
        return this.front_icons[meta];
    }

    public IIcon getBacking(int meta) {
        return this.back_icons[meta];
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.getBacking(meta);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < 7; ++i) {
            this.front_icons[i] = ico.func_94245_a("chromaticraft:plant/tierplant_" + i + "_front");
            this.back_icons[i] = ico.func_94245_a("chromaticraft:plant/tierplant_" + i + "_back");
        }
    }

    public boolean canPlaceAt(World world, int x, int y, int z, ItemStack is) {
        return this.isValidLocation(world, x, y, z, is.func_77960_j());
    }

    protected boolean canPlaceBlockOn(World world, int x, int y, int z, TieredPlants p) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        switch (p) {
            case FLOWER: {
                return b == Blocks.field_150349_c || b == Blocks.field_150346_d || b == Blocks.field_150458_ak;
            }
            case BULB: {
                return b.func_149688_o() == Material.field_151584_j;
            }
            case CAVE: {
                return b == Blocks.field_150348_b || b == Blocks.field_150357_h || ReikaBlockHelper.isOre((Block)b, (int)meta) || b == ChromaBlocks.STRUCTSHIELD.getBlockInstance() && world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue();
            }
            case LILY: {
                return b == Blocks.field_150355_j || b == Blocks.field_150358_i;
            }
            case DESERT: {
                return b == Blocks.field_150354_m;
            }
            case POD: {
                return ReikaBlockHelper.isWood((Block)b, (int)meta);
            }
            case ROOT: {
                return b == Blocks.field_150349_c || b == Blocks.field_150346_d;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        this.checkAndDropBlock(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, BlockTieredPlant.func_149729_e((int)0), 0, 2);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.isValidLocation(world, x, y, z, world.func_72805_g(x, y, z));
    }

    private boolean isValidLocation(World world, int x, int y, int z, int meta) {
        TieredPlants p = TieredPlants.list[meta];
        switch (p) {
            case FLOWER: 
            case LILY: 
            case DESERT: 
            case ROOT: {
                return this.canPlaceBlockOn(world, x, y - 1, z, p);
            }
            case BULB: 
            case CAVE: {
                return this.canPlaceBlockOn(world, x, y + 1, z, p);
            }
            case POD: {
                return this.canPlaceBlockOn(world, x, y + 1, z, p) || this.canPlaceBlockOn(world, x + 1, y, z, p) || this.canPlaceBlockOn(world, x - 1, y, z, p) || this.canPlaceBlockOn(world, x, y, z + 1, p) || this.canPlaceBlockOn(world, x, y, z - 1, p);
            }
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (TieredPlants.list[meta]) {
            case BULB: 
            case FLOWER: {
                return EnumPlantType.Plains;
            }
            case CAVE: {
                return EnumPlantType.Cave;
            }
            case LILY: {
                return EnumPlantType.Water;
            }
            case DESERT: {
                return EnumPlantType.Desert;
            }
            case POD: 
            case ROOT: {
                return EnumPlantType.Plains;
            }
        }
        return null;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    protected ItemStack getWailaDisguise(int meta) {
        return new ItemStack(Blocks.field_150350_a);
    }

    public static enum TieredPlants {
        FLOWER(ProgressStage.CRYSTALS, 0x33AAFF),
        CAVE(ProgressStage.RUNEUSE, 0xFFFFFF),
        LILY(ProgressStage.CHARGE, 0xFF00FF),
        BULB(ProgressStage.MULTIBLOCK, 65535),
        DESERT(ProgressStage.PYLON, 0xFFCC33),
        POD(ProgressStage.ALLOY, 8551455),
        ROOT(ProgressStage.TURBOCHARGE, 8854784);

        public final ProgressStage level;
        public final int color;
        public static final TieredPlants[] list;

        private TieredPlants(ProgressStage lvl, int c) {
            this.level = lvl;
            this.color = c;
        }

        public Coordinate generate(World world, int x, int z, Random r) {
            int y = 0;
            switch (this) {
                case BULB: {
                    y = world.field_73011_w.func_76557_i();
                    for (int i = 0; i < 32; ++i) {
                        int dy = y + i;
                        Block b = world.func_147439_a(x, dy + 1, z);
                        int meta = world.func_72805_g(x, dy + 1, z);
                        if (world.func_147439_a(x, dy, z) != Blocks.field_150350_a || !ReikaBlockHelper.isLeaf((Block)b, (int)meta)) continue;
                        return new Coordinate(x, dy, z);
                    }
                    break;
                }
                case CAVE: {
                    for (int i = 0; i < 64; ++i) {
                        boolean flag;
                        int dy = y + i;
                        Block b = world.func_147439_a(x, dy + 1, z);
                        int meta = world.func_72805_g(x, dy + 1, z);
                        boolean bl = flag = b == Blocks.field_150348_b || b.isReplaceableOreGen(world, x, dy + 1, z, Blocks.field_150348_b) || ReikaBlockHelper.isOre((Block)b, (int)meta);
                        if (!flag || world.func_147439_a(x, dy, z) != Blocks.field_150350_a) continue;
                        return new Coordinate(x, dy, z);
                    }
                    break;
                }
                case FLOWER: {
                    y = world.func_72825_h(x, z) - 1;
                    for (int i = -8; i < 8; ++i) {
                        boolean ground;
                        int dy = y + i;
                        boolean bl = ground = world.func_147439_a(x, dy, z) == Blocks.field_150346_d || world.func_147439_a(x, dy, z) == Blocks.field_150349_c;
                        if (!ground || world.func_147439_a(x, dy + 1, z) != Blocks.field_150350_a) continue;
                        return new Coordinate(x, dy + 1, z);
                    }
                    break;
                }
                case LILY: {
                    y = world.func_72825_h(x, z);
                    for (int i = -8; i < 38; ++i) {
                        boolean water;
                        int dy = y + i;
                        boolean bl = water = world.func_147439_a(x, dy, z) == Blocks.field_150355_j && world.func_72805_g(x, dy, z) == 0;
                        if (!water || world.func_147439_a(x, dy + 1, z) != Blocks.field_150350_a || !world.func_72937_j(x, dy + 1, z)) continue;
                        return new Coordinate(x, dy + 1, z);
                    }
                    break;
                }
                case DESERT: {
                    y = world.func_72825_h(x, z) - 1;
                    for (int i = -8; i < 8; ++i) {
                        boolean ground;
                        int dy = y + i;
                        boolean bl = ground = world.func_147439_a(x, dy, z) == Blocks.field_150354_m;
                        if (!ground || world.func_147439_a(x, dy + 1, z) != Blocks.field_150350_a) continue;
                        return new Coordinate(x, dy + 1, z);
                    }
                    break;
                }
                case POD: {
                    x = ReikaMathLibrary.bitRound((int)x, (int)4) + 7 + rand.nextInt(2);
                    z = ReikaMathLibrary.bitRound((int)z, (int)4) + 7 + rand.nextInt(2);
                    Coordinate c = ReikaWorldHelper.findTreeNear((World)world, (int)x, (int)world.func_72825_h(x, z), (int)z, (int)7);
                    if (c == null) break;
                    int ymin = c.yCoord;
                    int ymax = c.yCoord;
                    Coordinate c2 = c;
                    while (ReikaBlockHelper.isWood((Block)c2.getBlock((IBlockAccess)world), (int)c2.getBlockMetadata((IBlockAccess)world))) {
                        c2 = c2.offset(0, -1, 0);
                        --ymin;
                    }
                    c2 = c;
                    while (ReikaBlockHelper.isWood((Block)c2.getBlock((IBlockAccess)world), (int)c2.getBlockMetadata((IBlockAccess)world))) {
                        c2 = c2.offset(0, 1, 0);
                        ++ymax;
                    }
                    int gy = ReikaRandomHelper.getRandomBetween((int)(++ymin), (int)(--ymax));
                    for (ForgeDirection dir : ReikaDirectionHelper.getRandomOrderedDirections((boolean)true)) {
                        c2 = new Coordinate(c.xCoord, gy, c.zCoord).offset(dir, 1);
                        if (!c2.softBlock((IBlockAccess)world)) continue;
                        return c2;
                    }
                    break;
                }
                case ROOT: {
                    x = ReikaMathLibrary.bitRound((int)x, (int)4) + 7 + rand.nextInt(2);
                    z = ReikaMathLibrary.bitRound((int)z, (int)4) + 7 + rand.nextInt(2);
                    Coordinate c = ReikaWorldHelper.findTreeNear((World)world, (int)x, (int)world.func_72825_h(x, z), (int)z, (int)7);
                    if (c == null) break;
                    while (ReikaBlockHelper.isWood((Block)c.getBlock((IBlockAccess)world), (int)c.getBlockMetadata((IBlockAccess)world))) {
                        c = c.offset(0, -1, 0);
                    }
                    c = c.offset(0, 1, 0);
                    for (ForgeDirection dir : ReikaDirectionHelper.getRandomOrderedDirections((boolean)true)) {
                        Coordinate c2 = c.offset(dir, 1);
                        if (!c2.softBlock((IBlockAccess)world)) continue;
                        return c2;
                    }
                    break;
                }
            }
            return null;
        }

        public int getGenerationCount(World world) {
            switch (this) {
                case POD: {
                    return 6;
                }
                case ROOT: {
                    return 3;
                }
                case LILY: {
                    return 1;
                }
            }
            return 2;
        }

        public int getGenerationChance(World world) {
            switch (this) {
                case CAVE: {
                    return world.field_73011_w.field_76574_g == 1 ? 1 : 2;
                }
                case POD: 
                case ROOT: {
                    return 4;
                }
            }
            return 5;
        }

        public boolean canGenerateIn(World world) {
            switch (this) {
                case CAVE: 
                case LILY: {
                    return !CrystalPotionController.instance.isWorldHostile(world);
                }
            }
            return true;
        }

        public Block getBlock() {
            return ChromaBlocks.TIEREDPLANT.getBlockInstance();
        }

        public boolean isWaterPlaced() {
            return this == LILY;
        }

        private void registerDrops(BlockTieredPlant b) {
            PlantDropManager.instance.registerDrops((Block)b, this.ordinal(), this.getDrop());
        }

        public ItemStack getDrop() {
            switch (this) {
                case FLOWER: {
                    return ChromaStacks.auraDust.func_77946_l();
                }
                case CAVE: {
                    return ChromaStacks.purityDust.func_77946_l();
                }
                case LILY: {
                    return ChromaStacks.elementDust.func_77946_l();
                }
                case BULB: {
                    return ChromaStacks.resonanceDust.func_77946_l();
                }
                case DESERT: {
                    return ChromaStacks.beaconDust.func_77946_l();
                }
                case POD: {
                    return ChromaStacks.glowbeans.func_77946_l();
                }
                case ROOT: {
                    return ChromaStacks.boostroot.func_77946_l();
                }
            }
            return null;
        }

        static {
            list = TieredPlants.values();
        }
    }
}

