/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft;

import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ChromaConfig
extends ControlledConfig {
    private static final ArrayList<String> modTrees = ChromaConfig.getModTrees();
    private static final int treeLength = modTrees.size();
    private static final int vanillaTreeCount = ReikaTreeHelper.treeList.length;
    private final ControlledConfig.DataElement<Boolean>[] trees = new ControlledConfig.DataElement[treeLength + vanillaTreeCount];
    private final ControlledConfig.DataElement<Float>[] dyeChances = new ControlledConfig.DataElement[ReikaJavaLibrary.getEnumLengthWithoutInitializing(CrystalElement.class)];
    private ControlledConfig.DataElement<String[]> guardianExceptions;
    private KeyWatcher.Key superbuildKey;
    private ControlledConfig.DataElement<int[]> structureDimensionBlacklist;
    private HashSet<Integer> structureDimensionBlacklistSet;

    public ChromaConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        super(mod, option, id);
        String name;
        int i;
        for (i = 0; i < vanillaTreeCount; ++i) {
            name = ReikaTreeHelper.treeList[i].getName();
            this.trees[i] = this.registerAdditionalOption("Generate Vanilla Logs", name, true);
        }
        for (i = 0; i < treeLength; ++i) {
            name = modTrees.get(i);
            this.trees[i + ChromaConfig.vanillaTreeCount] = this.registerAdditionalOption("Generate Mod Logs", name, true);
        }
        ArrayList elements = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(CrystalElement.class);
        for (int i2 = 0; i2 < this.dyeChances.length; ++i2) {
            this.dyeChances[i2] = this.registerAdditionalOption("Vanilla Dye Drop Chances", (String)elements.get(i2), Float.valueOf(100.0f));
        }
        this.registerProperty("t2ConfigModel", ReikaJVMParser.isArgumentPresent((String)"-ChromaTrustingConfigModel"));
        this.guardianExceptions = this.registerAdditionalOption("Other Options", "Guardian Stone Exceptions", this.getDefaultGuardstoneExceptions());
        this.structureDimensionBlacklist = this.registerAdditionalOption("Other Options", "Structure Dimension Blacklist", new int[0]);
    }

    protected void afterInit() {
        this.superbuildKey = KeyWatcher.Key.readFromConfig((DragonAPIMod)this.configMod, (StringConfig)ChromaOptions.SUPERBUILDKEYBIND);
    }

    public KeyWatcher.Key getSuperbuildKey() {
        KeyWatcher.Key k = this.superbuildKey;
        if (k == null) {
            k = KeyWatcher.Key.LCTRL;
        }
        return k;
    }

    private String[] getDefaultGuardstoneExceptions() {
        ArrayList<String> li = new ArrayList<String>();
        for (PlayerInteractEvent.Action a : PlayerInteractEvent.Action.values()) {
            li.add("none#" + a.name());
        }
        li.add(ModList.EXTRAUTILS.modLabel + ":dark_portal:2#" + PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK.name());
        return li.toArray(new String[li.size()]);
    }

    public ArrayList<String> getGuardianExceptions() {
        return ReikaJavaLibrary.makeListFromArray((Object[])((Object[])this.guardianExceptions.getData()));
    }

    private static ArrayList<String> getModTrees() {
        ArrayList base = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ModWoodList.class);
        ArrayList<String> li = new ArrayList<String>();
        for (int i = 0; i < base.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            String sg = (String)base.get(i);
            if (sg.startsWith("BOP")) {
                sg = sg.substring(3);
                sb.append("Biomes O Plenty ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("BXL")) {
                sg = sg.substring(3);
                sb.append("ExtraBiomes XL ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("MFR")) {
                sg = sg.substring(3);
                sb.append("MineFactory Reloaded ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("IC2")) {
                sg = sg.substring(3);
                sb.append("IndustrialCraft ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("NATURA")) {
                sg = sg.substring(6);
                sb.append("Natura ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else {
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            }
            li.add(sb.toString());
        }
        return li;
    }

    public boolean shouldGenerateLogType(ModWoodList tree) {
        return (Boolean)this.trees[tree.ordinal() + ReikaTreeHelper.treeList.length].getData();
    }

    public boolean shouldGenerateLogType(ReikaTreeHelper tree) {
        return (Boolean)this.trees[tree.ordinal()].getData();
    }

    public float getVanillaDyeChance(CrystalElement e) {
        return this.getVanillaDyeChance(e.ordinal());
    }

    public float getVanillaDyeChance(int idx) {
        return ((Float)this.dyeChances[idx % 16].getData()).floatValue();
    }

    public boolean isDimensionBlacklistedForStructures(int dim) {
        if (this.structureDimensionBlacklistSet == null) {
            this.structureDimensionBlacklistSet = new HashSet();
            for (int val : (int[])this.structureDimensionBlacklist.getData()) {
                this.structureDimensionBlacklistSet.add(val);
            }
        }
        return this.structureDimensionBlacklistSet.contains(dim);
    }
}

