/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.DoorKeyCopyingRecipe;
import Reika.ChromatiCraft.Auxiliary.LegacyTileAcceleratorRecipe;
import Reika.ChromatiCraft.Auxiliary.RangedLampPanelingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.InscriptionRecipes;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Block.Worldgen.BlockSparkle;
import Reika.ChromatiCraft.Items.ItemInfoFragment;
import Reika.ChromatiCraft.ModInterface.ItemColoredModInteract;
import Reika.ChromatiCraft.ModInterface.ModInteraction;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.Recipe.ShapelessNBTRecipe;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ThermalRecipeHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.BlockColorInterface;
import Reika.RotaryCraft.API.RecipeInterface;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChromaRecipes {
    public static final int GRINDER_SHARDS = 18;

    public static void addRecipes() {
        for (int i = 0; i < ReikaDyeHelper.dyes.length; ++i) {
            ItemStack berry = ChromaItems.BERRY.getStackOfMetadata(i);
            ItemStack dye = ChromaOptions.isVanillaDyeMoreCommon(i) ? new ItemStack(Items.field_151100_aR, 2, i) : ChromaItems.DYE.getCraftedMetadataProduct(2, i);
            GameRegistry.addShapelessRecipe((ItemStack)dye, (Object[])new Object[]{berry});
        }
        ChromaItems.TOOL.addRecipe("  s", " S ", "S  ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('s'), ChromaItems.SHARD.getAnyMetaStack());
        GameRegistry.addRecipe((ItemStack)ChromaTiles.TABLE.getCraftedProduct(), (Object[])new Object[]{"SCS", "SsS", "sss", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('s'), new ItemStack(ChromaItems.SHARD.getItemInstance(), 1, Short.MAX_VALUE), Character.valueOf('C'), Blocks.field_150462_ai});
        ChromaItems.HELP.addRecipe("abc", "gBg", "def", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('a'), ChromaRecipes.getShard(CrystalElement.BLACK), Character.valueOf('b'), ChromaRecipes.getShard(CrystalElement.BLUE), Character.valueOf('c'), ChromaRecipes.getShard(CrystalElement.GREEN), Character.valueOf('d'), ChromaRecipes.getShard(CrystalElement.YELLOW), Character.valueOf('e'), ChromaRecipes.getShard(CrystalElement.RED), Character.valueOf('f'), ChromaRecipes.getShard(CrystalElement.WHITE), Character.valueOf('g'), Items.field_151114_aO);
        for (ChromaResearch r : ChromaResearch.getAllNonParents()) {
            ItemStack output = ItemInfoFragment.getItem(r);
            GameRegistry.addRecipe((IRecipe)new ShapelessNBTRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)output, (int)2), new Object[]{output, Items.field_151121_aF}));
        }
        if (ModList.THERMALEXPANSION.isLoaded()) {
            FluidStack crystal = FluidRegistry.getFluidStack((String)"potion crystal", (int)500);
            int energy = 40000;
            for (int i = 0; i < 16; ++i) {
                ItemStack shard = ChromaItems.SHARD.getStackOfMetadata(i);
                ThermalRecipeHelper.addCrucibleRecipe((ItemStack)shard, (FluidStack)crystal, (int)energy);
                ThermalRecipeHelper.addPulverizerRecipe((ItemStack)shard, (ItemStack)ChromaStacks.crystalPowder, (int)1000);
            }
        }
        GameRegistry.addRecipe((IRecipe)new LegacyTileAcceleratorRecipe());
        GameRegistry.addRecipe((IRecipe)new DoorKeyCopyingRecipe());
        GameRegistry.addRecipe((IRecipe)new RangedLampPanelingRecipe());
        GameRegistry.addShapelessRecipe((ItemStack)ChromaItems.ENDERBUCKET.getStackOf(), (Object[])new Object[]{ChromaItems.ENDERBUCKET.getAnyMetaStack()});
        ChromaRecipes.loadSmelting();
    }

    private static void loadSmelting() {
        int[] metas = new int[]{1, 2, 6, 7, 8, 10, 11, 12};
        ItemStack basic = ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(0);
        for (int i = 0; i < metas.length; ++i) {
            int meta = metas[i];
            ItemStack is = ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(meta);
            ReikaRecipeHelper.addSmelting((ItemStack)is, (ItemStack)basic, (float)0.0f);
        }
        ReikaRecipeHelper.addSmelting((ItemStack)BlockSparkle.BlockTypes.CLAY.getItem(), (ItemStack)BlockSparkle.BlockTypes.BRICKS.getItem(), (float)0.2f);
        ReikaRecipeHelper.addSmelting((ItemStack)BlockSparkle.BlockTypes.COBBLE.getItem(), (ItemStack)BlockSparkle.BlockTypes.STONE.getItem(), (float)0.0f);
    }

    private static ItemStack getShard(CrystalElement color) {
        return ChromaItems.SHARD.getStackOfMetadata(color.ordinal());
    }

    public static void addPostLoadRecipes() {
        ItemStack shard;
        CrystalElement color;
        int i;
        RecipesCastingTable.instance.addPostLoadRecipes();
        CustomRecipeList.addFieldLookup((String)"chromaticraft_stack", ChromaStacks.class);
        RecipesCastingTable.instance.loadCustomRecipeFiles();
        PoolRecipes.instance.loadCustomPoolRecipes();
        InscriptionRecipes.instance.loadCustomInscriptionRecipes();
        if (ModList.ROTARYCRAFT.isLoaded()) {
            for (i = 0; i < CrystalElement.elements.length; ++i) {
                color = CrystalElement.elements[i];
                shard = ChromaItems.SHARD.getStackOfMetadata(i);
                BlockColorInterface.addGPRBlockColor((Block)ChromaBlocks.CRYSTAL.getBlockInstance(), (int)i, (int)color.getColor());
                BlockColorInterface.addGPRBlockColor((Block)ChromaBlocks.LAMP.getBlockInstance(), (int)i, (int)color.getColor());
                BlockColorInterface.addGPRBlockColor((Block)ChromaBlocks.SUPER.getBlockInstance(), (int)i, (int)color.getColor());
                RecipeInterface.grinder.addAPIRecipe(new ItemStack(ChromaBlocks.CRYSTAL.getBlockInstance(), 1, i), ReikaItemHelper.getSizedItemStack((ItemStack)shard, (int)18));
                RecipeInterface.grinder.addAPIRecipe(new ItemStack(ChromaBlocks.LAMP.getBlockInstance(), 1, i), ReikaItemHelper.getSizedItemStack((ItemStack)shard, (int)4));
                RecipeInterface.grinder.addAPIRecipe(shard, ChromaStacks.crystalPowder);
            }
            for (i = 0; i < BlockDecoFlower.Flowers.list.length; ++i) {
                ItemStack is = BlockDecoFlower.Flowers.list[i].getDrop();
                RecipeInterface.grinder.addAPIRecipe(ChromaBlocks.DECOFLOWER.getStackOfMetadata(i), ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)3));
            }
        }
        if (ModList.THERMALEXPANSION.isLoaded()) {
            ThermalRecipeHelper.addSawmillRecipe((ItemStack)ChromaBlocks.GLOWLOG.getStackOfMetadata(Short.MAX_VALUE), (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ReikaItemHelper.oakWood.asItemStack(), (int)6), (ItemStack)new ItemStack(Items.field_151114_aO), (int)60, (int)800);
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            ModInteraction.addThaumRecipes();
        }
        if (ModList.FORESTRY.isLoaded()) {
            for (i = 0; i < CrystalElement.elements.length; ++i) {
                color = CrystalElement.elements[i];
                shard = ChromaItems.SHARD.getStackOfMetadata(i);
                ItemStack comb = ItemColoredModInteract.ColoredModItems.COMB.getItem(color);
                OreDictionary.registerOre((String)"beeComb", (ItemStack)comb);
                if (ModList.ROTARYCRAFT.isLoaded()) {
                    RecipeInterface.centrifuge.addAPIRecipe(comb, null, 0.0f, new Object[]{shard, Float.valueOf(2.5f)});
                }
                HashMap<ItemStack, Float> map = new HashMap<ItemStack, Float>();
                map.put(shard, Float.valueOf(0.005f));
                RecipeManagers.centrifugeManager.addRecipe(20, comb, map);
            }
        }
    }

    public static void loadDictionary() {
        for (int i = 0; i < ReikaDyeHelper.dyes.length; ++i) {
            ReikaDyeHelper color = ReikaDyeHelper.dyes[i];
            ItemStack crystal = new ItemStack(ChromaBlocks.CRYSTAL.getBlockInstance(), 1, i);
            ItemStack shard = new ItemStack(ChromaItems.SHARD.getItemInstance(), 1, i);
            OreDictionary.registerOre((String)(color.getOreDictName() + "Crystal"), (ItemStack)crystal);
            OreDictionary.registerOre((String)(color.getOreDictName() + "CrystalShard"), (ItemStack)shard);
            OreDictionary.registerOre((String)"dyeCrystal", (ItemStack)crystal);
            OreDictionary.registerOre((String)"caveCrystal", (ItemStack)crystal);
            OreDictionary.registerOre((String)"shardCrystal", (ItemStack)shard);
        }
    }
}

