/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Container;

import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityGlowFire;
import Reika.DragonAPI.Instantiable.BasicInventory;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerItemBurner
extends Container {
    private static final int BASE_BURN_DURATION = 40;
    private static final int MIN_BURN_DURATION = 4;
    private final EntityPlayer player;
    private final BurnerInventory inventory = new BurnerInventory();
    private int burnTick;
    private int burnDuration = 40;

    public ContainerItemBurner(EntityPlayer ep) {
        int i;
        this.player = ep;
        this.func_75146_a(new Slot((IInventory)this.inventory, 0, 80, 18));
        for (i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, k + i * 9 + 9, 8 + k * 18, 42 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, i, 8 + i * 18, 100));
        }
        this.func_75130_a((IInventory)this.inventory);
    }

    public void func_75142_b() {
        super.func_75142_b();
        ItemStack is = this.inventory.func_70301_a(0);
        if (is != null) {
            ElementTagCompound tag = TileEntityGlowFire.getDecompositionValue(is);
            if (tag != null && !tag.isEmpty()) {
                ++this.burnTick;
                if (this.burnTick >= this.burnDuration) {
                    ReikaInventoryHelper.decrStack((int)0, (IInventory)this.inventory, (int)1);
                    PlayerElementBuffer.instance.addToPlayer(this.player, tag.copy(), false);
                    this.burnTick = 0;
                    this.burnDuration = Math.max(4, this.burnDuration - 4);
                    for (int i = 0; i < this.field_75149_d.size(); ++i) {
                        ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
                        icrafting.func_71112_a((Container)this, 2, 0);
                    }
                }
            } else {
                this.burnTick = 0;
                this.burnDuration = 40;
            }
        } else {
            this.burnTick = 0;
            this.burnDuration = 40;
        }
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            icrafting.func_71112_a((Container)this, 0, this.burnTick);
            icrafting.func_71112_a((Container)this, 1, this.burnDuration);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int val) {
        if (id == 0) {
            this.burnTick = val;
        } else if (id == 1) {
            this.burnDuration = val;
        } else if (id == 2) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUISEL, (Entity)this.player, (float)0.5f, (float)0.5f);
        }
    }

    public int getScaledBurn(int a) {
        return this.burnTick * a / this.burnDuration;
    }

    public void func_75130_a(IInventory ii) {
        super.func_75130_a(ii);
    }

    public int getSize() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_75145_c(EntityPlayer ep) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        return null;
    }

    public ItemStack func_75144_a(int slot, int button, int par3, EntityPlayer ep) {
        return super.func_75144_a(slot, button, par3, ep);
    }

    public void func_75134_a(EntityPlayer ep) {
        super.func_75134_a(ep);
        ItemStack is = this.inventory.func_70301_a(0);
        if (is != null) {
            ReikaItemHelper.dropItem((Entity)ep, (ItemStack)is);
        }
    }

    private static class BurnerInventory
    extends BasicInventory {
        private BurnerInventory() {
            super("Burner", 1, 64);
        }

        public boolean func_70300_a(EntityPlayer ep) {
            return true;
        }

        public boolean func_94041_b(int slot, ItemStack is) {
            return true;
        }
    }
}

