/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityChainGunShot
extends EntityFireball {
    private int impacts;
    private EntityPlayer firingPlayer;
    private int immunityTicks;
    private Entity lastHit;

    public EntityChainGunShot(World world, EntityPlayer ep, boolean randomVec) {
        super(world);
        this.impacts = Math.max(2, Math.min(12, this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6)));
        this.immunityTicks = 0;
        this.lastHit = null;
        this.firingPlayer = ep;
        Vec3 vec = ep.func_70040_Z();
        if (randomVec) {
            vec.field_72450_a = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.field_72448_b = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.field_72449_c = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.func_72432_b();
        }
        double v = 1.5;
        this.field_70159_w = v * vec.field_72450_a;
        this.field_70181_x = v * vec.field_72448_b;
        this.field_70179_y = v * vec.field_72449_c;
        this.field_70232_b = 0.0;
        this.field_70233_c = 0.0;
        this.field_70230_d = 0.0;
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntityChainGunShot(World world) {
        super(world);
        this.impacts = Math.max(2, Math.min(12, this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6)));
        this.immunityTicks = 0;
        this.lastHit = null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        double mx = this.field_70159_w;
        double my = this.field_70181_x;
        double mz = this.field_70179_y;
        super.func_70071_h_();
        if (this.immunityTicks != 5) {
            this.field_70159_w = mx;
            this.field_70181_x = my;
            this.field_70179_y = mz;
        }
        if (!(this.field_70170_p.field_72995_K || this.firingPlayer != null && this.field_70173_aa <= 200)) {
            this.destroy();
        }
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa > 10) {
            this.spawnTraceParticle();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnTraceParticle() {
        double dd = 0.25;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa > 0) {
            dd = 0.5;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa > 1) {
            dd = 1.0;
        }
        for (double d = 0.0; d < 1.0; d += dd) {
            double px = this.field_70165_t + this.field_70159_w * d;
            double py = this.field_70163_u + this.field_70181_x * d;
            double pz = this.field_70161_v + this.field_70179_y * d;
            int l = 20 + this.field_70146_Z.nextInt(80);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)6.0, (double)1.0);
            EntityBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz, 0.0, 0.0, 0.0).setRapidExpand().setLife(l).setScale(s).setColor(0, 192, 255);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void func_70227_a(MovingObjectPosition mov) {
        if (this.firingPlayer == null && !this.field_70170_p.field_72995_K) {
            this.destroy();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (mov != null && mov.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity e = mov.field_72308_g;
                if (e != this.firingPlayer && e != this.lastHit && e instanceof EntityLivingBase && !e.field_70128_L && ((EntityLivingBase)e).func_110143_aJ() > 0.0f) {
                    if (this.impacts > 0) {
                        --this.impacts;
                        this.lastHit = e;
                        this.findAndRedirect(e);
                        ChromaSounds.CAST.playSound((Entity)this, 2.0f, 2.0f);
                        ChromaSounds.CAST.playSound((Entity)this.firingPlayer, 0.5f, 2.0f);
                    } else {
                        this.destroy();
                    }
                    PacketTarget.RadiusTarget pt = new PacketTarget.RadiusTarget((Entity)this, 48.0);
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.CHAINGUNHURT.ordinal(), (PacketTarget)pt, (int[])new int[]{e.func_145782_y()});
                    int dmg = this.firingPlayer.func_70644_a(Potion.field_76420_g) || Chromabilities.RANGEDBOOST.enabledOn(this.firingPlayer) ? 20 : 10;
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.firingPlayer).func_76349_b(), (float)dmg);
                    e.field_70172_ad = 0;
                }
            } else if (mov != null && mov.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.immunityTicks == 0) {
                this.destroy();
            }
        }
    }

    public boolean func_90999_ad() {
        return false;
    }

    private void findAndRedirect(Entity start) {
        List li = this.field_70170_p.func_72839_b(start, this.field_70121_D.func_72314_b(16.0, 6.0, 16.0));
        if (!li.isEmpty()) {
            WeightedRandom rand = new WeightedRandom();
            for (Entity e : li) {
                EntityLivingBase elb;
                int weight;
                if (!(e instanceof EntityLivingBase) || (weight = this.getEntityWeight(elb = (EntityLivingBase)e)) <= 0) continue;
                rand.addEntry((Object)elb, (double)weight);
            }
            if (rand.isEmpty()) {
                this.destroy();
            } else {
                this.targetEntity((EntityLivingBase)rand.getRandomEntry());
            }
        } else {
            this.destroy();
        }
    }

    private int getEntityWeight(EntityLivingBase e) {
        if (e == this.firingPlayer) {
            return 0;
        }
        if (e.field_70128_L || e.func_110143_aJ() <= 0.0f) {
            return 0;
        }
        if (e instanceof EntityPlayer) {
            return MinecraftServer.func_71276_C().func_71219_W() ? 100 : 0;
        }
        if (e instanceof EntityDragon || e instanceof EntityWither) {
            return 80;
        }
        if (e instanceof EntityWitch || e instanceof EntityIronGolem) {
            return 60;
        }
        if (e instanceof EntityMob) {
            return 50;
        }
        if (e instanceof EntityTameable) {
            return 5;
        }
        if (e instanceof EntityAnimal) {
            return 10;
        }
        return 25;
    }

    private void targetEntity(EntityLivingBase e) {
        double dx = e.field_70165_t - this.field_70165_t;
        double dy = e.field_70163_u + (double)e.field_70131_O * (0.2 + this.field_70146_Z.nextDouble() * 0.6) - this.field_70163_u;
        double dz = e.field_70161_v - this.field_70161_v;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 1.5;
        this.field_70159_w = dx / dd * v;
        this.field_70181_x = dy / dd * v;
        this.field_70179_y = dz / dd * v;
        this.immunityTicks = 5;
    }

    private void destroy() {
        this.func_70106_y();
        ChromaSounds.POWERDOWN.playSound((Entity)this);
        if (this.firingPlayer != null) {
            ChromaSounds.POWERDOWN.playSound((Entity)this.firingPlayer, 0.5f, 1.0f);
        }
        PacketTarget.RadiusTarget pt = new PacketTarget.RadiusTarget((Entity)this, 48.0);
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.CHAINGUNEND.ordinal(), (PacketTarget)pt, (int[])new int[]{this.func_145782_y()});
    }

    @SideOnly(value=Side.CLIENT)
    public static void doDamagingParticles(int entityID) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        for (int i = 0; i < 32; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)0.5);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70163_u, (double)0.5);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)0.5);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            float s = 0.5f + e.field_70170_p.field_73012_v.nextFloat() * 4.0f;
            int l = 5 + e.field_70170_p.field_73012_v.nextInt(75) * (1 + e.field_70170_p.field_73012_v.nextInt(2));
            CrystalElement c = e.field_70170_p.field_73012_v.nextBoolean() ? CrystalElement.BLACK : CrystalElement.PINK;
            EntityBlurFX fx = new EntityCCBlurFX(c, e.field_70170_p, rx, ry, rz, vx, vy, vz).setNoSlowdown().setScale(s).setRapidExpand().setLife(l);
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doDestructionParticles(int entityID) {
        EntityChainGunShot ec = (EntityChainGunShot)Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        for (int i = 0; i < 128; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)ec.field_70165_t, (double)0.5);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)ec.field_70163_u, (double)0.5);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)ec.field_70161_v, (double)0.5);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.5);
            float s = 0.5f + ec.field_70146_Z.nextFloat() * 4.0f;
            int l = 5 + ec.field_70146_Z.nextInt(75) * (1 + ec.field_70146_Z.nextInt(2));
            int color = ReikaColorAPI.getModifiedHue((int)255, (int)ReikaRandomHelper.getRandomPlusMinus((int)240, (int)60));
            EntityBlurFX fx = new EntityCCBlurFX(ec.field_70170_p, rx, ry, rz, vx, vy, vz).setNoSlowdown().setScale(s).setRapidExpand().setLife(l).setColor(color);
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }
}

