/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Interfaces.Entity.DestroyOnUnload;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityDeathFog
extends InertEntity
implements IEntityAdditionalSpawnData,
DestroyOnUnload {
    public static final int MIN_LIFE = 40;
    public static final int MAX_LIFE = 300;
    private int lifespan;
    private int remainingLife;
    private boolean enhanced = false;

    public EntityDeathFog(World world, double x, double y, double z, double vx, double vy, double vz, boolean flag) {
        super(world);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.remainingLife = this.lifespan = ReikaRandomHelper.getRandomBetween((int)40, (int)300);
        this.field_70145_X = false;
        this.enhanced = flag;
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntityDeathFog(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70071_h_() {
        double mx = this.field_70159_w;
        double my = this.field_70181_x;
        double mz = this.field_70179_y;
        super.func_70071_h_();
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        if (!this.field_70170_p.field_72995_K) {
            this.remainingLife = this.lifespan - this.field_70173_aa;
            this.field_70180_af.func_75692_b(24, (Object)this.remainingLife);
            List li2 = this.field_70170_p.func_72945_a((Entity)this, ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)0.3));
            while (!li2.isEmpty()) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v);
                li2 = this.field_70170_p.func_72945_a((Entity)this, ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)0.3));
                this.field_70181_x = Math.max(this.field_70181_x, 0.0);
                this.field_70133_I = true;
            }
            AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)(this.enhanced ? 4.0 : 2.5));
            List li = this.field_70170_p.func_94576_a((Entity)this, box, ReikaEntityHelper.hostileSelector);
            for (EntityLivingBase e : li) {
                if (!this.shouldAttack(e)) continue;
                this.attack(e);
            }
        } else {
            this.remainingLife = this.field_70180_af.func_75679_c(24);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.lifespan) {
            this.destroy();
        }
    }

    public boolean func_90999_ad() {
        return false;
    }

    private void attack(EntityLivingBase e) {
        if (this.enhanced) {
            e.func_70097_a(DamageSource.field_76376_m, 0.5f);
            e.field_70172_ad = e.field_70771_an / 2 + 1;
        } else {
            e.func_70097_a(DamageSource.field_76376_m, 1.0f);
        }
    }

    private boolean shouldAttack(EntityLivingBase e) {
        return ReikaEntityHelper.isHostile((EntityLivingBase)e) && e.func_110143_aJ() > 0.0f && !e.field_70128_L;
    }

    public void destroy() {
        this.func_70106_y();
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    public float getLifeRatio() {
        return (float)this.remainingLife / (float)this.lifespan;
    }

    public int getRemainingLife() {
        return this.remainingLife;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.lifespan = tag.func_74762_e("life");
        this.remainingLife = tag.func_74762_e("time");
        this.enhanced = tag.func_74767_n("enhance");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("time", this.remainingLife);
        tag.func_74768_a("life", this.lifespan);
        tag.func_74757_a("enhance", this.enhanced);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.lifespan);
        buf.writeInt(this.remainingLife);
        buf.writeBoolean(this.enhanced);
    }

    public void readSpawnData(ByteBuf buf) {
        this.lifespan = buf.readInt();
        this.remainingLife = buf.readInt();
        this.enhanced = buf.readBoolean();
    }
}

