/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.OuterRegionsEvents;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.Formula.PeriodicExpression;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.EntityLockMotionController;
import Reika.DragonAPI.Instantiable.ParticleController.FlashColorController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityDimensionFlare
extends Entity {
    private EntityPlayer target;
    private int stateTick;
    private RelationState state = RelationState.FIND;
    private FlareIdentity identity;
    private final HashMap<UUID, Integer> aggroPlayers = new HashMap();
    private final ArrayList<ColorDirection> trailColors = new ArrayList();

    public EntityDimensionFlare(World world) {
        super(world);
        if (world.field_72995_K && this.identity == null) {
            this.identity = FlareIdentity.getRandomFlare(this);
            for (int i = 0; i < 16; ++i) {
                double a1 = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)10.0);
                double a2 = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)10.0);
                this.trailColors.add(new ColorDirection(this.identity.flareColor, a1, a2));
            }
        }
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityDimensionFlare(World world, EntityPlayer ep) {
        super(world);
        this.target = ep;
    }

    public FlareIdentity getIdentity() {
        return this.identity;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_85030_a(String snd, float vol, float p) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target != null) {
            this.doAggro();
            double d = this.func_70068_e((Entity)this.target);
            if (d < 65536.0) {
                this.moveToTarget();
                if (d < 9216.0) {
                    this.progressRelationship();
                    if (d < 576.0) {
                        if (this.field_70146_Z.nextInt(320) == 0 && this.target instanceof EntityPlayerMP) {
                            this.sendMessageToPlayer();
                        }
                        if (this.field_70146_Z.nextInt(80) == 0 && this.state == RelationState.ATTACK) {
                            OuterRegionsEvents.instance.doRejectAttack(this, this.target);
                        }
                    }
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_145771_j(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        double d;
        EntityBlurFX fx;
        ColorDirection dir;
        int idx;
        int i;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
        int n = 1 + this.field_70146_Z.nextInt(this.trailColors.size() / 2);
        for (i = 0; i < n; ++i) {
            idx = this.field_70146_Z.nextInt(this.trailColors.size());
            dir = this.trailColors.get(idx);
            double vel = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.125);
            double a1 = angs[1] + dir.angle1 - 90.0;
            double a2 = -angs[2] + 90.0 + dir.angle2;
            double[] v = ReikaPhysicsHelper.polarToCartesian((double)vel, (double)a1, (double)a2);
            EntityBlurFX fx2 = new EntityCCBlurFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, v[0], v[1], v[2]).setColor(dir.color).setScale(1.5f + this.field_70146_Z.nextFloat() * 1.5f);
            double d2 = this.field_70146_Z.nextDouble() * 360.0;
            PeriodicExpression e = new PeriodicExpression().addWave(1.0, 1.0, d2).addWave(0.5, 2.0, d2 + 90.0).addWave(0.125, 4.0, d2).normalize();
            fx2.setColorController((ColorController)new FlashColorController((MathExpression)e, dir.color, 0));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
        for (i = 0; i < 1; ++i) {
            idx = this.field_70146_Z.nextInt(this.trailColors.size());
            dir = this.trailColors.get(idx);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)1.25, (double)(this.field_70146_Z.nextDouble() * 360.0), (double)(this.field_70146_Z.nextDouble() * 360.0));
            fx = new EntityCCBlurFX(this.field_70170_p, this.field_70165_t + xyz[0], this.field_70163_u + xyz[1], this.field_70161_v + xyz[2]).setColor(dir.color).setScale(0.75f + this.field_70146_Z.nextFloat() * 0.5f);
            d = this.field_70146_Z.nextDouble() * 360.0;
            fx.setMotionController((MotionController)new EntityLockMotionController((Entity)this, 0.0078125, 1.0, 0.875));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 1; ++i) {
            idx = this.field_70146_Z.nextInt(this.trailColors.size());
            dir = this.trailColors.get(idx);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.625, (double)(this.field_70146_Z.nextDouble() * 360.0), (double)(this.field_70146_Z.nextDouble() * 360.0));
            fx = new EntityCCBlurFX(this.field_70170_p, this.field_70165_t + xyz[0] - this.field_70159_w, this.field_70163_u + xyz[1] - this.field_70181_x, this.field_70161_v + xyz[2] - this.field_70179_y, this.field_70159_w, this.field_70181_x, this.field_70179_y).setColor(dir.color);
            fx.setScale(2.5f + this.field_70146_Z.nextFloat() * 1.0f).setLife(20).setRapidExpand();
            d = this.field_70146_Z.nextDouble() * 360.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void doAggro() {
        Iterator<Map.Entry<UUID, Integer>> it = this.aggroPlayers.entrySet().iterator();
        while (it.hasNext()) {
            boolean flag;
            Map.Entry<UUID, Integer> e = it.next();
            EntityPlayer ep = this.field_70170_p.func_152378_a(e.getKey());
            int get = e.getValue() != null ? e.getValue() : 0;
            e.setValue(get + 1);
            if (this.field_70146_Z.nextInt(120) != 0 || !(this.func_70068_e((Entity)ep) < 1024.0) || !(flag = OuterRegionsEvents.instance.doRejectAttack(this, ep)) && !ep.field_70128_L && !(ep.func_110143_aJ() <= 0.0f)) continue;
            it.remove();
        }
    }

    public int getAttackTicks(EntityPlayer ep) {
        Integer get = this.aggroPlayers.get(ep.func_110124_au());
        return get != null ? get : 0;
    }

    private void moveToTarget() {
        double dx = this.target.field_70165_t - this.field_70165_t;
        double dy = this.target.field_70163_u - this.field_70163_u;
        double dz = this.target.field_70161_v - this.field_70161_v;
        if (ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz) < 16.0) {
            return;
        }
        double v = 0.03125;
        this.field_70159_w += v * Math.signum(dx);
        this.field_70181_x += v * Math.signum(dy);
        this.field_70179_y += v * Math.signum(dz);
        this.field_70133_I = true;
    }

    private void progressRelationship() {
        ++this.stateTick;
        if (this.stateTick >= this.state.duration) {
            this.state = this.state.next(!ProgressStage.CTM.isPlayerAtStage(this.target));
            this.stateTick = 0;
            if (this.state == RelationState.ATTACK) {
                this.aggroPlayers.put(this.target.func_110124_au(), 0);
            }
        }
    }

    public boolean func_70097_a(DamageSource src, float amt) {
        if (src == DamageSource.field_76379_h) {
            return false;
        }
        boolean flag = super.func_70097_a(src, amt);
        if (src.func_76346_g() instanceof EntityPlayer) {
            this.state = RelationState.ATTACKED;
            OuterRegionsEvents.instance.doFlareAggro((EntityPlayer)src.func_76346_g());
        }
        return flag;
    }

    private void sendMessageToPlayer() {
        String msg = this.state.getRandomMessage(this.field_70146_Z);
        String s = "<" + msg + ">";
        ReikaPacketHelper.sendStringPacket((String)"ChromaData", (int)ChromaPackets.FLAREMSG.ordinal(), (String)s, (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)this.target));
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public void aggroTo(EntityPlayer ep) {
        if (!this.aggroPlayers.containsKey(ep.func_110124_au())) {
            this.aggroPlayers.put(ep.func_110124_au(), 0);
        }
        this.state = RelationState.ATTACKED;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70112_a(double distsq) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public static class FlareIdentity {
        public final float soundPitch;
        public final int flareColor;

        private FlareIdentity(int c, float sound) {
            this.soundPitch = sound;
            this.flareColor = c;
        }

        public static FlareIdentity getRandomFlare(EntityDimensionFlare e) {
            int c = 0xFFFFFF;
            switch (e.field_70146_Z.nextInt(4)) {
                case 0: {
                    c = 0xFFFFFF;
                    break;
                }
                case 1: {
                    c = 0x22AAFF;
                    break;
                }
                case 2: {
                    c = 14322943;
                    break;
                }
                case 3: {
                    c = 16773549;
                }
            }
            return new FlareIdentity(c, e.field_70146_Z.nextFloat() + 0.5f);
        }
    }

    private static class ColorDirection {
        private final double angle1;
        private final double angle2;
        private final int color;

        private ColorDirection(int c, double a1, double a2) {
            this.color = c;
            this.angle1 = a1;
            this.angle2 = a2;
        }
    }

    public static enum RelationState {
        FIND(30, "Curiosity", "Inquisitiveness", "Confusion", "Interest", "Confidence", "Fascination"),
        INSPECT(5, "Suspicion", "Caution", "Investigative", "Hope", "Anxiety", "Expectation", "Anticipation"),
        REJECT(15, "Dismissiveness", "Superiority", "Contempt", "Insult", "Concern", "Territoriality"),
        WARN(30, "Aggravation", "Provocation", "Irritation", "Agitation", "Exclusion"),
        THREATEN(45, "Hostile", "Alarm", "Intimidation", "Exile"),
        ATTACK(Integer.MAX_VALUE, "Aggression", "Defence", "Banishment"),
        ATTACKED(Integer.MAX_VALUE, "Shock", "Rage", "Anger", "Retaliation"),
        ACCEPT(15, "Acceptance", "Pleasure", "Satisfaction"),
        WELCOME(Integer.MAX_VALUE, "Friendliness", "Welcoming", "Admiration", "Gratitude");

        private final int duration;
        private final ArrayList<String> messages;
        private static final RelationState[] list;

        private RelationState(int d, String ... s) {
            this.duration = d == Integer.MAX_VALUE ? d : d * 20;
            this.messages = ReikaJavaLibrary.makeListFrom((Object[])s);
        }

        public String getRandomMessage(Random rand) {
            return this.messages.get(rand.nextInt(this.messages.size()));
        }

        private RelationState next(boolean hostile) {
            if (this.duration == Integer.MAX_VALUE) {
                return this;
            }
            if (this == INSPECT) {
                return hostile ? REJECT : ACCEPT;
            }
            return list[this.ordinal() + 1];
        }

        static {
            list = RelationState.values();
        }
    }
}

