/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Auxiliary.ElementEncodedNumber;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public final class EntityEnderEyeT2
extends EntityEnderEye
implements IEntityAdditionalSpawnData {
    public static final int FUZZ = 440;
    public static final double DEVIATION_CHANCE_BASE = 0.08;
    public static final double DEVIATION_CHANCE_MAX = 0.4;
    private static final Interpolation deviationCurve = new Interpolation(false);
    public static final int ADDITIONAL_LIFE = 60;
    public static final double RANGE = 36.0;
    private UUID owner;
    private int deviateTime;
    private int deviationTick;
    private ElementEncodedNumber.EncodedPosition colorData;
    private Interpolation spiralColor;
    private static final Interpolation distanceColor = new Interpolation(true);
    private double finalX;
    private double finalZ;
    private double spawnX;
    private double spawnZ;
    private double totalDistance;

    public EntityEnderEyeT2(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityEnderEyeT2(World world) {
        super(world);
    }

    public void func_70220_a(double x, int y, double z) {
        Coordinate c;
        this.finalX = x;
        this.finalZ = z;
        this.spawnX = this.field_70165_t;
        this.spawnZ = this.field_70161_v;
        this.totalDistance = this.setTarget(x, y, z);
        this.field_70223_e = -60;
        this.field_70221_f = false;
        if (this.totalDistance > 440.0) {
            int offset = new Random((long)System.identityHashCode(this.field_70170_p) + this.field_70170_p.func_82737_E() / 24000L).nextInt(16);
            this.colorData = new ElementEncodedNumber.EncodedPosition(offset, MathHelper.func_76128_c((double)this.finalX), MathHelper.func_76128_c((double)this.finalZ));
        }
        this.deviateTime = (c = this.getNearestTower()) != null && ReikaRandomHelper.doWithChance((double)deviationCurve.getValue(c.getDistanceTo((Entity)this))) ? 10 + this.field_70146_Z.nextInt(90) : -1;
    }

    private double setTarget(double x, double y, double z) {
        double dx = x - this.field_70165_t;
        double dz = z - this.field_70161_v;
        double d = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
        if (d > 36.0) {
            this.field_70224_b = this.field_70165_t + dx / d * 36.0;
            this.field_70222_d = this.field_70161_v + dz / d * 36.0;
            this.field_70225_c = this.field_70163_u + 8.0;
        } else {
            this.field_70224_b = x;
            this.field_70225_c = y;
            this.field_70222_d = z;
        }
        return d;
    }

    private Coordinate getNearestTower() {
        Towers t = LoreManager.instance.getNearestActiveTower(this.field_70170_p, this.field_70165_t, this.field_70161_v, this.getOwner(this.field_70170_p));
        if (t != null) {
            int z;
            int y;
            int x;
            Coordinate c = t.getGeneratedLocation();
            if (c != null) {
                x = c.xCoord;
                y = c.yCoord + 18;
                z = c.zCoord;
            } else {
                x = t.getRootPosition().field_77276_a;
                z = t.getRootPosition().field_77275_b;
                y = 96;
            }
            return new Coordinate(x, y, z);
        }
        return null;
    }

    private void deviate() {
        Coordinate c = this.getNearestTower();
        if (c == null) {
            return;
        }
        if (this.deviationTick > 30) {
            NBTTagCompound data = new NBTTagCompound();
            this.func_70014_b(data);
            EntityEnderEyeT2 repl = EntityEnderEyeT2.create(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, data);
            repl.func_70220_a(c.xCoord, c.yCoord, c.zCoord);
            repl.deviateTime = -1;
            this.field_70170_p.func_72838_d((Entity)repl);
            this.func_70106_y();
        } else {
            ++this.deviationTick;
            double dx = (double)c.xCoord - this.field_70165_t;
            double dz = (double)c.zCoord - this.field_70161_v;
            double d = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
            double f = (double)this.deviationTick / 30.0;
            double tx = f * dx + (1.0 - f) * (this.finalX - this.field_70165_t);
            double tz = f * dz + (1.0 - f) * (this.finalZ - this.field_70161_v);
            this.setTarget(tx, this.field_70225_c, tz);
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.doParticles();
        } else if (this.field_70173_aa % 8 == 0) {
            this.sync();
        }
        boolean flag = this.deviateTime > 0 && this.field_70173_aa >= this.deviateTime;
        super.func_70071_h_();
        if (flag) {
            if (!this.field_70170_p.field_72995_K) {
                this.deviate();
            }
            this.field_70159_w *= 0.85;
            this.field_70181_x *= 0.85;
            this.field_70179_y *= 0.85;
        } else {
            this.field_70159_w *= 0.7;
            this.field_70181_x *= 0.7;
            this.field_70179_y *= 0.7;
        }
        this.field_70133_I = true;
        if (this.field_70223_e > 80 && !this.field_70170_p.field_72995_K) {
            ItemStack is = ChromaItems.ENDEREYE.getStackOf();
            is.field_77990_d = new NBTTagCompound();
            this.func_70014_b(is.field_77990_d);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, is));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles() {
        if (this.field_70173_aa >= 6) {
            int n = ReikaRandomHelper.getRandomBetween((int)2, (int)6);
            double r = 0.125;
            for (int i = 0; i < n; ++i) {
                double dx = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)r);
                double dy = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)r);
                double dz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)r);
                int l = 80 - this.field_70173_aa + DragonAPICore.rand.nextInt(40);
                float s = (float)ReikaRandomHelper.getRandomBetween((double)1.5, (double)3.0);
                int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)ReikaRandomHelper.getRandomBetween((int)75, (int)180));
                if (this.field_70146_Z.nextInt(6) > 0) {
                    c = (int)distanceColor.getValue(this.totalDistance);
                }
                EntityCCBlurFX fx = (EntityCCBlurFX)new EntityCCBlurFX(this.field_70170_p, dx, dy, dz).setLife(l).setScale(s).setColor(c);
                fx.setIcon(ChromaIcons.FADE_GENTLE).setRapidExpand().setAlphaFading();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (this.colorData != null && this.spiralColor != null && (this.deviateTime < 0 || this.deviateTime > this.field_70173_aa)) {
            int t = this.field_70173_aa;
            int c = (int)this.spiralColor.getValue((double)t);
            double lf = 140.0;
            double ang = (double)t * 360.0 / lf * 2.0;
            double r = 3.0;
            double l = (double)t / lf;
            Vec3 vec = ReikaVectorHelper.getPointAroundVector((Vec3)Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y), (double)r, (double)ang);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_70170_p, this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b, this.field_70161_v + vec.field_72449_c);
            float s = 7.5f;
            fx.setLife(180).setScale(s).setColor(c);
            fx.setIcon(ChromaIcons.FADE_BASICBLEND).setRapidExpand().setAlphaFading().setBasicBlend();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean isOwner(EntityPlayer ep) {
        return ep.getPersistentID().equals(this.owner);
    }

    public EntityPlayer getOwner(World world) {
        return this.owner != null ? world.func_152378_a(this.owner) : null;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("owner")) {
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeDouble(this.finalX);
        buf.writeDouble(this.finalZ);
        buf.writeDouble(this.spawnX);
        buf.writeDouble(this.spawnZ);
        buf.writeInt(this.deviateTime);
        if (this.colorData != null) {
            buf.writeInt(this.colorData.totalLength());
            this.colorData.writeData(buf);
        } else {
            buf.writeInt(-1);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.finalX = buf.readDouble();
        this.finalZ = buf.readDouble();
        this.spawnX = buf.readDouble();
        this.spawnZ = buf.readDouble();
        this.deviateTime = buf.readInt();
        this.totalDistance = ReikaMathLibrary.py3d((double)(this.finalX - this.spawnX), (double)0.0, (double)(this.finalZ - this.spawnZ));
        int amt = buf.readInt();
        if (amt != -1) {
            this.colorData = ElementEncodedNumber.EncodedPosition.readData(buf);
            this.spiralColor = new Interpolation(true);
            for (int i = 0; i < this.colorData.totalLength(); ++i) {
                CrystalElement e = this.colorData.getColor(i);
                int lf = 140;
                int t = lf * i / amt;
                int t2 = lf * (i + 1) / amt;
                int cr = 3;
                int c = this.colorData.isVariableChange(i) ? 0x22AAFF : (this.colorData.isPartOfNegative(i) ? 0 : 0xFFFFFF);
                this.spiralColor.addPoint((double)t, (double)c);
                this.spiralColor.addPoint((double)(t + cr), (double)e.getColor());
                this.spiralColor.addPoint((double)(t2 - cr), (double)e.getColor());
                this.spiralColor.addPoint((double)t2, (double)c);
            }
        }
    }

    public void sync() {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.ENDEREYESYNC.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)this, 200.0), (int[])new int[]{this.func_145782_y(), this.field_70173_aa});
    }

    @SideOnly(value=Side.CLIENT)
    public void doSync(int t) {
        this.field_70173_aa = t;
    }

    public static EntityEnderEyeT2 create(World world, double x, double y, double z, NBTTagCompound tag) {
        EntityEnderEyeT2 eye = new EntityEnderEyeT2(world, x, y, z);
        eye.func_70037_a(tag);
        return eye;
    }

    static {
        distanceColor.addPoint(0.0, 6316128.0);
        distanceColor.addPoint(440.0, 75.0);
        distanceColor.addPoint(6000.0, 180.0);
        distanceColor.addPoint(0.0, 1.6777215E7);
        deviationCurve.addPoint(0.0, 0.4);
        deviationCurve.addPoint(440.0, 0.4);
        double dm = 0.24;
        deviationCurve.addPoint(1024.0, dm);
        deviationCurve.addPoint(4096.0, 0.08);
    }
}

