/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.PylonDamage;
import Reika.ChromatiCraft.Block.BlockCrystalTank;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemInventoryLinker;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.SphericalVector;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.CollectingPositionController;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Interfaces.Entity.DestroyOnUnload;
import Reika.DragonAPI.Interfaces.Entity.EtherealEntity;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModList;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityGlowCloud
extends EntityLiving
implements EtherealEntity,
IMob,
DestroyOnUnload {
    private SphericalVector velocity;
    private double targetTheta;
    private double targetPhi;
    private double targetVelocity;
    private int color;
    private int targetColor;
    private int colorTransitionTick;
    private boolean isPylonSpawn;
    private boolean doDrops;
    private static final int COLOR_TRANSITION_LENGTH = 120;
    private static final int SOLID_COLOR_LENGTH = 80;
    private Coordinate light;
    private Coordinate oldLight;
    private AxisAlignedBB lightingBox;
    private static int LIGHT_UPDATE_RATE = 16;
    private static int spawnedEntities;
    private static final int SPAWN_LIMIT = 80;
    private static final IEntitySelector naturalSpawnedSelector;
    private static final RayTracer LOS;
    private boolean init;
    private boolean isAngry;
    private int attackCooldown;
    private boolean isNaturalSpawn;
    private Coordinate cachedTile;

    public EntityGlowCloud(World world, double x, double y, double z) {
        super(world);
        this.targetTheta = this.field_70146_Z.nextInt(360);
        this.targetPhi = this.field_70146_Z.nextInt(360);
        this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
        this.colorTransitionTick = 0;
        this.isPylonSpawn = false;
        this.doDrops = true;
        this.lightingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.attackCooldown = 20;
        this.isNaturalSpawn = true;
        this.color = this.generateRandomColor();
        this.targetColor = this.generateRandomColor();
        this.func_70107_b(x, y, z);
        this.field_70131_O = 0.25f;
        this.field_70130_N = 0.25f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    private int generateRandomColor() {
        int hue = ReikaRandomHelper.getRandomBetween((int)120, (int)300);
        int c = Color.HSBtoRGB((float)hue / 360.0f, 1.0f, 1.0f);
        return ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)this.field_70146_Z.nextFloat());
    }

    public EntityGlowCloud(World world) {
        super(world);
        this.targetTheta = this.field_70146_Z.nextInt(360);
        this.targetPhi = this.field_70146_Z.nextInt(360);
        this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
        this.colorTransitionTick = 0;
        this.isPylonSpawn = false;
        this.doDrops = true;
        this.lightingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.attackCooldown = 20;
        this.isNaturalSpawn = true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70687_e(PotionEffect e) {
        return false;
    }

    protected String func_146067_o(int p_146067_1_) {
        return "";
    }

    protected void func_70069_a(float p_70069_1_) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public String func_70005_c_() {
        return "Luma Fog";
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.velocity = new SphericalVector(0.15, (double)this.field_70146_Z.nextInt(360), (double)this.field_70146_Z.nextInt(360));
        this.color = this.generateRandomColor();
        this.targetColor = this.generateRandomColor();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (ReikaMathLibrary.approxr((double)this.velocity.inclination, (double)this.targetTheta, (double)2.0)) {
                this.targetTheta = this.field_70146_Z.nextInt(360);
            } else {
                this.velocity.inclination = this.targetTheta > this.velocity.inclination ? (this.velocity.inclination += 1.0) : (this.velocity.inclination -= 1.0);
            }
            if (ReikaMathLibrary.approxr((double)this.velocity.rotation, (double)this.targetPhi, (double)2.0)) {
                this.targetPhi = this.field_70146_Z.nextInt(360);
            } else {
                this.velocity.rotation = this.targetPhi > this.velocity.rotation ? (this.velocity.rotation += 1.0) : (this.velocity.rotation -= 1.0);
            }
            if (ReikaMathLibrary.approxr((double)this.velocity.magnitude, (double)this.targetVelocity, (double)0.05)) {
                this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
            } else {
                this.velocity.magnitude = this.targetVelocity > this.velocity.magnitude ? (this.velocity.magnitude += 0.01) : (this.velocity.magnitude -= 0.01);
            }
            if (this.field_70122_E || this.field_70163_u <= -18.0) {
                this.velocity.inclination = 90.0;
                this.velocity.magnitude *= 2.0;
                this.field_70163_u += 1.0;
            }
            this.field_70133_I = true;
            double[] v = this.velocity.getCartesian();
            this.field_70159_w = v[0];
            this.field_70181_x = v[1];
            this.field_70179_y = v[2];
            this.doAmbientEffects();
        }
        ++this.colorTransitionTick;
        if (this.colorTransitionTick >= 120) {
            this.color = this.targetColor;
            this.targetColor = this.generateRandomColor();
            this.colorTransitionTick = -80;
        }
        if (this.field_70170_p.field_72995_K) {
            this.lifeParticles();
            if (!this.field_70128_L) {
                this.updateLight();
                if (this.field_70173_aa % 128 == 0) {
                    ReikaEntityHelper.verifyClientEntity((Entity)this);
                }
            }
        }
        this.field_70143_R = 0.0f;
    }

    private void doAmbientEffects() {
        int amtToSpawn;
        TileEntityCrystalTank te2;
        BlockCrystalTank.CrystalTankAuxTile te;
        Coordinate c = new Coordinate((Entity)this);
        if (c.getBlock((IBlockAccess)this.field_70170_p) == ChromaBlocks.TANK.getBlockInstance() && (te = (BlockCrystalTank.CrystalTankAuxTile)c.getTileEntity((IBlockAccess)this.field_70170_p)) != null && (te2 = te.getTankController()) != null && (te2.isEmpty() || te2.getCurrentFluid() == ChromatiCraft.luma)) {
            te2.addFluid(ChromatiCraft.luma, 10);
        }
        int tx = 0;
        int ty = 0;
        int tz = 0;
        if (this.cachedTile != null && this.cachedTile.getDistanceTo((Entity)this) < 8.0) {
            tx = this.cachedTile.xCoord;
            ty = this.cachedTile.yCoord;
            tz = this.cachedTile.zCoord;
        } else {
            this.cachedTile = null;
            tx = MathHelper.func_76128_c((double)ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)3.0));
            ty = MathHelper.func_76128_c((double)ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)3.0));
            tz = MathHelper.func_76128_c((double)ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)3.0));
        }
        TileEntity te3 = this.field_70170_p.func_147438_o(tx, ty, tz);
        int n = amtToSpawn = this.isAngry ? 120 : 40;
        if (te3 instanceof IEnergyHandler) {
            if (((IEnergyHandler)te3).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[this.field_70146_Z.nextInt(6)], amtToSpawn, false) > 0) {
                if (this.cachedTile == null) {
                    this.cachedTile = new Coordinate(te3);
                }
            } else {
                this.cachedTile = null;
            }
        } else if (ModList.IC2.isLoaded() && te3 instanceof IEnergySink) {
            if (((IEnergySink)te3).injectEnergy(ForgeDirection.VALID_DIRECTIONS[this.field_70146_Z.nextInt(6)], (double)amtToSpawn, 32.0) < 50.0) {
                if (this.cachedTile == null) {
                    this.cachedTile = new Coordinate(te3);
                }
            } else {
                this.cachedTile = null;
            }
        } else {
            this.cachedTile = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateLight() {
        Coordinate c;
        int r;
        double d = this.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g);
        int n = d >= 4096.0 ? 64 : (d >= 1024.0 ? 48 : (r = d >= 256.0 ? 32 : 16));
        if (this.field_70173_aa % r == 0 && (d <= 144.0 || ReikaRenderHelper.renderFrustrum.func_78546_a(this.getLightingBox())) && !(c = new Coordinate((Entity)this)).equals((Object)this.light) && c.getBlock((IBlockAccess)this.field_70170_p) == Blocks.field_150350_a) {
            this.deleteOldLight();
            this.oldLight = this.light;
            this.light = c;
            this.light.setBlock(this.field_70170_p, ChromaBlocks.LIGHT.getBlockInstance());
        }
    }

    private AxisAlignedBB getLightingBox() {
        this.lightingBox.func_72324_b(this.field_70121_D.field_72340_a - 3.0, this.field_70121_D.field_72338_b - 3.0, this.field_70121_D.field_72339_c - 3.0, this.field_70121_D.field_72336_d + 3.0, this.field_70121_D.field_72337_e + 3.0, this.field_70121_D.field_72334_f + 3.0);
        return this.lightingBox;
    }

    private void deleteOldLight() {
        if (this.field_70170_p.field_72995_K) {
            if (this.light != null && this.light.getBlock((IBlockAccess)this.field_70170_p) == ChromaBlocks.LIGHT.getBlockInstance()) {
                this.light.setBlock(this.field_70170_p, Blocks.field_150350_a);
            }
            if (this.oldLight != null && this.oldLight.getBlock((IBlockAccess)this.field_70170_p) == ChromaBlocks.LIGHT.getBlockInstance()) {
                this.oldLight.setBlock(this.field_70170_p, Blocks.field_150350_a);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void lifeParticles() {
        int c = this.getRenderColor();
        double d = 0.125;
        double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)d);
        double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)d);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)d);
        int l = ReikaRandomHelper.getRandomBetween((int)10, (int)60);
        float s = 2.0f + this.field_70146_Z.nextFloat() * 2.0f;
        EntityBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz).setColor(c).setLife(l).setScale(s).setAlphaFading().setRapidExpand();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)0.4f);
        d = 0.25;
        px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)d);
        py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)d);
        pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)d);
        fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz).setColor(c).setLife(l / 2).setScale(s * 3.0f).setAlphaFading().setRapidExpand();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74767_n("isdead")) {
            this.func_70106_y();
        }
        this.isAngry = nbt.func_74767_n("angry");
        this.isNaturalSpawn = nbt.func_74767_n("natural");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("isdead", this.field_70128_L);
        nbt.func_74757_a("angry", this.isAngry);
        nbt.func_74757_a("natural", this.isNaturalSpawn);
    }

    private void die() {
        if (this.field_70170_p.field_72995_K) {
            this.doDeathParticles();
        } else {
            this.sendDeathParticles();
        }
        this.deleteOldLight();
        this.func_70106_y();
    }

    private void doDrops(EntityPlayer ep) {
        this.drop(ep, new ItemStack(Items.field_151114_aO, 1 + this.field_70146_Z.nextInt(16), 0));
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.drop(ep, new ItemStack(Items.field_151073_bk));
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.drop(ep, ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.energyPowder, (int)(1 + this.field_70146_Z.nextInt(4))));
        }
    }

    private void drop(EntityPlayer ep, ItemStack is) {
        if (Chromabilities.RANGEDBOOST.enabledOn(ep)) {
            if (ItemInventoryLinker.tryLinkItem(ep, is) && !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ep.field_71071_by)) {
                ReikaItemHelper.dropItem((Entity)this, (ItemStack)is);
            }
        } else {
            ReikaItemHelper.dropItem((Entity)this, (ItemStack)is);
        }
    }

    private void sendDeathParticles() {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.CLOUDDIE.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)this, 32.0), (int[])new int[]{this.func_145782_y()});
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.deleteOldLight();
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.sendDeathParticles();
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 80 == 0) {
            ChromaSounds.GLOWCLOUD.playSound((Entity)this, 0.5f, 1.5f);
        }
        if (this.field_70146_Z.nextInt(40) == 0) {
            ChromaSounds.BUFFERWARNING_LOW.playSound((Entity)this, 1.0f, 0.5f);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer ep;
            if (!this.func_94056_bM()) {
                ep = this.field_70170_p.func_72890_a((Entity)this, -1.0);
                if (ep == null || this.field_70170_p.field_73010_i.isEmpty()) {
                    this.die();
                } else if (this.field_70173_aa >= 80000 || this.field_70146_Z.nextInt(80000 - this.field_70173_aa) == 0) {
                    this.die();
                } else if (this.func_70090_H()) {
                    this.die();
                } else if (this.func_70068_e((Entity)ep) >= 65536.0) {
                    this.die();
                } else if (this.func_70068_e((Entity)ep) >= 16384.0 && this.field_70146_Z.nextInt(200) == 0) {
                    this.die();
                }
            }
            if (this.isAngry) {
                ep = this.field_70170_p.func_72890_a((Entity)this, -1.0);
                if (ep != null) {
                    if (this.attackCooldown > 0) {
                        --this.attackCooldown;
                    } else if (this.func_70068_e((Entity)ep) <= 64.0 && this.field_70146_Z.nextInt(40) == 0) {
                        this.attack();
                    }
                    if (this.velocity != null) {
                        this.velocity.aimFrom(this.field_70165_t, this.field_70163_u, this.field_70161_v, ep.field_70165_t, ep.field_70163_u + 1.62, ep.field_70161_v);
                        this.velocity.magnitude = 0.375;
                        this.field_70133_I = true;
                    }
                }
            } else if (this.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && (ep = this.field_70170_p.func_72890_a((Entity)this, -1.0)) != null && ep.func_70068_e((Entity)this) > 144.0) {
                LOS.setOrigins(ep.field_70165_t, ep.field_70163_u + 1.62, ep.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (LOS.isClearLineOfSight(this.field_70170_p) && this.velocity != null) {
                    this.velocity.aimFrom(this.field_70165_t, this.field_70163_u, this.field_70161_v, ep.field_70165_t, ep.field_70163_u + 1.3, ep.field_70161_v);
                    this.velocity.magnitude = 0.125;
                    this.field_70133_I = true;
                }
            }
        }
    }

    private void attack() {
        if (this.field_70170_p.field_72995_K) {
            this.doAttackFX();
        } else {
            this.doAttack();
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.CLOUDATTACK.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)this, 32.0), (int[])new int[]{this.func_145782_y()});
        }
    }

    private void doAttack() {
        this.attackCooldown = 15;
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)8.0);
        List li = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            if (e instanceof EntityGlowCloud) continue;
            e.func_70097_a(DamageSource.field_76376_m, 4.0f);
            if (!(e instanceof EntityPlayer) || !(e.func_110143_aJ() <= 0.0f)) continue;
            this.isAngry = false;
        }
        this.func_70097_a(ChromatiCraft.pylonDamage[0], 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void doAttackFX() {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.FLAREATTACK, (Entity)this, (float)2.0f, (float)(2.0f * CrystalMusicManager.instance.getRandomScaledDing(CrystalElement.BLACK)));
        int c = this.getRenderColor();
        for (int i = 0; i < 180; ++i) {
            double a1 = this.field_70146_Z.nextDouble() * 360.0;
            double a2 = this.field_70146_Z.nextDouble() * 360.0;
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.5, (double)a1, (double)a2);
            double px = this.field_70165_t + xyz[0];
            double py = this.field_70163_u + xyz[1];
            double pz = this.field_70161_v + xyz[2];
            double v = 0.375;
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz, xyz[0] * v, xyz[1] * v, xyz[2] * v);
            int t = ReikaRandomHelper.getRandomBetween((int)20, (int)60);
            int t2 = (int)((double)t * (0.5 + this.field_70146_Z.nextDouble()));
            float s = 1.0f + 2.0f * this.field_70146_Z.nextFloat();
            fx.setColor(this.color).setAlphaFading().setRapidExpand().setLife(t2).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean func_70601_bi() {
        boolean dim;
        int n = 5;
        boolean bl = dim = this.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue();
        if (dim) {
            if (this.field_70163_u > 6.0) {
                return false;
            }
            n = 3;
        }
        return this.field_70146_Z.nextInt(n) == 0 && !ReikaEntityHelper.existsAnotherValidEntityWithin((Entity)this, (double)(dim ? 20.0 : 32.0), (IEntitySelector)naturalSpawnedSelector);
    }

    public int func_70641_bl() {
        return 8;
    }

    public void func_70642_aH() {
    }

    public final int func_70627_aG() {
        return 20;
    }

    protected final void func_145780_a(int par1, int par2, int par3, Block par4) {
    }

    protected String func_70621_aR() {
        return "mob.bat.takeoff";
    }

    protected String func_70673_aS() {
        return "mob.bat.loop";
    }

    public void func_70645_a(DamageSource src) {
        if (!this.field_70170_p.field_72995_K) {
            this.sendDeathParticles();
        } else {
            this.doDeathParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doDeathParticles() {
        this.deleteOldLight();
        int c = this.getRenderColor();
        for (int i = 0; i < 20; ++i) {
            double a1 = this.field_70146_Z.nextDouble() * 360.0;
            double a2 = this.field_70146_Z.nextDouble() * 360.0;
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)3.0, (double)a1, (double)a2);
            double px = this.field_70165_t + xyz[0];
            double py = this.field_70163_u + xyz[1];
            double pz = this.field_70161_v + xyz[2];
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz);
            int t = ReikaRandomHelper.getRandomBetween((int)10, (int)30);
            int t2 = (int)((double)t * (0.5 + this.field_70146_Z.nextDouble()));
            float s = 1.0f + 2.0f * this.field_70146_Z.nextFloat();
            fx.setPositionController((PositionController)new CollectingPositionController(px, py, pz, this.field_70165_t, this.field_70163_u, this.field_70161_v, t)).setColor(this.color).setAlphaFading().setRapidExpand().setLife(t2).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public int getRenderColor() {
        float f = this.getColorFraction();
        return f > 0.0f ? ReikaColorAPI.mixColors((int)this.targetColor, (int)this.color, (float)f) : this.color;
    }

    private float getColorFraction() {
        return this.colorTransitionTick > 0 ? (float)this.colorTransitionTick / 120.0f : 0.0f;
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        if (this.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            return false;
        }
        Entity e = src.func_76346_g();
        if (src.getClass().getName().equals("tconstruct.smeltery.SmelteryDamageSource")) {
            return false;
        }
        if (e instanceof EntityPlayer) {
            if (!ReikaPlayerAPI.isFake((EntityPlayer)((EntityPlayer)e))) {
                boolean flag = super.func_70097_a(src, dmg);
                if (flag && this.func_110143_aJ() <= 0.0f) {
                    this.die();
                    this.doDrops((EntityPlayer)e);
                }
                this.isAngry = true;
                int n = this.field_70146_Z.nextInt(8);
                int r = this.field_70146_Z.nextInt(64);
                AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)e, (double)r);
                List li = this.field_70170_p.func_94576_a((Entity)this, box, (IEntitySelector)new ReikaEntityHelper.ClassEntitySelector(((Object)((Object)this)).getClass(), true));
                for (int i = 0; i < Math.min(n, li.size()); ++i) {
                    ((EntityGlowCloud)((Object)li.get((int)i))).isAngry = true;
                }
                return flag;
            }
        } else if (src instanceof PylonDamage) {
            boolean flag = super.func_70097_a(src, dmg);
            if (flag && this.func_110143_aJ() <= 0.0f) {
                this.die();
            }
            return flag;
        }
        return false;
    }

    public void aimAwayFrom(double x, double y, double z, double speed) {
        if (this.velocity != null) {
            double dx = -(x - this.field_70165_t);
            double dy = -(y - this.field_70163_u);
            double dz = -(z - this.field_70161_v);
            this.velocity.aimFrom(this.field_70165_t, this.field_70163_u, this.field_70161_v, dx, dy, dz);
            this.velocity.magnitude = speed;
            this.field_70133_I = true;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected void func_70628_a(boolean recentHit, int looting) {
        if (recentHit) {
            // empty if block
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData dat) {
        this.isNaturalSpawn = false;
        return dat;
    }

    public void destroy() {
        if (this.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            this.func_70106_y();
        }
    }

    public static boolean isBlockNonColliding(World world, int x, int y, int z, Block block) {
        if (block == Blocks.field_150399_cn || block == Blocks.field_150397_co || block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
            return true;
        }
        if (block == ChromaBlocks.DYELEAF.getBlockInstance() || block == ChromaBlocks.DECAY.getBlockInstance() || block == ChromaBlocks.GLOWLEAF.getBlockInstance()) {
            return true;
        }
        if (block == ChromaBlocks.TANK.getBlockInstance()) {
            return true;
        }
        if (block.func_149688_o() == Material.field_151592_s && block.getLightOpacity((IBlockAccess)world, x, y, z) == 0) {
            return true;
        }
        if (block.func_149688_o() == Material.field_151584_j || block instanceof BlockLeavesBase || block.isLeaves((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block == ChromaBlocks.STRUCTSHIELD.getBlockInstance() || block == ChromaBlocks.SPECIALSHIELD.getBlockInstance()) {
            return world.func_72805_g(x, y, z) % 8 == BlockStructureShield.BlockType.GLASS.ordinal();
        }
        return false;
    }

    static {
        naturalSpawnedSelector = new IEntitySelector(){

            public boolean func_82704_a(Entity e) {
                return e instanceof EntityGlowCloud && ((EntityGlowCloud)e).isNaturalSpawn;
            }
        };
        LOS = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

