/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Auxiliary.HoldingChecks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LaserPulseEffect;
import Reika.ChromatiCraft.Block.Dimension.Structure.Laser.BlockLaserEffector;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityLaserPulse
extends ParticleEntity
implements IEntityAdditionalSpawnData {
    public RGBColorData color;
    public ReikaDirectionHelper.CubeDirections direction;
    public boolean silentImpact = false;
    private double moveSpeed = 0.1875;

    public EntityLaserPulse(World world) {
        super(world);
    }

    public EntityLaserPulse(World world, int x, int y, int z, ReikaDirectionHelper.CubeDirections dir, RGBColorData c, String l) {
        super(world, x, y, z, dir);
        this.direction = dir;
        this.color = c.copy();
    }

    public void setSpeedFactor(double f) {
        this.moveSpeed *= f;
        this.moveSpeed = Math.min(this.moveSpeed, 0.2);
        this.setDirection(this.direction, true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    protected double getBlockThreshold() {
        return 0.125;
    }

    protected double getDespawnDistance() {
        return 40.0;
    }

    protected void onTick() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(24, (Object)(this.color.red ? 1 : 0));
            this.field_70180_af.func_75692_b(25, (Object)(this.color.green ? 1 : 0));
            this.field_70180_af.func_75692_b(26, (Object)(this.color.blue ? 1 : 0));
        } else {
            this.color.red = this.field_70180_af.func_75679_c(24) > 0;
            this.color.green = this.field_70180_af.func_75679_c(25) > 0;
            this.color.blue = this.field_70180_af.func_75679_c(26) > 0;
            this.spawnParticle();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle() {
        Minecraft mc = Minecraft.func_71410_x();
        int l = 10 + this.field_70146_Z.nextInt(15);
        if (this.field_70146_Z.nextInt(HoldingChecks.MANIPULATOR.isClientHolding() ? 3 : 12) == 0) {
            l *= 16;
        }
        double[] r = new double[]{0.1875, 0.125, 0.0625};
        for (int i = 0; i < r.length; ++i) {
            float s = (1.0f + this.field_70146_Z.nextFloat()) / (float)(i + 1);
            double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)r[i]);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)r[i]);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)r[i]);
            EntityBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz).setIcon(ChromaIcons.FADE_GENTLE).setColor(this.color.getRenderColor()).setLife(l).setScale(s);
            mc.field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void onDeath() {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    private void playTonalSound(SoundEnum s, float vol, float p) {
        if (this.color.red) {
            s.playSound(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, vol, p * 0.5f);
        }
        if (this.color.green) {
            s.playSound(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, vol, p * 0.75f);
        }
        if (this.color.blue) {
            s.playSound(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, vol, p * 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDeathParticle() {
        if (this.silentImpact) {
            return;
        }
        int l = 10 + this.field_70146_Z.nextInt(15);
        int n = 8 + this.field_70146_Z.nextInt(24);
        for (int i = 0; i < n; ++i) {
            float s = 1.0f + this.field_70146_Z.nextFloat();
            double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)0.75);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)0.75);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)0.75);
            EntityBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz).setIcon(ChromaIcons.FADE_RAY).setColor(this.color.getRenderColor()).setLife(l).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b == ChromaBlocks.SPECIALSHIELD.getBlockInstance() && world.func_72805_g(x, y, z) % 8 == BlockStructureShield.BlockType.GLASS.metadata % 8) {
            return false;
        }
        if (b == ChromaBlocks.LASEREFFECT.getBlockInstance()) {
            int meta = world.func_72805_g(x, y, z);
            BlockLaserEffector.LaserEffectType e = BlockLaserEffector.LaserEffectType.list[meta];
            this.playTonalSound((SoundEnum)ChromaSounds.USE, 0.5f, 2.0f);
            return e.affectPulse(world, x, y, z, this);
        }
        if (b instanceof LaserPulseEffect) {
            return ((LaserPulseEffect)b).onImpact(world, x, y, z, this);
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnDeathParticle();
        }
        if (!this.silentImpact) {
            this.playTonalSound((SoundEnum)ChromaSounds.POWERDOWN, 0.5f, 2.0f);
        }
        return true;
    }

    public void reflect(ReikaDirectionHelper.CubeDirections d) {
        int dz;
        int n = d.isCardinal() || d == this.direction.getOpposite() ? 2 : 1;
        int dx = this.direction.directionX + n * d.directionX;
        ReikaDirectionHelper.CubeDirections dir = ReikaDirectionHelper.CubeDirections.getFromVectors((double)dx, (double)(dz = this.direction.directionZ + n * d.directionZ));
        if (dir == null) {
            ChromatiCraft.logger.logError((Object)("Tried to reflect from " + this.direction + " off of " + d + ", vec=" + dx + "," + dz));
            this.func_70106_y();
            return;
        }
        this.setDirection(dir, true);
    }

    public void refract(boolean clockwise) {
        ReikaDirectionHelper.CubeDirections dir = this.direction.getRotation(clockwise);
        this.setDirection(dir, true);
    }

    public void setDirection(ReikaDirectionHelper.CubeDirections dir, boolean setPos) {
        super.setDirection(dir, setPos);
        this.direction = dir;
    }

    public void func_70108_f(Entity e) {
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.color = RGBColorData.white();
        this.color.readFromNBT(tag);
        this.direction = ReikaDirectionHelper.CubeDirections.list[tag.func_74762_e("dir")];
        this.silentImpact = tag.func_74767_n("silent");
        this.moveSpeed = tag.func_74769_h("speed");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.color.writeToNBT(tag);
        tag.func_74768_a("dir", this.direction.ordinal());
        tag.func_74757_a("silent", this.silentImpact);
        tag.func_74780_a("speed", this.moveSpeed);
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        this.color.writeBuf(data);
        data.writeInt(this.direction.ordinal());
        data.writeBoolean(this.silentImpact);
        data.writeDouble(this.moveSpeed);
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.color = RGBColorData.white();
        this.color.readBuf(data);
        this.direction = ReikaDirectionHelper.CubeDirections.list[data.readInt()];
        this.silentImpact = data.readBoolean();
        this.moveSpeed = data.readDouble();
    }

    public boolean despawnOverTime() {
        return false;
    }

    public double getSpeed() {
        return this.moveSpeed;
    }

    public double getHitboxSize() {
        return 0.05;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    public boolean despawnOverDistance() {
        return true;
    }

    public String getLevel() {
        return "";
    }

    public double getRenderRangeSquared() {
        return Double.POSITIVE_INFINITY;
    }
}

