/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Instantiable.ParticleController.EntityLockMotionController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.VoidMonster.Auxiliary.VoidMonsterBait;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@APIStripper.Strippable(value={"Reika.VoidMonster.Auxiliary.VoidMonsterBait"})
public class EntityMonsterBait
extends InertEntity
implements IEntityAdditionalSpawnData,
VoidMonsterBait {
    private static final int MIN_LIFE = 100;
    private static final int MAX_LIFE = 600;
    private UUID placer;
    private int lifespan;
    private int life;
    private EntityMob currentEntity;

    public EntityMonsterBait(World world) {
        super(world);
    }

    public EntityMonsterBait(World world, EntityPlayer ep) {
        super(world);
        this.setLifeSpan(ReikaRandomHelper.getRandomBetween((int)100, (int)600));
        this.func_70012_b(ep.field_70165_t, ep.field_70163_u + (double)(ep.func_70047_e() / 4.0f), ep.field_70161_v, 0.0f, 0.0f);
        this.placer = ep.getPersistentID();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.currentEntity = this.findClosestValidMob();
        if (this.field_70170_p.field_72995_K) {
            this.life = this.field_70180_af.func_75679_c(24);
            if (this.life > 5) {
                this.doParticles();
            }
        } else {
            if (this.isActive() && this.currentEntity != null) {
                this.currentEntity.func_70784_b((Entity)this);
            }
            --this.life;
            if (this.life <= 0) {
                this.func_70106_y();
            } else {
                this.field_70180_af.func_75692_b(24, (Object)this.life);
            }
        }
    }

    private EntityMob findClosestValidMob() {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)16.0);
        List li = this.field_70170_p.func_72872_a(EntityMob.class, box);
        EntityMob ret = null;
        double maxd = Double.POSITIVE_INFINITY;
        for (EntityMob e : li) {
            double dist;
            Entity tgt;
            if (e.field_70128_L || (tgt = e.func_70777_m()) != this && tgt instanceof EntityMonsterBait || !((dist = e.func_70068_e((Entity)this)) < maxd)) continue;
            maxd = dist;
            ret = e;
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles() {
        int n = 1 + this.field_70146_Z.nextInt(4);
        for (int i = 0; i < n; ++i) {
            double r = ReikaRandomHelper.getRandomPlusMinus((double)0.5, (double)0.0625);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)r, (double)0.0, (double)(this.field_70146_Z.nextDouble() * 360.0));
            int c = ReikaColorAPI.mixColors((int)0xA0A0A0, (int)0xFFFFFF, (float)Math.min(this.field_70146_Z.nextFloat(), this.getBrightness()));
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.035);
            int l = Math.min(this.life, ReikaRandomHelper.getRandomBetween((int)10, (int)80));
            float s = (float)ReikaRandomHelper.getRandomBetween((double)0.5, (double)2.0);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_70170_p, this.field_70165_t + xyz[0], this.field_70163_u + xyz[1], this.field_70161_v + xyz[2]);
            fx.setGravity(g).setLife(l).setScale(s);
            fx.setIcon(ChromaIcons.FADE_GENTLE).setAlphaFading().setRapidExpand().forceIgnoreLimits();
            if (this.currentEntity != null) {
                EntityLockMotionController m = new EntityLockMotionController((Entity)this.currentEntity, 0.00390625, 0.5, 0.875);
                fx.setMotionController((MotionController)m);
                c = ReikaColorAPI.mixColorBiDirectional((int)ReikaEntityHelper.mobToColor((EntityLivingBase)this.currentEntity), (int)0, (int)0xFFFFFF, (float)((float)ReikaRandomHelper.getRandomPlusMinus((double)0.5, (double)0.25)));
            }
            fx.setColor(c);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.setLifeSpan(tag.func_74762_e("life"));
        if (tag.func_74764_b("placer")) {
            this.placer = UUID.fromString(tag.func_74779_i("placer"));
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.placer != null) {
            tag.func_74778_a("placer", this.placer.toString());
        }
        tag.func_74768_a("life", this.lifespan);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.lifespan);
        if (this.placer != null) {
            buf.writeBoolean(true);
            ReikaPacketHelper.writeString((ByteBuf)buf, (String)this.placer.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.setLifeSpan(buf.readInt());
        boolean has = buf.readBoolean();
        if (has) {
            this.placer = UUID.fromString(ReikaPacketHelper.readString((ByteBuf)buf));
        }
    }

    private void setLifeSpan(int val) {
        this.lifespan = this.life = val;
    }

    public boolean isActive() {
        return this.placer != null && this.life > 0;
    }

    public double maxRangeSquared() {
        return 100.0;
    }

    public void attack(double dmg) {
        this.life = (int)((double)this.life - dmg / 4.0);
        if (this.life <= 0) {
            this.func_70106_y();
        }
    }

    public int getLife() {
        return this.life;
    }

    public float getBrightness() {
        return this.life <= 0 ? 0.0f : (this.life >= 100 ? 1.0f : (float)Math.sqrt((float)this.life / 100.0f));
    }

    public int getRenderColor(double layer) {
        if (this.currentEntity != null) {
            float f = (float)(0.5 + 0.25 * Math.sin((double)this.field_70173_aa / 12.0 + layer * 60.0));
            return ReikaColorAPI.mixColorBiDirectional((int)ReikaEntityHelper.mobToColor((EntityLivingBase)this.currentEntity), (int)0, (int)0xFFFFFF, (float)f);
        }
        int c0 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)this.getBrightness());
        return ReikaColorAPI.getColorWithBrightnessMultiplier((int)c0, (float)(0.65f + (float)((double)0.35f * Math.sin((double)this.field_70173_aa / 10.0 + layer * 40.0))));
    }
}

