/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Magic.Interfaces.CrystalFuse;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityOverloadingPylonShock
extends InertEntity
implements IEntityAdditionalSpawnData {
    private CrystalElement color;
    private final ArrayList<DecimalPosition> path = new ArrayList();
    private Coordinate target;
    private int damageFactor;

    public EntityOverloadingPylonShock(World world) {
        super(world);
        this.target = null;
    }

    public EntityOverloadingPylonShock(World world, TileEntityCrystalPylon te, ArrayList<Coordinate> path, double speed, int dmg) {
        super(world);
        this.damageFactor = dmg;
        this.color = te.getColor();
        for (int i = 0; i < path.size() - 1; ++i) {
            Coordinate c1 = path.get(i);
            Coordinate c2 = path.get(i + 1);
            int t = 0;
            while ((double)t < speed) {
                this.path.add(DecimalPosition.interpolate((double)((double)c1.xCoord + 0.5), (double)((double)c1.yCoord + 0.5), (double)((double)c1.zCoord + 0.5), (double)((double)c2.xCoord + 0.5), (double)((double)c2.yCoord + 0.5), (double)((double)c2.zCoord + 0.5), (double)((double)t / speed)));
                ++t;
            }
        }
        this.target = path.get(path.size() - 1);
        this.func_70012_b((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, 0.0f, 0.0f);
    }

    public static double getRandomSpeed() {
        return ReikaRandomHelper.getRandomBetween((double)7.0, (double)15.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.path.isEmpty()) {
            DecimalPosition pos = this.path.get(Math.min(this.field_70173_aa, this.path.size() - 1));
            this.func_70012_b(pos.xCoord, pos.yCoord, pos.zCoord, 0.0f, 0.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.doParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else if (this.field_70173_aa >= this.path.size()) {
            this.func_70106_y();
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false);
            if (this.field_70146_Z.nextInt(8 / this.damageFactor) == 0) {
                TileEntity te = this.target.getTileEntity((IBlockAccess)this.field_70170_p);
                if (te instanceof TileEntityCrystalPylon) {
                    if (this.field_70146_Z.nextInt(8 / this.damageFactor) == 0) {
                        ((TileEntityCrystalPylon)te).destabilize();
                    }
                } else if (te instanceof CrystalFuse) {
                    ((CrystalFuse)te).overload(this.color);
                } else {
                    ReikaWorldHelper.dropAndDestroyBlockAt((World)this.field_70170_p, (int)this.target.xCoord, (int)this.target.yCoord, (int)this.target.zCoord, null, (boolean)true, (boolean)true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, double x, double y, double z) {
        EntityCCBlurFX fx = new EntityCCBlurFX(world, x, y, z);
        fx.setAlphaFading().setRapidExpand().setScale(32.0f).setColor(this.color.getColor()).setLife(12);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.color.ordinal());
        buf.writeInt(this.path.size());
        for (DecimalPosition p : this.path) {
            p.writeToBuf(buf);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.color = CrystalElement.elements[buf.readInt()];
        int len = buf.readInt();
        this.path.clear();
        for (int i = 0; i < len; ++i) {
            DecimalPosition p = DecimalPosition.readFromBuf((ByteBuf)buf);
            this.path.add(p);
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.color = CrystalElement.elements[tag.func_74762_e("color")];
        this.path.clear();
        NBTTagList li = tag.func_150295_c("path", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            this.path.add(DecimalPosition.readTag((NBTTagCompound)((NBTTagCompound)o)));
        }
        this.target = Coordinate.readFromNBT((String)"tgt", (NBTTagCompound)tag);
        this.damageFactor = tag.func_74762_e("dmg");
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("color", this.color.ordinal());
        NBTTagList li = new NBTTagList();
        for (DecimalPosition p : this.path) {
            li.func_74742_a((NBTBase)p.writeToTag());
        }
        tag.func_74782_a("path", (NBTBase)li);
        this.target.writeToNBT("tgt", tag);
        tag.func_74768_a("dmg", this.damageFactor);
    }

    public boolean func_90999_ad() {
        return false;
    }
}

