/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.DragonAPI.Base.InertEntity;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityParticleCluster
extends InertEntity
implements IEntityAdditionalSpawnData {
    public static final int MIN_MOVEMENT_DELAY = 20;
    public static final int MAX_MOVEMENT_DELAY = 120;
    public static final int MIN_MOVEMENT_TIME = 0;
    public static final int MAX_MOVEMENT_TIME = 20;
    private static final double MOVEMENT_DISTANCE = 2.0;
    private static final int MIN_PARTICLES = 7;
    private static final int MAX_PARTICLES = 20;
    private int ticksUntilMove;
    private int movingParticles;
    private final Collection<Particle> particles = new ArrayList<Particle>();

    public EntityParticleCluster(World world, double x, double y, double z) {
        super(world);
        int n = ReikaRandomHelper.getRandomPlusMinus((int)7, (int)20);
        for (int i = 0; i < n; ++i) {
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)x, (double)1.0);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)y, (double)1.0);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)z, (double)1.0);
            this.particles.add(new Particle(dx, dy, dz));
        }
        this.func_70107_b(x, y, z);
        ReikaJavaLibrary.pConsole((Object)(this.particles.size() + ":" + (Object)((Object)this)));
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public EntityParticleCluster(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (Particle p : this.particles) {
            p.update(this);
        }
        if (this.ticksUntilMove > 0 && this.movingParticles == 0) {
            --this.ticksUntilMove;
        }
        if (this.ticksUntilMove == 0) {
            this.move();
        }
    }

    private void move() {
        int deg = 30 + this.field_70146_Z.nextInt(6) * 60;
        double dx = 2.0 * Math.cos(Math.toRadians(deg));
        double dz = 2.0 * Math.sin(Math.toRadians(deg));
        for (Particle p : this.particles) {
            p.startMoving(this, dx, dz);
        }
        this.movingParticles = this.particles.size();
        this.ticksUntilMove = ReikaRandomHelper.getRandomBetween((int)20, (int)120);
    }

    public Collection<Particle> getParticles() {
        return Collections.unmodifiableCollection(this.particles);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.particles.size());
        for (Particle p : this.particles) {
            p.writeToBuf(buf);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        int n = buf.readInt();
        for (int i = 0; i < n; ++i) {
            Particle p = Particle.createFromBuf(buf);
            this.particles.add(p);
        }
    }

    public static class Particle {
        private double posX;
        private double posY;
        private double posZ;
        private double lastPosX;
        private double lastPosY;
        private double lastPosZ;
        private int ticksUntilMove;
        private int moveProgress;
        private double moveDistanceX;
        private double moveDistanceZ;
        private static final double[] MOTION = new double[]{0.0, 0.03125, 0.125, 0.25, 0.5, 0.75, 0.875, 0.9375, 1.0};

        private Particle(double x, double y, double z) {
            this.posX = this.lastPosX = x;
            this.posY = this.lastPosY = y;
            this.posZ = this.lastPosZ = z;
            this.moveProgress = -1;
            this.ticksUntilMove = -1;
        }

        public void writeToBuf(ByteBuf buf) {
            buf.writeDouble(this.posX);
            buf.writeDouble(this.posY);
            buf.writeDouble(this.posZ);
        }

        public static Particle createFromBuf(ByteBuf buf) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            return new Particle(x, y, z);
        }

        private void update(EntityParticleCluster parent) {
            if (this.ticksUntilMove > 0) {
                --this.ticksUntilMove;
            } else if (this.moveProgress >= 0) {
                this.posX = this.lastPosX + this.moveDistanceX * MOTION[this.moveProgress];
                this.posZ = this.lastPosZ + this.moveDistanceZ * MOTION[this.moveProgress];
                ++this.moveProgress;
                if (this.moveProgress == MOTION.length - 1) {
                    this.finishMoving(parent);
                }
            }
        }

        private void startMoving(EntityParticleCluster parent, double dx, double dz) {
            this.ticksUntilMove = ReikaRandomHelper.getRandomBetween((int)0, (int)20);
            this.moveDistanceX = dx;
            this.moveDistanceZ = dz;
            this.moveProgress = 0;
        }

        private void finishMoving(EntityParticleCluster parent) {
            this.lastPosX += this.moveDistanceX;
            this.lastPosZ += this.moveDistanceZ;
            this.moveProgress = -1;
            parent.movingParticles--;
            if (parent.movingParticles == 0) {
                parent.field_70165_t += this.moveDistanceX;
                parent.field_70161_v += this.moveDistanceZ;
                parent.field_70142_S = parent.field_70165_t;
                parent.field_70137_T = parent.field_70163_u;
                parent.field_70136_U = parent.field_70161_v;
            }
        }

        public double getRenderPosX(float ptick) {
            if (this.moveProgress == -1) {
                return this.posX;
            }
            double avg = ReikaMathLibrary.getUnequalAverage((double)MOTION[this.moveProgress], (double)MOTION[this.moveProgress + 1], (double)ptick);
            return this.lastPosX + this.moveDistanceX * avg;
        }

        public double getRenderPosZ(float ptick) {
            if (this.moveProgress == -1) {
                return this.posZ;
            }
            double avg = ReikaMathLibrary.getUnequalAverage((double)MOTION[this.moveProgress], (double)MOTION[this.moveProgress + 1], (double)ptick);
            return this.lastPosZ + this.moveDistanceZ * avg;
        }
    }
}

