/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape.BlockPistonTarget;
import Reika.ChromatiCraft.Entity.EntitySplineProjectile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityPistonSpline
extends EntitySplineProjectile {
    public RGBColorData color = RGBColorData.white();

    public EntityPistonSpline(World world, Spline s, RGBColorData clr) {
        super(world, s, 20);
        this.color = clr;
    }

    public EntityPistonSpline(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    @Override
    protected void onTick() {
        super.onTick();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(24, (Object)(this.color.red ? 1 : 0));
            this.field_70180_af.func_75692_b(25, (Object)(this.color.green ? 1 : 0));
            this.field_70180_af.func_75692_b(26, (Object)(this.color.blue ? 1 : 0));
        } else {
            this.color.red = this.field_70180_af.func_75679_c(24) > 0;
            this.color.green = this.field_70180_af.func_75679_c(25) > 0;
            this.color.blue = this.field_70180_af.func_75679_c(26) > 0;
            this.spawnParticle();
            if (this.field_70173_aa % 40 == 0) {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.FIRE, (Entity)this, (float)0.3f, (float)0.5f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticle() {
        Minecraft mc = Minecraft.func_71410_x();
        int n = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
        double r = 0.125;
        for (int i = 0; i < n; ++i) {
            int l = ReikaRandomHelper.getRandomBetween((int)20, (int)60);
            double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)r);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)r);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)r);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)2.25, (double)3.75);
            float g = this.field_70146_Z.nextInt(3) > 0 ? 0.0f : (float)ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.125);
            int c = this.color.getRenderColor();
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_70170_p, px, py, pz);
            fx.setColor(c).setLife(l).setScale(s).setGravity(g);
            fx.setIcon(ChromaIcons.FADE_GENTLE).setAlphaFading().setRapidExpand().forceIgnoreLimits();
            mc.field_71452_i.func_78873_a((EntityFX)fx);
            EntityCCBlurFX fx2 = new EntityCCBlurFX(this.field_70170_p, px, py, pz);
            fx2.setColor(0xFFFFFF).setLife(l).setScale(s * 0.72f).setGravity(g).forceIgnoreLimits();
            fx2.setIcon(ChromaIcons.FADE).setAlphaFading().setRapidExpand();
            fx2.lockTo((EntityFX)fx);
            mc.field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.color = RGBColorData.white();
        this.color.readFromNBT(tag);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.color.writeToNBT(tag);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        this.color.writeBuf(data);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.color = RGBColorData.white();
        this.color.readBuf(data);
    }

    @Override
    protected boolean onEnterBlock(World world, int x, int y, int z) {
        Coordinate end;
        Block b = world.func_147439_a(x, y, z);
        if (b == ChromaBlocks.PISTONTARGET.getBlockInstance() && (end = this.getFinalPathBlock()) != null && end.equals(x, y, z)) {
            ((BlockPistonTarget)b).receiveSplineParticle(world, x, y, z, this);
            return true;
        }
        return false;
    }
}

