/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class EntitySplineProjectile
extends ParticleEntity
implements IEntityAdditionalSpawnData {
    private int pathTick = 0;
    private boolean hitTarget;
    private final List<DecimalPosition> path;

    public EntitySplineProjectile(World world, Spline s, int fineness) {
        super(world, 0, 0, 0);
        this.path = s.get(fineness, false);
        DecimalPosition pos = this.path.get(0);
        this.spawnAt(pos.getCoordinate());
        this.setPosition(pos);
    }

    public EntitySplineProjectile(World world) {
        super(world);
        this.path = new ArrayList<DecimalPosition>();
    }

    public Coordinate getFinalPathBlock() {
        return this.path == null || this.path.isEmpty() ? null : this.path.get(this.path.size() - 1).getCoordinate();
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(ByteBuf buf) {
        super.writeSpawnData(buf);
        buf.writeInt(this.path.size());
        for (DecimalPosition p : this.path) {
            p.writeToBuf(buf);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        super.readSpawnData(buf);
        this.path.clear();
        int n = buf.readInt();
        for (int i = 0; i < n; ++i) {
            DecimalPosition p = DecimalPosition.readFromBuf((ByteBuf)buf);
            this.path.add(p);
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.path.clear();
        NBTTagList li = tag.func_150295_c("path", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            DecimalPosition p = DecimalPosition.readTag((NBTTagCompound)((NBTTagCompound)o));
            this.path.add(p);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagList li = new NBTTagList();
        for (DecimalPosition p : this.path) {
            li.func_74742_a((NBTBase)p.writeToTag());
        }
        tag.func_74782_a("path", (NBTBase)li);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected void onTick() {
        if (this.path != null) {
            if (this.hitTarget) {
                this.func_70106_y();
            } else {
                DecimalPosition p = this.path.get(this.pathTick);
                this.setPosition(p);
                this.pathTick = Math.min(this.pathTick + 1, this.path.size() - 1);
            }
            this.field_70133_I = true;
        } else {
            ReikaJavaLibrary.pConsole((Object)"Clearing pulse, no path");
            this.func_70106_y();
        }
    }

    private void setPosition(DecimalPosition p) {
        double v = 0.0625;
        this.field_70159_w = (p.xCoord - this.field_70165_t) * v;
        this.field_70181_x = (p.yCoord - this.field_70163_u) * v;
        this.field_70179_y = (p.zCoord - this.field_70161_v) * v;
        this.field_70165_t = p.xCoord;
        this.field_70163_u = p.yCoord;
        this.field_70161_v = p.zCoord;
        p = this.pathTick == 0 ? this.path.get(0) : this.path.get(this.pathTick - 1);
        this.field_70142_S = p.xCoord;
        this.field_70137_T = p.yCoord;
        this.field_70136_U = p.zCoord;
        this.field_70169_q = p.xCoord;
        this.field_70167_r = p.yCoord;
        this.field_70166_s = p.zCoord;
    }

    public float getRenderSize() {
        return 0.125f;
    }

    public double getRenderRangeSquared() {
        return 4096.0;
    }

    public double getHitboxSize() {
        return 0.125;
    }

    public boolean despawnOverTime() {
        return false;
    }

    public boolean despawnOverDistance() {
        return false;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    public double getSpeed() {
        return 0.0;
    }

    protected boolean dieOnNoVelocity() {
        return false;
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        return false;
    }

    public void func_70108_f(Entity e) {
    }
}

