/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Entity.EntityDimensionFlare;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.EntityTumblingBlock;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Block.SelectiveMovable;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.Entity.CustomProjectile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityVacuum
extends Entity
implements IEntityAdditionalSpawnData,
CustomProjectile {
    public static final int ACTIVATION_TIME = 60;
    private EntityPlayer firingPlayer;
    private boolean isActivated;
    private int lifespan;
    private int entityRange;
    private int blockRange;

    public EntityVacuum(World world, EntityPlayer ep, boolean randomVec) {
        super(world);
        this.lifespan = 400 + this.field_70146_Z.nextInt(200) + 60;
        this.entityRange = ReikaRandomHelper.getRandomPlusMinus((int)10, (int)2);
        this.blockRange = ReikaRandomHelper.getRandomPlusMinus((int)6, (int)2);
        this.field_70145_X = true;
        this.firingPlayer = ep;
        Vec3 vec = ep.func_70040_Z();
        if (randomVec) {
            vec.field_72450_a = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.field_72448_b = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.field_72449_c = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.0);
            vec.func_72432_b();
        }
        double v = 0.85;
        this.field_70159_w = v * vec.field_72450_a;
        this.field_70181_x = v * vec.field_72448_b;
        this.field_70179_y = v * vec.field_72449_c;
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntityVacuum(World world) {
        super(world);
        this.lifespan = 400 + this.field_70146_Z.nextInt(200) + 60;
        this.entityRange = ReikaRandomHelper.getRandomPlusMinus((int)10, (int)2);
        this.blockRange = ReikaRandomHelper.getRandomPlusMinus((int)6, (int)2);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.isActivated) {
            if (!this.field_70170_p.field_72995_K) {
                this.suckInBlocks();
                this.suckInEntities();
            }
        } else if (this.field_70173_aa >= 60) {
            this.activate();
        } else {
            if (this.field_70170_p.field_72995_K) {
                this.travelParticles();
            }
            if (this.field_70173_aa >= 50) {
                this.field_70159_w *= 0.8;
                this.field_70181_x *= 0.8;
                this.field_70179_y *= 0.8;
            }
        }
        if (this.field_70173_aa > this.lifespan) {
            this.destroy();
        }
        ++this.field_70173_aa;
    }

    private void destroy() {
        if (!this.field_70170_p.field_72995_K) {
            PacketTarget.RadiusTarget pt = new PacketTarget.RadiusTarget((Entity)this, 48.0);
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.VACUUMGUNEND.ordinal(), (PacketTarget)pt, (int[])new int[]{this.func_145782_y()});
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void travelParticles() {
        int n = 2 + this.field_70146_Z.nextInt(9);
        for (int i = 0; i < n; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)0.0625);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)0.0625);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)0.0625);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.025);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.025);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.5, (double)0.25);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            int l = 10 + this.field_70146_Z.nextInt(30);
            EntitySparkleFX fx = new EntitySparkleFX(this.field_70170_p, rx, ry, rz, vx, 0.0, vz).setGravity(g).setScale(s).setLife(l);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doDestroyParticles(int entityID) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        int n = 92 + e.field_70170_p.field_73012_v.nextInt(192);
        for (int i = 0; i < n; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)0.005);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70163_u, (double)0.005);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)0.005);
            double v = 0.5 + e.field_70170_p.field_73012_v.nextDouble();
            double[] vp = ReikaPhysicsHelper.polarToCartesian((double)v, (double)(e.field_70170_p.field_73012_v.nextDouble() * 360.0), (double)(e.field_70170_p.field_73012_v.nextDouble() * 360.0));
            float s = 0.5f + e.field_70170_p.field_73012_v.nextFloat() * 4.0f;
            int l = 5 + e.field_70170_p.field_73012_v.nextInt(20) * (1 + e.field_70170_p.field_73012_v.nextInt(2));
            CrystalElement c = CrystalElement.randomElement();
            EntityBlurFX fx = new EntityCCBlurFX(c, e.field_70170_p, rx, ry, rz, vp[0], vp[1], vp[2]).setNoSlowdown().setScale(s).setRapidExpand().setLife(l);
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void activate() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.isActivated = true;
    }

    private void suckInEntities() {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b((double)this.entityRange, (double)this.entityRange, (double)this.entityRange);
        List li = this.field_70170_p.func_72872_a(Entity.class, box);
        for (Entity e : li) {
            if (e instanceof EntityVacuum) continue;
            this.suck(e);
            if (e == this.firingPlayer || !(this.func_70032_d(e) <= 1.0f)) continue;
            e.func_70097_a(DamageSource.field_76376_m, 1.0f);
        }
    }

    private void suckInBlocks() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int i = -this.blockRange; i <= this.blockRange; ++i) {
            for (int j = -this.blockRange; j <= this.blockRange; ++j) {
                for (int k = -this.blockRange; k <= this.blockRange; ++k) {
                    int meta;
                    Block b;
                    if (!((double)(i * i + j * j + k * k) <= (double)(this.blockRange * this.blockRange) + 0.5)) continue;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (y < 0 || y > 255 || !this.canMove(b = this.field_70170_p.func_147439_a(dx, dy, dz), meta = this.field_70170_p.func_72805_g(dx, dy, dz), this.field_70170_p, dx, dy, dz)) continue;
                    EntityTumblingBlock e = new EntityTumblingBlock(this.field_70170_p, (double)dx, (double)dy, (double)dz, b, this.field_70170_p.func_72805_g(dx, dy, dz));
                    e.field_145812_b = -10000;
                    e.field_145813_c = false;
                    TileEntity te = this.field_70170_p.func_147438_o(dx, dy, dz);
                    if (te != null) {
                        e.field_145810_d = new NBTTagCompound();
                        te.func_145841_b(e.field_145810_d);
                    }
                    this.field_70170_p.func_147468_f(dx, dy, dz);
                    this.field_70170_p.func_72838_d((Entity)e);
                }
            }
        }
    }

    private boolean canMove(Block b, int meta, World world, int x, int y, int z) {
        if (b.field_149782_v < 0.0f) {
            return false;
        }
        if (ReikaBlockHelper.isUnbreakable((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayer)this.firingPlayer)) {
            return false;
        }
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b instanceof SemiUnbreakable) {
            return !((SemiUnbreakable)b).isUnbreakable(world, x, y, z, world.func_72805_g(x, y, z));
        }
        if (ReikaBlockHelper.isLiquid((Block)b) && world.func_72805_g(x, y, z) != 0) {
            return false;
        }
        if (b instanceof SelectiveMovable && !((SelectiveMovable)b).canMove(world, x, y, z)) {
            return false;
        }
        return world.field_72995_K || ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)this.firingPlayer));
    }

    private void suck(Entity e) {
        double dx = e.field_70165_t - this.field_70165_t;
        double dy = e.field_70163_u - this.field_70163_u;
        double dz = e.field_70161_v - this.field_70161_v;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = -0.125;
        if (this.field_70173_aa == this.lifespan) {
            v = 0.5 + this.field_70146_Z.nextDouble();
            e.field_70181_x += 1.0 + this.field_70146_Z.nextDouble() * 2.0;
        }
        e.field_70159_w += v * dx / dd;
        e.field_70181_x += v * dy / dd + 0.04;
        e.field_70179_y += v * dz / dd;
        e.field_70145_X = false;
        e.field_70133_I = true;
        if (e instanceof EntityDimensionFlare) {
            ((EntityDimensionFlare)e).aggroTo(this.firingPlayer);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound NBT) {
        this.field_70173_aa = NBT.func_74762_e("tick");
    }

    protected void func_70014_b(NBTTagCompound NBT) {
        NBT.func_74768_a("tick", this.field_70173_aa);
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public final boolean func_70075_an() {
        return false;
    }

    public final boolean func_85032_ar() {
        return true;
    }

    public final boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.lifespan);
    }

    public void readSpawnData(ByteBuf buf) {
        this.lifespan = buf.readInt();
    }

    public Entity getFiringEntity() {
        return this.firingPlayer;
    }
}

