/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.GuiBookSection;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.IO.DelegateFontRenderer;
import Reika.DragonAPI.Instantiable.AlphabeticItemComparator;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Event.NEIRecipeCheckEvent;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModList;
import codechicken.nei.NEIClientConfig;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class GuiCraftingRecipe
extends GuiBookSection {
    private final ArrayList<IRecipe> recipes;
    private int index = 0;
    private int recipeTextOffset = 0;
    private boolean centeredMouse = false;

    public GuiCraftingRecipe(EntityPlayer ep, ArrayList<IRecipe> out, int offset) {
        super(ChromaGuis.CRAFTING, ep, null, 256, 220, false);
        this.recipes = new ArrayList<IRecipe>(out);
        this.index = offset;
    }

    private IRecipe getActiveRecipe() {
        return this.recipes.get(this.index);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        if (this.recipes.size() > 1) {
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j + 205, k - 3, 10, 12, 183, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, j + 215, k - 3, 10, 12, 193, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        }
        if (this.subpage == 0 && this.getItemCounts().size() > 10) {
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + 205, k + 50, 12, 10, 100, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + 205, k + 60, 12, 10, 112, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        }
    }

    public final void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (ModList.NEI.isLoaded() && key == NEIClientConfig.getKeyBinding((String)"gui.recipe") && !NEIClientConfig.isHidden()) {
            ItemStack is;
            int x = ReikaGuiAPI.instance.getMouseRealX();
            int y = ReikaGuiAPI.instance.getMouseRealY();
            int j = (this.field_146294_l - this.xSize) / 2;
            int k = (this.field_146295_m - this.ySize) / 2;
            if (x >= j && y >= k && x < j + this.xSize && y < k + this.ySize && (is = ReikaGuiAPI.instance.getItemRenderAt(x, y)) != null) {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.33f, (float)1.0f);
                if (!MinecraftForge.EVENT_BUS.post((Event)new NEIRecipeCheckEvent(null, is))) {
                    codechicken.nei.recipe.GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{is});
                }
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.index > 0) {
            --this.index;
            this.recipeTextOffset = 0;
            this.subpage = Math.min(this.subpage, this.getMaxSubpage());
        } else if (button.field_146127_k == 1 && this.index < this.recipes.size() - 1) {
            ++this.index;
            this.recipeTextOffset = 0;
            this.subpage = Math.min(this.subpage, this.getMaxSubpage());
        }
        if (button.field_146127_k == 2 && this.recipeTextOffset > 0) {
            --this.recipeTextOffset;
        } else if (button.field_146127_k == 3 && this.recipeTextOffset < this.getItemCounts().size() - 11) {
            ++this.recipeTextOffset;
        }
        super.func_146284_a(button);
        this.func_73866_w_();
    }

    @Override
    protected GuiBookSection.PageType getGuiLayout() {
        return GuiBookSection.PageType.CRAFTING;
    }

    private final void drawRecipes() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2;
        try {
            this.drawAuxData(posX, posY);
        }
        catch (Exception e) {
            ReikaChatHelper.write((Object)Arrays.toString(e.getStackTrace()));
            e.printStackTrace();
        }
    }

    protected void drawAuxData(int posX, int posY) {
        IRecipe ir = this.getActiveRecipe();
        ItemStack[] arr = ReikaRecipeHelper.getPermutedRecipeArray((IRecipe)ir);
        if (arr == null) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            ItemStack is = arr[i];
            if (is == null) continue;
            int x = posX + 54 + i % 3 * 18;
            int y = posY + 10 + i / 3 * 18;
            api.drawItemStackWithTooltip(field_146296_j, this.field_146289_q, is, x, y);
        }
        api.drawItemStackWithTooltip(field_146296_j, this.field_146289_q, ir.func_77571_b(), posX + 7, posY + 5);
    }

    private final void drawGraphics() {
        int posX = (this.field_146294_l - this.xSize) / 2 - 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        ReikaRenderHelper.disableLighting();
        int msx = ReikaGuiAPI.instance.getMouseRealX();
        int msy = ReikaGuiAPI.instance.getMouseRealY();
        this.drawAuxGraphics(posX, posY);
    }

    @Override
    public int getMaxSubpage() {
        return 0;
    }

    private ItemHashMap<Integer> getItemCounts() {
        return ReikaRecipeHelper.getItemCountsForDisplay((IRecipe)this.getActiveRecipe());
    }

    protected void drawAuxGraphics(int posX, int posY) {
        ItemHashMap<Integer> items = this.getItemCounts();
        ArrayList li = new ArrayList(items.keySet());
        Collections.sort(li, new AlphabeticItemComparator());
        for (int i = this.recipeTextOffset; i < li.size(); ++i) {
            ItemStack is = (ItemStack)li.get(i);
            int num = (Integer)items.get(is);
            String s0 = is.func_82833_r();
            String s = String.format(": x%d", num);
            ChromaFontRenderer fr = s0.contains(ChromaFontRenderer.FontType.OBFUSCATED.id) ? ChromaFontRenderer.FontType.OBFUSCATED.renderer : this.field_146289_q;
            s0 = DelegateFontRenderer.stripFlags((String)s0);
            fr.func_78276_b(s0, posX + 8 + 3, posY + 88 + (((FontRenderer)fr).field_78288_b + 2) * (i - this.recipeTextOffset), 0xFFFFFF);
            this.field_146289_q.func_78276_b(s, posX + 8 + 3 + fr.func_78256_a(s0), posY + 88 + (((FontRenderer)fr).field_78288_b + 2) * (i - this.recipeTextOffset), 0xFFFFFF);
            if (i - this.recipeTextOffset > 9) break;
        }
    }

    @Override
    public final void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        this.drawRecipes();
        this.drawGraphics();
        RenderHelper.func_74518_a();
    }

    @Override
    public String getPageTitle() {
        return this.getActiveRecipe().func_77571_b().func_82833_r();
    }

    @Override
    protected int getTitleOffset() {
        return 27;
    }
}

