/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Base.GuiBookSection;
import Reika.ChromatiCraft.Base.GuiDescription;
import Reika.ChromatiCraft.Base.TileEntity.ChargedCrystalPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ISBRH.CrystalRenderer;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiMachineDescription
extends GuiDescription {
    private float renderq = 22.5f;
    public static boolean runningRender = false;

    public GuiMachineDescription(EntityPlayer ep, ChromaResearch r) {
        super(ChromaGuis.MACHINEDESC, ep, r, 256, 220);
    }

    @Override
    protected GuiBookSection.PageType getGuiLayout() {
        return GuiBookSection.PageType.PLAIN;
    }

    @Override
    protected int getMaxSubpage() {
        if (this.page == ChromaResearch.ACCEL) {
            return 17;
        }
        int max = super.getMaxSubpage();
        if (max == 0 && this.getUsedEnergy() != null) {
            max = 1;
        }
        return max;
    }

    @Override
    protected int parseMaxSubpage() {
        int ret = super.parseMaxSubpage();
        if (ret == 0 && this.getUsedEnergy() != null) {
            ret = 1;
        }
        return ret;
    }

    private ElementTagCompound getUsedEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        ChromaTiles m = this.page.getMachine();
        TileEntity te = m.createTEInstanceForRender(0);
        if (m == ChromaTiles.ADJACENCY) {
            ArrayList<Integer> li = new ArrayList<Integer>();
            for (int i = 0; i < CrystalElement.elements.length; ++i) {
                if (!AdjacencyUpgrades.upgrades[i].isImplemented()) continue;
                li.add(i);
            }
            int offset = (Integer)li.get((int)(System.currentTimeMillis() / 8000L % (long)li.size()));
            te = m.createTEInstanceForRender(offset);
            tag.addValueToColor(CrystalElement.elements[offset], 1);
        } else if (m.isChargedCrystalPowered()) {
            ChargedCrystalPowered r = (ChargedCrystalPowered)te;
            tag = r.getRequiredEnergy();
        } else if (m.isRelayPowered()) {
            TileEntityRelayPowered r = (TileEntityRelayPowered)te;
            tag = r.getRequiredEnergy();
        } else if (m.isPylonPowered()) {
            CrystalReceiver r = (CrystalReceiver)te;
            for (int i = 0; i < 16; ++i) {
                if (!r.isConductingElement(CrystalElement.elements[i])) continue;
                int amt = 25 + (int)(20.0 * Math.sin((double)i + (double)this.getGuiTick() / 20.0));
                tag.addValueToColor(CrystalElement.elements[i], amt);
            }
        }
        return tag != null && !tag.isEmpty() ? tag : null;
    }

    @Override
    public final void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        if (this.subpage == 0 || this.page == ChromaResearch.ACCEL && this.subpage != 1) {
            this.drawMachineRender(posX, posY);
        } else {
            ElementTagCompound tag = this.getUsedEnergy();
            if (tag != null) {
                int r = 32;
                int dx = posX + this.xSize - r - 50;
                int dy = posY + r + 10;
                Proportionality<CrystalElement> p = tag.getProportionality();
                p.setGeometry((double)dx, (double)dy, (double)r, (double)(System.identityHashCode((Object)this) + this.getGuiTick() % 360));
                p.render(CrystalElement.getColorMap());
                float lf = GL11.glGetFloat((int)2849);
                GL11.glLineWidth((float)2.5f);
                api.drawCircle((double)dx, (double)dy, (double)(r + 1), -1);
                api.drawCircle((double)dx, (double)dy, (double)r, -16777216);
                GL11.glLineWidth((float)lf);
            }
        }
    }

    private void drawMachineRender(int posX, int posY) {
        double dz;
        double dy;
        double dx;
        double x = posX + 167;
        double y = posY + 44;
        int range = 64;
        boolean rotate = ReikaGuiAPI.instance.isMouseInBox((int)x - range / 2, (int)x + range / 2, (int)y - range, (int)y + range);
        if (Mouse.isButtonDown((int)0) && rotate) {
            int mvy = Mouse.getDY();
            if (mvy < 0 && this.renderq < 45.0f) {
                this.renderq += 1.0f;
            }
            if (mvy > 0 && this.renderq > -45.0f) {
                this.renderq -= 1.0f;
            }
        }
        y -= 8.0 * Math.sin(Math.abs(Math.toRadians(this.renderq)));
        ChromaTiles m = this.page.getMachine();
        if (m.isPlant()) {
            this.renderq = 22.5f;
        }
        if (m.isTextureFace()) {
            this.renderq = 22.5f;
        }
        int r = (int)(System.nanoTime() / 20000000L) % 360;
        if (m.isPlant()) {
            r = -45;
        }
        if (m.isTextureFace()) {
            r = -45;
        }
        int offset = 0;
        if (m == ChromaTiles.ADJACENCY) {
            ArrayList<Integer> li = new ArrayList<Integer>();
            for (int i = 0; i < CrystalElement.elements.length; ++i) {
                if (!AdjacencyUpgrades.upgrades[i].isImplemented()) continue;
                li.add(i);
            }
            offset = (Integer)li.get((int)(System.currentTimeMillis() / 8000L % (long)li.size()));
            if (this.subpage > 0) {
                offset = this.subpage - 2;
            }
            if (!AdjacencyUpgrades.upgrades[offset].isImplemented()) {
                return;
            }
        } else if (m == ChromaTiles.FOCUSCRYSTAL) {
            offset = (int)(System.currentTimeMillis() / 4000L % (long)TileEntityFocusCrystal.CrystalTier.tierList.length);
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)32.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        double sc = 48.0;
        GL11.glPushMatrix();
        if (m.hasRender()) {
            runningRender = true;
            dx = x;
            dy = y + (double)m.getRenderOffset();
            dz = 0.0;
            GL11.glPushMatrix();
            GL11.glTranslated((double)dx, (double)dy, (double)dz);
            GL11.glScaled((double)sc, (double)(-sc), (double)sc);
            GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            double a = -0.5;
            double b = -0.5;
            TileEntity te = m.createTEInstanceForRender(offset);
            if (m.needsRenderOffset()) {
                b = -0.875;
                a = -0.875;
                GL11.glTranslated((double)0.0, (double)-0.3, (double)0.0);
            }
            if (m == ChromaTiles.LUMENWIRE) {
                b = -1.25;
                a = -1.25;
                GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            }
            if (m == ChromaTiles.AVOLASER) {
                GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            }
            if (m == ChromaTiles.AURAPOINT) {
                GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0);
            }
            if (m == ChromaTiles.TELEPORT) {
                b = -0.125;
                a = -0.125;
            }
            if (m == ChromaTiles.FLUIDRELAY) {
                b = -1.5;
                a = -1.5;
            }
            if (m == ChromaTiles.CHROMACRAFTER) {
                b = -0.03125;
                a = -0.03125;
                GL11.glTranslated((double)0.0, (double)0.3125, (double)0.0);
            }
            if (m == ChromaTiles.PERSONAL) {
                double s = 0.75;
                GL11.glScaled((double)s, (double)s, (double)s);
                GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            }
            if (m == ChromaTiles.ADJACENCY) {
                ItemStack is = ChromaItems.ADJACENCY.getStackOfMetadata(offset);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", (int)(System.currentTimeMillis() / 1000L % 8L));
                ((TileEntityAdjacencyUpgrade)te).setDataFromItemStackTag(is);
            }
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, a, 0.0, b, 0.0f);
            GL11.glPopMatrix();
            runningRender = false;
        }
        if (m.hasBlockRender()) {
            dx = x;
            dy = y;
            dz = 0.0;
            GL11.glPushMatrix();
            GL11.glTranslated((double)dx, (double)dy, (double)dz);
            GL11.glScaled((double)sc, (double)(-sc), (double)sc);
            GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            if (m == ChromaTiles.CRYSTAL) {
                GL11.glTranslated((double)-0.5, (double)-0.33, (double)-0.5);
                CrystalRenderer.renderAllArmsInInventory = true;
            }
            ReikaTextureHelper.bindTerrainTexture();
            rb.func_147800_a(m.getBlock(), m.getBlockMetadata(), 1.0f);
            CrystalRenderer.renderAllArmsInInventory = false;
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-32.0);
    }
}

