/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.ChromaBookGui;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class GuiNotes
extends ChromaBookGui {
    public static final int LINES = 10;
    public static final int TEXTCOLOR = 0x202020;
    private int scroll = 0;
    private boolean lineAppend = false;
    private final ArrayList<String> data = new ArrayList();
    private int activeIndex = -1;
    private GuiTextField[] input = new GuiTextField[10];

    public GuiNotes(EntityPlayer ep) {
        super(ChromaGuis.NOTES, ep, 256, 220);
        ItemStack held = ep.func_70694_bm();
        if (held.field_77990_d != null && held.field_77990_d.func_74764_b("notes")) {
            NBTTagList tag = held.field_77990_d.func_150295_c("notes", ReikaNBTHelper.NBTTypes.STRING.ID);
            for (Object o : tag.field_74747_a) {
                this.data.add(((NBTTagString)o).func_150285_a_());
            }
        }
    }

    public void func_146281_b() {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.BOOKNOTESRESET.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[0]);
        for (String s : this.data) {
            ReikaPacketHelper.sendStringPacket((String)"ChromaData", (int)ChromaPackets.BOOKNOTE.ordinal(), (String)s);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(10, j + this.xSize, k, 22, 39, 42, 126, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Return");
        this.field_146292_n.add(new CustomSoundGuiButton(1, j - 20, k - 5, 20, 20, "-", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(0, j - 20, k + 15, 20, 20, "+", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(2, j - 20, k + 35, 20, 20, "*", (CustomSoundGuiButton.CustomSoundGui)this));
        for (int i = 0; i < 10; ++i) {
            this.input[i] = new NoteTextField((FontRenderer)ChromaFontRenderer.FontType.LEXICON.renderer, j + 8, k + 3 + i * 20, 240, 19);
            this.input[i].func_146195_b(false);
            this.input[i].func_146203_f(9999);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 10) {
            this.saveCurrentLine();
            this.goTo(ChromaGuis.BOOKNAV, null);
        } else if (button.field_146127_k == 0) {
            if (this.scroll < this.data.size() - 10) {
                this.scrollDown();
            }
        } else if (button.field_146127_k == 1) {
            if (this.scroll > 0) {
                this.scrollUp();
            }
        } else if (button.field_146127_k == 2) {
            this.lineAppend = true;
            this.data.add("-Add Notes-");
            this.saveCurrentLine();
            this.activeIndex = -1;
            while (this.scroll < this.data.size() - 10) {
                this.scrollDown();
            }
            return;
        }
        this.func_73866_w_();
    }

    private void scrollDown() {
        this.saveCurrentLine();
        this.unfocusText();
        ++this.scroll;
    }

    private void scrollUp() {
        this.saveCurrentLine();
        this.unfocusText();
        --this.scroll;
    }

    private void unfocusText() {
        this.activeIndex = -1;
        for (int i = 0; i < 10; ++i) {
            this.input[i].func_146195_b(false);
        }
    }

    private void saveCurrentLine() {
        if (this.activeIndex != -1) {
            this.data.set(this.activeIndex, this.input[this.activeIndex - this.scroll].func_146179_b());
        }
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        super.func_73863_a(x, y, f);
        int max = Math.min(this.scroll + this.data.size(), this.scroll + 10);
        for (int i = this.scroll; i < max; ++i) {
            if (i == this.activeIndex) continue;
            String s = this.data.get(i);
            String sg = s.length() > 45 ? s.substring(0, 45) + "..." : s;
            int dy = k + 8 + 20 * (i - this.scroll);
            this.field_146289_q.func_78276_b(sg, j + 12, dy, 0x202020);
        }
        if (this.activeIndex != -1) {
            this.input[this.activeIndex - this.scroll].func_146194_f();
        }
    }

    protected void func_73869_a(char c, int k) {
        if (k == 1) {
            this.saveCurrentLine();
        }
        super.func_73869_a(c, k);
        for (int i = 0; i < 10; ++i) {
            this.input[i].func_146201_a(c, k);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        int idx = this.getTextBoxFromClickPos(x, y);
        if (idx != this.activeIndex && !this.lineAppend) {
            this.saveCurrentLine();
        }
        if (idx != -1) {
            this.createAndEditTextBoxForLine(idx, x, y, b);
        } else {
            this.activeIndex = -1;
        }
        if (this.lineAppend) {
            this.createAndEditTextBoxForLine(this.data.size() - 1 - this.scroll, x, y, b);
            this.input[this.activeIndex - this.scroll].func_146195_b(true);
            this.input[this.activeIndex - this.scroll].func_146180_a(this.data.get(this.activeIndex));
        }
        this.lineAppend = false;
    }

    private void createAndEditTextBoxForLine(int idx, int x, int y, int b) {
        this.activeIndex = idx + this.scroll;
        this.input[this.activeIndex - this.scroll].func_146192_a(x, y, b);
        if (this.input[this.activeIndex - this.scroll].func_146206_l()) {
            this.input[this.activeIndex - this.scroll].func_146180_a(this.data.get(this.activeIndex));
        }
    }

    private int getTextBoxFromClickPos(int x, int y) {
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        int dx = x - j - 7;
        int dy = y - k - 3;
        if (dx < 1 || dx > 240) {
            return -1;
        }
        if (dy < 0 || dy > 197) {
            return -1;
        }
        int h = dy / 20;
        int v = dy - h * 20;
        if (v < 1 || v > 16) {
            return -1;
        }
        if (h >= this.data.size()) {
            return -1;
        }
        return h;
    }

    @Override
    public String getBackgroundTexture() {
        return "Textures/GUIs/Handbook/notes.png";
    }

    private static class NoteTextField
    extends GuiTextField {
        private final FontRenderer renderer;

        public NoteTextField(FontRenderer fr, int x, int y, int w, int h) {
            super(fr, x, y, w, h);
            this.func_146193_g(0x202020);
            this.renderer = fr;
        }

        public void func_146194_f() {
            int i = 0x202020;
            int j = this.func_146198_h() - this.field_146225_q;
            int k = this.func_146186_n() - this.field_146225_q;
            String text = this.func_146179_b();
            String s = this.renderer.func_78269_a(text.substring(this.field_146225_q), this.func_146200_o());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.func_146206_l() && this.field_146214_l / 6 % 2 == 0 && flag;
            int l = this.field_146209_f + 4;
            int i1 = this.field_146210_g + (this.field_146219_i - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (s.length() > 0) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.renderer.func_78276_b(s1, l, i1, i);
            }
            boolean flag2 = this.func_146198_h() < text.length() || text.length() >= this.func_146208_g();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_146218_h : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (s.length() > 0 && flag && j < s.length()) {
                this.renderer.func_78276_b(s.substring(j), j1, i1, i);
            }
            if (flag1) {
                if (flag2) {
                    Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.renderer.field_78288_b), (int)-3092272);
                } else {
                    this.renderer.func_78276_b("_", k1, i1, i);
                }
            }
            if (k != j) {
                int l1 = l + this.renderer.func_78256_a(s.substring(0, k));
                this.func_146188_c(k1, i1 - 1, l1 - 1, i1 + 1 + this.renderer.field_78288_b);
            }
        }
    }
}

