/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Base.GuiProgressStages;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.DragonAPI.Instantiable.Data.Maps.SequenceMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import java.awt.Point;
import java.util.Collection;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GuiProgressTree
extends GuiProgressStages {
    private final SequenceMap.Topology<ProgressionManager.ProgressLink> map = ProgressionManager.instance.getTopology();
    private final Map<ProgressionManager.ProgressLink, Integer> levels = this.map.getDepthMap();

    public GuiProgressTree(EntityPlayer ep) {
        super(ChromaGuis.PROGRESS, ep);
        this.initMap();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        this.renderTree(posX, posY);
        this.renderText(posX, posY);
    }

    private void renderTree(int posX, int posY) {
        this.renderLines(posX, posY);
        this.renderElements(posX, posY);
    }

    private void renderLines(int posX, int posY) {
        for (ProgressionManager.ProgressLink p : this.levels.keySet()) {
            this.renderLine(posX, posY, p);
        }
    }

    private void renderLine(int posX, int posY, ProgressionManager.ProgressLink p) {
        Collection c = this.map.getParents((Object)p);
        int dx = -offsetX + posX + 12;
        int dy = -offsetY + posY + 36;
        org.lwjgl.util.Point pt = this.getRenderPosition(p.parent);
        for (ProgressionManager.ProgressLink par : c) {
            int y2;
            org.lwjgl.util.Point pt2 = this.getRenderPosition(par.parent);
            int x1 = dx + pt.getX() + this.elementWidth / 2;
            int y1 = dy + pt.getY();
            int x2 = dx + pt2.getX() + this.elementWidth / 2;
            ImmutablePair ps = ReikaVectorHelper.clipLine((int)x1, (int)x2, (int)y1, (int)(y2 = dy + pt2.getY() + this.elementHeight), (int)(posX + 8), (int)(posY + 26), (int)(posX + this.xSize - 8), (int)(posY + this.ySize / 2 + 6));
            if (ps == null) continue;
            int clr = p.parent == this.getActive() || par.parent == this.getActive() ? (par.parent.isPlayerAtStage(this.player) ? 65280 : 0xFF4040) : 0xFFFFFF;
            api.drawLine((double)((Point)ps.left).x, (double)((Point)ps.left).y, (double)((Point)ps.right).x, (double)((Point)ps.right).y, clr, par.type);
        }
    }

    @Override
    public String getBackgroundTexture() {
        return "Textures/GUIs/Handbook/progress.png";
    }

    @Override
    protected String getScrollingTexture() {
        return "Textures/GUIs/Handbook/navbcg.png";
    }

    @Override
    protected int getDepth(ProgressionManager.ProgressLink p) {
        return this.levels.get(p);
    }

    @Override
    protected Collection<ProgressionManager.ProgressLink> getProgress() {
        return this.levels.keySet();
    }
}

