/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Base.BlockModelledChromaTile;
import Reika.ChromatiCraft.Base.FragmentStructureBase;
import Reika.ChromatiCraft.Base.GuiBookSection;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Entity.EntityChromaEnderCrystal;
import Reika.ChromatiCraft.Magic.CastingTuning.CastingTuningManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.TESR.RenderVoidMonsterTrap;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityPowerTree;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStructure
extends GuiBookSection {
    private int mode = 0;
    private int tick = 0;
    private final FilledBlockArray array = this.page.getStructure().getStructureForDisplay();
    private final StructureRenderer render;

    public GuiStructure(EntityPlayer ep, ChromaResearch r) {
        super(ChromaGuis.STRUCTURE, ep, r, 256, 220, false);
        if (this.page.name().toLowerCase(Locale.ENGLISH).contains("casting")) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.TABLE.getBlock(), ChromaTiles.TABLE.getBlockMetadata());
            if (this.page == ChromaResearch.CASTING2 || this.page == ChromaResearch.CASTING3) {
                for (int i = -4; i <= 4; i += 2) {
                    for (int k = -4; k <= 4; k += 2) {
                        if (i == 0 && k == 0) continue;
                        int dx = this.array.getMidX() + i;
                        int dz = this.array.getMidZ() + k;
                        int dy = this.array.getMinY() + 1 + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                        this.array.setBlock(dx, dy, dz, ChromaTiles.STAND.getBlock(), ChromaTiles.STAND.getBlockMetadata());
                    }
                }
                for (Coordinate c : CastingTuningManager.instance.getTuningKeyLocations()) {
                    this.array.setBlock(c.xCoord, c.yCoord + 1, c.zCoord, ChromaBlocks.PYLONSTRUCT.getBlockInstance(), BlockPylonStructure.StoneTypes.SMOOTH.ordinal());
                }
            }
            this.array.setBlock(this.array.getMidX() + 1, this.array.getMinY() + 1, this.array.getMidZ(), Blocks.field_150350_a);
            this.array.setBlock(this.array.getMidX() - 1, this.array.getMinY() + 1, this.array.getMidZ(), Blocks.field_150350_a);
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ() + 1, Blocks.field_150350_a);
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ() - 1, Blocks.field_150350_a);
        }
        if (this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) {
            this.array.setBlock(this.array.getMidX() - 1, this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.POWERTREE.getBlock(), ChromaTiles.POWERTREE.getBlockMetadata());
        }
        if (this.page == ChromaResearch.INFUSION) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 2, this.array.getMidZ(), ChromaTiles.INFUSER.getBlock(), ChromaTiles.INFUSER.getBlockMetadata());
        }
        if (this.page == ChromaResearch.PLAYERINFUSION) {
            this.array.setBlock(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.PLAYERINFUSER.getBlock(), ChromaTiles.PLAYERINFUSER.getBlockMetadata());
        }
        if (this.page == ChromaResearch.MINIPYLON) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 6, this.array.getMidZ(), ChromaTiles.PERSONAL.getBlock(), ChromaTiles.PERSONAL.getBlockMetadata());
        }
        if (this.page == ChromaResearch.PYLON) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), Blocks.field_150350_a);
        }
        if (this.page == ChromaResearch.PYLON || this.page == ChromaResearch.PYLONTURBORING) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 9, this.array.getMidZ(), ChromaTiles.PYLON.getBlock(), ChromaTiles.PYLON.getBlockMetadata());
        }
        if (this.page == ChromaResearch.PYLONBROADCAST) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 10, this.array.getMidZ(), ChromaTiles.PYLON.getBlock(), ChromaTiles.PYLON.getBlockMetadata());
        }
        if (this.page == ChromaResearch.CLOAKTOWER) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 5, this.array.getMidZ(), ChromaTiles.CLOAKING.getBlock(), ChromaTiles.CLOAKING.getBlockMetadata());
        }
        if (this.page == ChromaResearch.VOIDTRAPSTRUCT || this.page == ChromaResearch.VOIDTRAPSTRUCTN) {
            this.array.setBlock(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.VOIDTRAP.getBlock(), ChromaTiles.VOIDTRAP.getBlockMetadata());
        }
        if (this.page == ChromaResearch.GATESTRUCT) {
            for (int i = 0; i <= 1; ++i) {
                this.array.setBlock(this.array.getMidX() + 3 - i, this.array.getMinY() + 3 + i, this.array.getMidZ(), Blocks.field_150350_a);
                this.array.setBlock(this.array.getMidX() - 3 + i, this.array.getMinY() + 3 + i, this.array.getMidZ(), Blocks.field_150350_a);
                this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 3 + i, this.array.getMidZ() + 3 - i, Blocks.field_150350_a);
                this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 3 + i, this.array.getMidZ() - 3 + i, Blocks.field_150350_a);
            }
        }
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        switch (this.page) {
            case TREESEND: 
            case BOOSTTREE: {
                FilledBlockArray arr = ChromaStructures.TREE.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case PYLONBROADCAST: 
            case PYLONTURBORING: {
                FilledBlockArray arr = ChromaStructures.PYLON.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    if (arr.getBlockAt(c.xCoord, c.yCoord, c.zCoord) == Blocks.field_150350_a) continue;
                    set.add(c);
                }
                break;
            }
            case METEOR2: {
                FilledBlockArray arr = ChromaStructures.METEOR1.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case METEOR3: {
                FilledBlockArray arr = ChromaStructures.METEOR2.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case RITUAL2: {
                FilledBlockArray arr = ChromaStructures.RITUAL.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case WIRELESSPED2: {
                FilledBlockArray arr = ChromaStructures.WIRELESSPEDESTAL.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case CASTING2: {
                FilledBlockArray arr = ChromaStructures.CASTING1.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
            case CASTING3: {
                FilledBlockArray arr = ChromaStructures.CASTING2.getStructureForDisplay();
                for (Coordinate c : arr.keySet()) {
                    BlockKey key = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                    if (key.blockID == Blocks.field_150350_a || !key.equals((Object)this.array.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord))) continue;
                    set.add(c);
                }
                break;
            }
        }
        this.render = new StructureRenderer(this.array, set);
        if (this.page == ChromaResearch.PYLON || this.page == ChromaResearch.PYLONTURBORING) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 9, this.array.getMidZ(), ChromaTiles.PYLON.getCraftedProduct());
        } else if (this.page == ChromaResearch.PYLONBROADCAST) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 10, this.array.getMidZ(), ChromaTiles.PYLON.getCraftedProduct());
        } else if (this.page == ChromaResearch.MINIPYLON) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 6, this.array.getMidZ(), ChromaTiles.PERSONAL.getCraftedProduct());
        } else if (this.page == ChromaResearch.CLOAKTOWER) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 5, this.array.getMidZ(), ChromaTiles.CLOAKING.getCraftedProduct());
        } else if (this.page == ChromaResearch.INFUSION) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 2, this.array.getMidZ(), ChromaTiles.INFUSER.getCraftedProduct());
        } else if (this.page == ChromaResearch.PLAYERINFUSION) {
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.PLAYERINFUSER.getCraftedProduct());
        } else if (this.page == ChromaResearch.VOIDTRAPSTRUCT || this.page == ChromaResearch.VOIDTRAPSTRUCTN) {
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.VOIDTRAP.getCraftedProduct());
            this.render.addOverride(new ItemStack(ChromaTiles.LUMENWIRE.getBlock(), ChromaTiles.LUMENWIRE.getBlockMetadata()), ChromaTiles.LUMENWIRE.getCraftedProduct());
        } else if (this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) {
            this.render.addOverride(this.array.getMidX() - 1, this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.POWERTREE.getCraftedProduct());
            for (int c = 0; c < 16; ++c) {
                CrystalElement e = CrystalElement.elements[c];
                int max = TileEntityPowerTree.maxLeafCount(e);
                for (int i = 0; i < max; ++i) {
                    Coordinate cc = TileEntityPowerTree.getLeafLocation(e, i);
                    cc = cc.offset(this.array.getMidX() - 1, this.array.getMaxY(), this.array.getMidZ());
                    this.render.addOverride(cc.xCoord, cc.yCoord, cc.zCoord, (StructureRenderer.BlockChoiceHook)new LumenLeafHook(i, e));
                }
            }
        } else if (this.page == ChromaResearch.BEACONSTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.BEACON.getCraftedProduct());
        } else if (this.page == ChromaResearch.PROGLINKSTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.PROGRESSLINK.getCraftedProduct());
        } else if (this.page == ChromaResearch.OPTIMISTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 8, this.array.getMidZ(), ChromaTiles.OPTIMIZER.getCraftedProduct());
        } else if (this.page.name().contains("METEOR")) {
            ItemStack is = ChromaTiles.METEOR.getCraftedProduct();
            if (this.page == ChromaResearch.METEOR2) {
                is.field_77990_d = null;
            }
            if (this.page == ChromaResearch.METEOR2) {
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", 1);
            }
            if (this.page == ChromaResearch.METEOR3) {
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", 2);
            }
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 2, this.array.getMidZ(), is);
            this.render.addOverride(ChromaTiles.METEOR.getCraftedProduct(), is);
        } else if (this.page == ChromaResearch.MINIREPEATER) {
            this.render.addBlockHook(Blocks.field_150364_r, (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            this.render.addBlockHook(Blocks.field_150363_s, (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            for (int i = 0; i < ModWoodList.woodList.length; ++i) {
                ModWoodList tree = ModWoodList.woodList[i];
                if (!tree.exists()) continue;
                this.render.addBlockHook(tree.getBlock(), (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            }
        } else if (this.page == ChromaResearch.PORTALSTRUCT) {
            this.render.addOverride(new ItemStack(Blocks.field_150357_h), ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1));
            this.render.addEntityRender(-5, -1, -9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-9, -1, -5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(5, -1, -9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(9, -1, -5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-5, -1, 9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-9, -1, 5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(5, -1, 9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(9, -1, 5, GuiStructure.createCrystalRender());
        }
        if (this.page != ChromaResearch.CAVERN) {
            this.render.addBlockHook(ChromaBlocks.RUNE.getBlockInstance(), (StructureRenderer.BlockChoiceHook)new RuneRenderHook());
        }
        if (this.page == ChromaResearch.GATESTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.TELEPORT.getCraftedProduct());
        }
        if (this.page == ChromaResearch.DATATOWER) {
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.DATANODE.getCraftedProduct());
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 1, this.array.getMidZ(), ChromaTiles.DATANODE.getCraftedProduct());
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 2, this.array.getMidZ(), ChromaTiles.DATANODE.getCraftedProduct());
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 3, this.array.getMidZ(), ChromaTiles.DATANODE.getCraftedProduct());
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 4, this.array.getMidZ(), ChromaTiles.DATANODE.getCraftedProduct());
        }
        if (this.page == ChromaResearch.CASTING2 || this.page == ChromaResearch.CASTING3) {
            for (int i = -4; i <= 4; i += 2) {
                for (int k = -4; k <= 4; k += 2) {
                    if (i == 0 && k == 0) continue;
                    int dx = this.array.getMidX() + i;
                    int dz = this.array.getMidZ() + k;
                    int dy = this.array.getMinY() + 1 + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                    this.render.addOverride(dx, dy, dz, ChromaTiles.STAND.getCraftedProduct());
                }
            }
            this.render.addOverride(new ItemStack(ChromaTiles.STAND.getBlock(), ChromaTiles.STAND.getBlockMetadata()), ChromaTiles.STAND.getCraftedProduct());
        }
        if (this.page == ChromaResearch.BIOMESTRUCT) {
            this.render.addBlockHook(Blocks.field_150355_j, (StructureRenderer.BlockChoiceHook)new CCFluidHook());
            this.render.addBlockHook(ChromaBlocks.LAMP.getBlockInstance(), (StructureRenderer.BlockChoiceHook)new BiomeCrystalHook());
            this.render.addBlockHook(ChromaBlocks.RUNE.getBlockInstance(), (StructureRenderer.BlockChoiceHook)new BiomeRuneHook());
            this.render.addOverride(ChromaBlocks.LIGHTPANEL.getStackOfMetadata(0), ChromaBlocks.LIGHTPANEL.getStackOfMetadata(1));
            this.render.addOverride(ChromaBlocks.LIGHTPANEL.getStackOfMetadata(2), ChromaBlocks.LIGHTPANEL.getStackOfMetadata(3));
        }
        this.render.addRenderHook(ChromaTiles.PYLON.getCraftedProduct(), (StructureRenderer.BlockRenderHook)new PylonRenderHook());
    }

    private static StructureRenderer.EntityRender createCrystalRender() {
        return new StructureRenderer.EntityRender((Entity)new EntityChromaEnderCrystal((World)Minecraft.func_71410_x().field_71441_e), ReikaEntityHelper.getEntityRenderer(EntityEnderCrystal.class));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.render.resetRotation();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new CustomSoundGuiButton(0, j + 185, k - 2, 20, 20, "3D", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(1, j + 205, k - 2, 20, 20, "2D", (CustomSoundGuiButton.CustomSoundGui)this));
        if (!(this.page.getStructure().getStructure() instanceof FragmentStructureBase)) {
            this.field_146292_n.add(new CustomSoundGuiButton(4, this.mode == 1 ? j + 125 : j + 165, k - 2, 20, 20, "N#", (CustomSoundGuiButton.CustomSoundGui)this));
        }
        if (this.mode == 1) {
            this.field_146292_n.add(new CustomSoundGuiButton(2, j + 165, k - 2, 20, 20, "+", (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton(3, j + 145, k - 2, 20, 20, "-", (CustomSoundGuiButton.CustomSoundGui)this));
        }
    }

    @Override
    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 0) {
            this.mode = 0;
            this.render.reset();
            this.func_73866_w_();
        } else if (b.field_146127_k == 1) {
            this.mode = 1;
            this.func_73866_w_();
        } else if (b.field_146127_k == 2) {
            this.render.incrementStepY();
            this.func_73866_w_();
        } else if (b.field_146127_k == 3) {
            this.render.decrementStepY();
            this.func_73866_w_();
        } else if (b.field_146127_k == 4) {
            this.mode = 2;
            this.func_73866_w_();
        }
    }

    @Override
    protected int getMaxSubpage() {
        return 0;
    }

    @Override
    protected GuiBookSection.PageType getGuiLayout() {
        return GuiBookSection.PageType.STRUCT;
    }

    @Override
    public final void func_73863_a(int mx, int my, float f) {
        super.func_73863_a(mx, my, f);
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String s = "(" + this.array.getSizeX() + "x" + this.array.getSizeY() + "x" + this.array.getSizeZ() + ")";
        this.field_146289_q.func_78276_b(s, j + 6, k + 10, 0xFFFFFF);
        ++this.tick;
        GL11.glPushMatrix();
        switch (this.mode) {
            case 0: {
                this.draw3d(j, k, f);
                break;
            }
            case 1: {
                this.drawSlice(j, k);
                break;
            }
            case 2: {
                this.drawTally(j, k);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawSlice(int j, int k) {
        this.render.drawSlice(j, k, this.field_146289_q);
    }

    private void drawTally(int j, int k) {
        int i;
        ItemHashMap map = this.array.tally();
        ItemHashMap map2 = null;
        ChromaStructures diff = this.getDifferenceTally();
        if (diff != null) {
            map2 = ItemHashMap.subtract((ItemHashMap)map, (ItemHashMap)diff.getStructureForDisplay().tally());
        }
        for (i = 0; i < 16; ++i) {
            map.remove(ChromaBlocks.POWERTREE.getStackOfMetadata(i));
        }
        i = 0;
        int n = 8;
        ArrayList c = new ArrayList(map.keySet());
        Collections.sort(c, ReikaItemHelper.comparator);
        for (ItemStack is : c) {
            int dx = j + 10 + i / n * (map2 != null ? 65 : 50);
            int dy = k + 30 + i % n * 22;
            ItemStack is2 = is.func_77946_l();
            if (ChromaBlocks.CHROMA.match(is)) {
                is2 = ChromaItems.BUCKET.getStackOfMetadata(0);
            } else if (ChromaBlocks.ENDER.match(is) || Block.func_149634_a((Item)is.func_77973_b()) == FluidRegistry.getFluid((String)"ender").getBlock()) {
                is2 = ChromaItems.BUCKET.getStackOfMetadata(1);
            } else if (ChromaBlocks.LUMA.match(is)) {
                is2 = ChromaItems.BUCKET.getStackOfMetadata(3);
            } else if (ChromaBlocks.MOLTENLUMEN.match(is)) {
                is2 = ChromaItems.BUCKET.getStackOfMetadata(4);
            } else if (ChromaBlocks.RUNE.match(is)) {
                is2 = ChromaBlocks.RUNE.getStackOfMetadata(GuiStructure.getElementByTick());
            } else if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150488_af)) {
                is2 = new ItemStack(Items.field_151137_ax);
            } else if (this.page == ChromaResearch.PORTALSTRUCT && Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150357_h) {
                is2 = ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1);
            } else if ((this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) && Block.func_149634_a((Item)is.func_77973_b()) == ChromaBlocks.PYLON.getBlockInstance()) {
                is2 = ChromaTiles.POWERTREE.getCraftedProduct();
            } else if (this.page == ChromaResearch.CLOAKTOWER && Block.func_149634_a((Item)is.func_77973_b()) == ChromaBlocks.TILEMODELLED2.getBlockInstance()) {
                is2 = ChromaTiles.CLOAKING.getCraftedProduct();
            } else if (this.page.name().contains("METEOR") && Block.func_149634_a((Item)is.func_77973_b()) == ChromaTiles.METEOR.getBlock()) {
                is2 = ChromaTiles.METEOR.getCraftedProduct();
                if (this.page == ChromaResearch.METEOR1) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 0);
                } else if (this.page == ChromaResearch.METEOR2) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 1);
                } else if (this.page == ChromaResearch.METEOR3) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 2);
                }
            } else if (this.page.name().toLowerCase(Locale.ENGLISH).contains("casting") && ChromaBlocks.getEntryByID(ChromaTiles.STAND.getBlock()).match(is2) && is2.func_77960_j() == ChromaTiles.STAND.getBlockMetadata()) {
                is2 = ChromaTiles.STAND.getCraftedProduct();
            }
            if (ChromaBlocks.PYLON.match(is2)) {
                is2 = ChromaTiles.getTileFromIDandMetadata(Block.func_149634_a((Item)is2.func_77973_b()), is2.func_77960_j()).getCraftedProduct();
            }
            if (is2 != null && Block.func_149634_a((Item)is2.func_77973_b()) instanceof BlockModelledChromaTile) {
                is2 = ChromaTiles.getTileFromIDandMetadata(Block.func_149634_a((Item)is2.func_77973_b()), is2.func_77960_j()).getCraftedProduct();
            }
            if (is2 == null) continue;
            api.drawItemStackWithTooltip(field_146296_j, this.field_146289_q, is2, dx, dy);
            String s = String.valueOf(map.get(is));
            this.field_146289_q.func_78276_b(s, dx + 20, dy + 5, 0xFFFFFF);
            if (map2 != null) {
                int dx2 = dx + 20 + this.field_146289_q.func_78256_a(s) + this.field_146289_q.func_78263_a(' ');
                Integer get = (Integer)map2.get(is);
                if (get == null) {
                    get = 0;
                }
                s = "(" + get + ")";
                this.field_146289_q.func_78276_b(s, dx2, dy + 5, 0x22FF22);
            }
            ++i;
        }
    }

    private ChromaStructures getDifferenceTally() {
        switch (this.page.getStructure()) {
            case CASTING2: {
                return ChromaStructures.CASTING1;
            }
            case CASTING3: {
                return ChromaStructures.CASTING2;
            }
            case METEOR2: {
                return ChromaStructures.METEOR1;
            }
            case METEOR3: {
                return ChromaStructures.METEOR2;
            }
            case PYLONBROADCAST: 
            case PYLONTURBO: {
                return ChromaStructures.PYLON;
            }
            case RITUAL2: {
                return ChromaStructures.RITUAL;
            }
            case TREE_BOOSTED: {
                return ChromaStructures.TREE;
            }
            case TREE_SENDER: {
                return ChromaStructures.TREE;
            }
            case WIRELESSPEDESTAL2: {
                return ChromaStructures.WIRELESSPEDESTAL;
            }
        }
        return null;
    }

    private void draw3d(int j, int k, float ptick) {
        if (Mouse.isButtonDown((int)0) && this.tick > 2) {
            this.render.rotate(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
        } else if (Mouse.isButtonDown((int)1)) {
            this.render.resetRotation();
        }
        if (Keyboard.isKeyDown((int)30)) {
            this.render.rotate(0.0, 0.75, 0.0);
        } else if (Keyboard.isKeyDown((int)32)) {
            this.render.rotate(0.0, -0.75, 0.0);
        } else if (Keyboard.isKeyDown((int)17)) {
            this.render.rotate(-0.75, 0.0, 0.0);
        } else if (Keyboard.isKeyDown((int)31)) {
            this.render.rotate(0.75, 0.0, 0.0);
        }
        RenderVoidMonsterTrap.netherRender = this.page == ChromaResearch.VOIDTRAPSTRUCTN;
        this.render.draw3D(j, k, ptick, true);
        RenderVoidMonsterTrap.netherRender = false;
    }

    private static int getElementByTick() {
        return (int)(System.currentTimeMillis() / 4000L % 16L);
    }

    private static class LogRenderHook
    implements StructureRenderer.BlockChoiceHook {
        private LogRenderHook() {
        }

        public ItemStack getBlock(Coordinate pos) {
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])ReikaTreeHelper.treeList);
            for (int i = 0; i < ModWoodList.woodList.length; ++i) {
                ModWoodList tree = ModWoodList.woodList[i];
                if (!tree.exists()) continue;
                li.add(tree);
            }
            int tick = (int)(System.currentTimeMillis() / 1000L % (long)li.size());
            return ((TreeType)li.get(tick)).getItem().asItemStack();
        }
    }

    private static class CCFluidHook
    implements StructureRenderer.BlockChoiceHook {
        private final ArrayList<String> fluids = ReikaJavaLibrary.makeListFrom((Object[])new String[]{"chroma", "ender", "luma"});

        private CCFluidHook() {
        }

        public ItemStack getBlock(Coordinate pos) {
            int i = (int)(System.currentTimeMillis() / 1000L % (long)this.fluids.size());
            Block b = FluidRegistry.getFluid((String)this.fluids.get(i)).getBlock();
            return new BlockKey(b).asItemStack();
        }
    }

    private static class BiomeCrystalHook
    extends BiomeRandomColorHook {
        protected BiomeCrystalHook() {
            super(ChromaBlocks.LAMP);
        }
    }

    private static class BiomeRuneHook
    extends BiomeRandomColorHook {
        protected BiomeRuneHook() {
            super(ChromaBlocks.RUNE);
        }
    }

    private static abstract class BiomeRandomColorHook
    implements StructureRenderer.BlockChoiceHook {
        private final ChromaBlocks block;
        private final ArrayList<CrystalElement> colors = ReikaJavaLibrary.makeListFromArray((Object[])CrystalElement.elements);

        protected BiomeRandomColorHook(ChromaBlocks b) {
            this.block = b;
            Collections.shuffle(this.colors);
        }

        public final ItemStack getBlock(Coordinate pos) {
            return this.block.getStackOfMetadata(this.getRandomColor(pos));
        }

        private int getRandomColor(Coordinate pos) {
            return this.colors.get((int)(((long)(pos.xCoord + 237 * pos.zCoord) + System.currentTimeMillis() / 1000L) % 16L)).ordinal();
        }
    }

    private static class RuneRenderHook
    implements StructureRenderer.BlockChoiceHook {
        private RuneRenderHook() {
        }

        public ItemStack getBlock(Coordinate pos) {
            return new BlockKey(ChromaBlocks.RUNE.getBlockInstance(), GuiStructure.getElementByTick()).asItemStack();
        }
    }

    private static class LumenLeafHook
    implements StructureRenderer.BlockChoiceHook {
        private final int step;
        private final CrystalElement color;

        private LumenLeafHook(int s, CrystalElement e) {
            this.step = s;
            this.color = e;
        }

        public ItemStack getBlock(Coordinate pos) {
            int max = TileEntityPowerTree.maxLeafCount(this.color) * 3 / 2;
            int tick = (int)(System.currentTimeMillis() / 500L % (long)max) - 2;
            boolean show = tick > this.step;
            return show ? new BlockKey(ChromaBlocks.POWERTREE.getBlockInstance(), this.color.ordinal()).asItemStack() : null;
        }
    }

    private static class PylonRenderHook
    implements StructureRenderer.BlockRenderHook {
        private PylonRenderHook() {
        }

        public double getScale() {
            return 2.0;
        }

        public int getOffsetX() {
            return -4;
        }

        public int getOffsetY() {
            return -6;
        }
    }
}

