/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.Ability.WarpPoint;
import Reika.ChromatiCraft.Auxiliary.Ability.WarpPointData;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.GuiChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.RectangleMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiTeleportAbility
extends GuiChromaTool {
    private final int xSize = 176;
    private final int ySize = 220;
    private final ArrayList<WarpPoint> points = new ArrayList();
    private static final int MAX_LINES = 14;
    private int listOffset = 0;
    private Screen screen = Screen.SELECT;
    private GuiTextField newLabel;
    private int selection = -1;
    private RectangleMap<WarpPoint> locations = new RectangleMap();
    private int pageAge = 0;

    public GuiTeleportAbility(EntityPlayer ep) {
        super(ep);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.pageAge = 0;
        this.listOffset = 0;
        this.points.clear();
        int j = (this.field_146294_l - 176) / 2;
        int k = (this.field_146295_m - 220) / 2;
        String tex = "Textures/GUIs/buttons.png";
        if (this.screen == Screen.SET) {
            this.field_146292_n.add(new CustomSoundGuiButton(0, j + 28, k + 220 - 28, 120, 20, ChromaFontRenderer.FontType.GUI.id + "   Add Point", (CustomSoundGuiButton.CustomSoundGui)this));
        } else if (this.screen == Screen.SELECT || this.screen == Screen.MINIMAP) {
            this.field_146292_n.add(new CustomSoundGuiButton(1, j + 28, k + 220 - 28, this.screen == Screen.SELECT ? 60 : 120, 20, ChromaFontRenderer.FontType.GUI.id + "   Go To", (CustomSoundGuiButton.CustomSoundGui)this));
            if (this.screen == Screen.SELECT) {
                this.field_146292_n.add(new CustomSoundGuiButton(2, j + 88, k + 220 - 28, 60, 20, ChromaFontRenderer.FontType.GUI.id + "   Remove", (CustomSoundGuiButton.CustomSoundGui)this));
            }
            this.field_146292_n.add(new CustomSoundGuiButton(4, j + 4, k + 4, 10, 10, ChromaFontRenderer.FontType.GUI.id + "   -", (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton(5, j + 14, k + 4, 10, 10, ChromaFontRenderer.FontType.GUI.id + "   +", (CustomSoundGuiButton.CustomSoundGui)this));
        }
        this.field_146292_n.add(new CustomSoundGuiButton(10, j + 8, k + 220 - 28, 20, 20, ChromaFontRenderer.FontType.GUI.id + "   <", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(11, j + 148, k + 220 - 28, 20, 20, ChromaFontRenderer.FontType.GUI.id + "   >", (CustomSoundGuiButton.CustomSoundGui)this));
        if (this.screen == Screen.SET) {
            this.newLabel = new GuiTextField((FontRenderer)ChromaFontRenderer.FontType.GUI.renderer, j + 8, k + 30, 160, 16);
            this.newLabel.func_146195_b(false);
            this.newLabel.func_146203_f(24);
        }
        if (this.screen == Screen.SELECT) {
            this.points.addAll(AbilityHelper.instance.getTeleportLocations(this.player));
            Collections.sort(this.points);
        } else if (this.screen == Screen.MINIMAP) {
            this.points.addAll(WarpPointData.loadMiniMaps());
            Collections.sort(this.points);
        }
    }

    protected void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (this.screen == Screen.SET) {
            this.newLabel.func_146201_a(c, i);
        }
    }

    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.screen == Screen.SET) {
            this.newLabel.func_146192_a(x, y, b);
        }
        if (this.screen == Screen.SELECT || this.screen == Screen.MINIMAP) {
            WarpPoint p = (WarpPoint)this.locations.getItemAt(x, y);
            this.selection = p != null ? this.points.indexOf(p) : -1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k >= 10 && this.pageAge > 6) {
            if (b.field_146127_k == 10) {
                this.screen = this.screen.prev();
            } else if (b.field_146127_k == 11) {
                this.screen = this.screen.next();
            }
        } else if (b.field_146127_k == 0 && this.isValidPoint()) {
            AbilityHelper.instance.addWarpPoint(this.newLabel.func_146179_b(), this.player);
            ReikaPacketHelper.sendStringPacket((String)"ChromaData", (int)ChromaPackets.NEWTELEPORT.ordinal(), (String)this.newLabel.func_146179_b());
        } else if (b.field_146127_k == 1 && this.getCurrentSelected() != null) {
            if (this.screen == Screen.MINIMAP) {
                WarpPoint p = this.getCurrentSelected();
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MAPTELEPORT.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[]{p.location.dimensionID, p.location.xCoord, p.location.yCoord, p.location.zCoord});
            } else {
                ReikaPacketHelper.sendStringPacket((String)"ChromaData", (int)ChromaPackets.TELEPORT.ordinal(), (String)this.getCurrentSelected().label);
            }
            this.player.func_71053_j();
        } else if (b.field_146127_k == 2 && this.getCurrentSelected() != null) {
            AbilityHelper.instance.removeWarpPoint(this.getCurrentSelected().label, this.player);
            ReikaPacketHelper.sendStringPacket((String)"ChromaData", (int)ChromaPackets.DELTELEPORT.ordinal(), (String)this.getCurrentSelected().label);
        } else {
            if (b.field_146127_k == 4) {
                this.listOffset = Math.max(0, this.listOffset - (GuiScreen.func_146272_n() ? 10 : 1));
                return;
            }
            if (b.field_146127_k == 5) {
                this.listOffset = Math.min(this.maxListOffset(), this.listOffset + (GuiScreen.func_146272_n() ? 10 : 1));
                return;
            }
        }
        this.func_73866_w_();
    }

    private boolean isValidPoint() {
        return !this.newLabel.func_146179_b().isEmpty() && !AbilityHelper.instance.playerCanWarpTo(this.player, new WorldLocation((Entity)this.player));
    }

    private WarpPoint getCurrentSelected() {
        return this.points.isEmpty() || this.selection < 0 ? null : this.points.get(this.selection);
    }

    public void func_73863_a(int x, int y, float ptick) {
        ++this.pageAge;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.locations.clear();
        GL11.glDisable((int)2929);
        ChromaFontRenderer fr = ChromaFontRenderer.FontType.GUI.renderer;
        int j = (this.field_146294_l - 176) / 2;
        int k = (this.field_146295_m - 220) / 2;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/GUIs/teleports.png");
        ReikaGuiAPI.instance.func_73729_b(j, k, 0, 0, 176, 220);
        int tx = j + 88;
        int ty = k + 4;
        String s = this.screen.title;
        ReikaGuiAPI.instance.drawCenteredStringNoShadow((FontRenderer)fr, s, tx, ty, 0xFFFFFF);
        if (this.screen == Screen.SELECT || this.screen == Screen.MINIMAP) {
            int h = 12;
            int sz = Math.min(14, this.points.size() - this.listOffset);
            for (int i = 0; i < sz; ++i) {
                WarpPoint p = this.points.get(i + this.listOffset);
                int dx = j + 8;
                int w = 160;
                int dy = k + 18 + i * h;
                this.locations.addItem((Object)p, dx, dy, w, h);
                fr.func_78276_b(p.toString(), dx, dy, i + this.listOffset == this.selection ? 65280 : 0xFFFFFF);
            }
        }
        if (this.screen == Screen.SET) {
            this.newLabel.func_146194_f();
            ReikaGuiAPI.instance.drawCenteredStringNoShadow((FontRenderer)fr, this.newLabel.func_146179_b(), tx, k + 60, 0xFFFFFF);
            ReikaGuiAPI.instance.drawCenteredStringNoShadow((FontRenderer)fr, "[" + new WorldLocation((Entity)this.player).toString() + "]", tx, k + 60 + ((FontRenderer)fr).field_78288_b + 2, 0xFFFFFF);
        }
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)1000.0);
        super.func_73863_a(x, y, ptick);
        GL11.glPopMatrix();
    }

    private int maxListOffset() {
        return Math.max(0, this.points.size() - 14);
    }

    private static enum Screen {
        SELECT("Warp Locations"),
        MINIMAP("Minimap Waypoints"),
        SET("Add Location");

        private final String title;
        private static final Screen[] list;

        private Screen(String s) {
            this.title = s;
        }

        public Screen prev() {
            return this.ordinal() == 0 ? this : list[this.ordinal() - 1];
        }

        public Screen next() {
            return this.ordinal() == list.length - 1 ? this : list[this.ordinal() + 1];
        }

        static {
            list = Screen.values();
        }
    }
}

