/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.TileEntityBiomePainter;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Command.BiomeMapCommand;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.GUI.GuiPainter;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class GuiBiomeChanger
extends GuiChromaBase {
    private static final HashMap<BiomeGenBase, BiomePaint> biomeEntries = new HashMap();
    private int refreshPosition;
    private final ArrayList<BiomeGenBase> visibleBiomes = new ArrayList();
    private final TileEntityBiomePainter tile;
    private final RegionMap<BiomeGenBase> biomeRegions = new RegionMap();
    private static TileEntityBiomePainter staticTileRef;
    private BiomePainter painter;
    private GuiTextField search;
    private GuiPages page = GuiPages.PAINT;
    private boolean erase = false;
    private int frame = 0;
    private static final GuiPainter.PaintElement fallback;

    public GuiBiomeChanger(EntityPlayer ep, TileEntityBiomePainter te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.tile = te;
        this.field_146999_f = 256;
        this.field_147000_g = 212;
        staticTileRef = te;
    }

    @Override
    public void func_146280_a(Minecraft mc, int x, int y) {
        super.func_146280_a(mc, x, y);
        int dx = (this.field_146294_l - this.field_146999_f) / 2;
        int dy = (this.field_146295_m - this.field_147000_g) / 2;
        this.painter = new BiomePainter(dx + 10, dy + this.field_147000_g / 2 - 64, 129, 129, 1, this.tile);
    }

    @Override
    public void func_73866_w_() {
        int w;
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.page == GuiPages.BIOME) {
            w = 160;
            this.search = new GuiTextField(this.field_146289_q, j + this.field_146999_f / 2 - w / 2, k + 20, w, 16);
            this.search.func_146195_b(false);
            this.search.func_146203_f(32);
            this.recalcSelectedBiomes();
        }
        w = 10;
        this.field_146292_n.add(new CustomSoundGuiButton(0, j + w, k + this.field_147000_g - 20 - w, 20, 20, "<", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(1, j + this.field_146999_f - 20 - w, k + this.field_147000_g - 20 - w, 20, 20, ">", (CustomSoundGuiButton.CustomSoundGui)this));
        if (this.page == GuiPages.PAINT) {
            this.field_146292_n.add(new CustomSoundGuiButton(2, j + w, k + 16, 50, 20, this.erase ? "Paint" : "Erase", (CustomSoundGuiButton.CustomSoundGui)this));
        }
        if (this.page == GuiPages.BRUSH) {
            for (int i = 0; i < GuiPainter.Brush.brushList.length; ++i) {
                GuiPainter.Brush b = GuiPainter.Brush.brushList[i];
                this.field_146292_n.add(b.getButton(10 + i, j + 20 + 96 * (i % 2), k + 20 + 40 * (i / 2)));
            }
        }
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 0) {
            this.page = this.page.pre();
            this.func_73866_w_();
        } else if (b.field_146127_k == 1) {
            this.page = this.page.next();
            this.func_73866_w_();
        } else if (b.field_146127_k == 2) {
            this.erase = !this.erase;
            this.func_73866_w_();
        }
        if (b.field_146127_k >= 10 && this.page == GuiPages.BRUSH) {
            this.painter.brush = GuiPainter.Brush.brushList[b.field_146127_k - 10];
        }
    }

    protected void func_73869_a(char c, int key) {
        if (this.page == GuiPages.BIOME && this.search.func_146206_l() && key != 1) {
            this.search.func_146201_a(c, key);
            this.recalcSelectedBiomes();
        } else {
            super.func_73869_a(c, key);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.page == GuiPages.BIOME) {
            this.search.func_146192_a(x, y, b);
            for (Object o : this.field_146292_n) {
                GuiButton gb = (GuiButton)o;
                if (x < gb.field_146128_h || y < gb.field_146129_i || x >= gb.field_146128_h + gb.field_146120_f || y >= gb.field_146129_i + gb.field_146121_g) continue;
                return;
            }
            int j = (this.field_146294_l - this.field_146999_f) / 2;
            int k = (this.field_146295_m - this.field_147000_g) / 2;
            BiomeGenBase biome = (BiomeGenBase)this.biomeRegions.getRegion(x - j, y - k);
            if (biome != null || this.painter.activeElement != null) {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
            }
            this.painter.activeElement = this.erase ? fallback : (biome != null ? (GuiPainter.PaintElement)biomeEntries.get(biome) : null);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.page != GuiPages.BIOME || this.search.func_146206_l()) {
            // empty if block
        }
        if (this.erase) {
            this.painter.activeElement = fallback;
        }
    }

    private void recalcSelectedBiomes() {
        this.visibleBiomes.clear();
        Collection<BiomeGenBase> c = TileEntityBiomePainter.getValidBiomes();
        String code = this.search.func_146179_b();
        for (BiomeGenBase out : c) {
            if (code != null && !code.isEmpty() && (out.field_76791_y == null || !out.field_76791_y.toLowerCase(Locale.ENGLISH).startsWith(code.toLowerCase(Locale.ENGLISH)))) continue;
            this.visibleBiomes.add(out);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int x = 8;
        int y = 45;
        int dx = x;
        int dy = y;
        int i = 0;
        int n = 9;
        int h = this.field_146289_q.field_78288_b + 6;
        if (this.page == GuiPages.BIOME) {
            int mw = -1;
            this.biomeRegions.clear();
            for (BiomeGenBase b : this.visibleBiomes) {
                String name = b.field_76791_y != null ? b.field_76791_y : b.getClass().getSimpleName() + "@" + b.field_76756_M;
                int w = this.field_146289_q.func_78256_a(name);
                this.field_146289_q.func_78276_b(name, dx, dy, 0xFFFFFF);
                this.biomeRegions.addRegionByWH(dx - 1, dy - 1, w + 2, this.field_146289_q.field_78288_b + 2, (Object)b);
                if (api.isMouseInBox(j + dx - 2, j + dx + w + 2, k + dy - 1, k + dy + this.field_146289_q.field_78288_b + 1)) {
                    api.drawRectFrame(dx - 2, dy - 2, w + 3, this.field_146289_q.field_78288_b + 2, 0xFFFFFF);
                }
                mw = Math.max(mw, 6 + w);
                dy += h;
                if (++i % n == 0) {
                    dy = y;
                    dx += this.field_146999_f / 2;
                    mw = -1;
                }
                if (i < n * 2) continue;
                break;
            }
        }
    }

    @Override
    protected void func_146976_a(float p, int a, int b) {
        super.func_146976_a(p, a, b);
        if (this.page == GuiPages.BIOME) {
            this.search.func_146194_f();
        }
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        ++this.frame;
        if (this.page == GuiPages.PAINT) {
            this.redrawBiomes();
            this.painter.onRenderTick(a, b);
            this.painter.draw();
            this.painter.drawLegend(this.field_146289_q, j + 10 + 128 + 3, k + this.field_147000_g / 2 - 64);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
            if (GuiScreen.func_146272_n()) {
                for (int dx = -64; dx <= 64; dx += 16) {
                    for (int dz = -64; dz <= 64; dz += 16) {
                        int x = j + 10 + 64 + dx;
                        int y = k + this.field_147000_g / 2 + dz;
                        ReikaGuiAPI.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)(dx == 0 && dz == 0 ? -1 : -65536));
                    }
                }
            } else if (GuiScreen.func_146271_m()) {
                int x = j + 10 + 64;
                int y = k + this.field_147000_g / 2;
                ReikaGuiAPI.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)-65536);
            }
            GL11.glPopMatrix();
        }
        if (!this.erase) {
            String s = String.format("Active Biome: %s", this.painter.activeElement != null ? this.painter.activeElement.getName() : "None");
            api.drawCenteredStringNoShadow(this.field_146289_q, s, j + this.field_146999_f / 2, k + 180, 0xFFFFFF);
        }
        api.drawCenteredStringNoShadow(this.field_146289_q, "Brush: " + this.painter.brush.name, j + this.field_146999_f / 2, k + 190, 0xFFFFFF);
    }

    private void redrawBiomes() {
        int r;
        int d = r = 64 * 2 + 1;
        int n = ReikaMathLibrary.intpow2((int)r, (int)2);
        for (int i = 0; i < d; ++i) {
            int ix = this.refreshPosition % r - 64;
            int dx = this.tile.field_145851_c + ix;
            int iz = this.refreshPosition / r - 64;
            int dz = this.tile.field_145849_e + iz;
            BiomeGenBase biome = this.tile.field_145850_b.func_72807_a(dx, dz);
            BiomePaint bp = biomeEntries.get(biome);
            if (bp != null) {
                this.painter.force(ix + 64, iz + 64, bp);
            }
            ++this.refreshPosition;
            if (this.refreshPosition < n) continue;
            this.refreshPosition = 0;
        }
    }

    @Override
    public String getGuiTexture() {
        return "biome";
    }

    static {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == null) continue;
            int rgb = BiomeMapCommand.getBiomeColor((int)0, (int)0, (BiomeGenBase)b);
            biomeEntries.put(b, new BiomePaint(b, rgb));
        }
        fallback = new GuiPainter.PaintElement(){

            public void draw(int i, int k, int x, int y, int s, boolean legend) {
            }

            public String getName() {
                return "Natural";
            }

            public boolean isPaintable(GuiPainter.PaintElement original) {
                return true;
            }

            public void onPaintedTo(int x, int y) {
                GuiBiomeChanger gui = (GuiBiomeChanger)Minecraft.func_71410_x().field_71462_r;
                if (gui == null) {
                    return;
                }
                int dx = ((GuiBiomeChanger)gui).tile.field_145851_c + x - 64;
                int dz = ((GuiBiomeChanger)gui).tile.field_145849_e + y - 64;
                gui.painter.erase(x, y);
                gui.tile.changeBiomeAt(dx, dz, null);
            }
        };
    }

    private static enum GuiPages {
        PAINT,
        BIOME,
        BRUSH;

        private static GuiPages[] list;

        private GuiPages pre() {
            return this.ordinal() > 0 ? list[this.ordinal() - 1] : this;
        }

        private GuiPages next() {
            return this.ordinal() < list.length - 1 ? list[this.ordinal() + 1] : this;
        }

        static {
            list = GuiPages.values();
        }
    }

    private class BiomePainter
    extends GuiPainter {
        private final TileEntityBiomePainter tile;

        public BiomePainter(int x, int y, int w, int h, int s, TileEntityBiomePainter te) {
            super(x, y, w, h, s);
            this.tile = te;
            this.init();
        }

        protected GuiPainter.PaintElement getDefaultEntry(int x, int y) {
            return null;
        }

        protected GuiPainter.PaintElement getFallbackEntry(int x, int y) {
            return fallback;
        }

        private void force(int x, int y, BiomePaint bp) {
            this.put(x, y, bp);
        }
    }

    private static class BiomePaint
    implements GuiPainter.PaintElement {
        private final BiomeGenBase biome;
        private final int color;

        private BiomePaint(BiomeGenBase b, int c) {
            this.color = 0xFF000000 | c;
            this.biome = b;
        }

        public void draw(int i, int k, int x, int y, int s, boolean legend) {
            int c = this.color;
            int dx = staticTileRef.field_145851_c + i - 64;
            int dz = staticTileRef.field_145849_e + k - 64;
            if (!legend && GuiScreen.func_146271_m()) {
                int old = c;
                int dy = ReikaWorldHelper.getTopNonAirBlock((World)Minecraft.func_71410_x().field_71441_e, (int)dx, (int)dz, (boolean)true);
                if (ReikaFluidHelper.lookupFluidForBlock((Block)Minecraft.func_71410_x().field_71441_e.func_147439_a(dx, dy, dz)) == FluidRegistry.WATER) {
                    c = -13610753;
                }
                c = Minecraft.func_71410_x().field_71441_e.func_147439_a((int)dx, (int)dy, (int)dz).func_149728_f((int)0).field_76291_p;
                c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)c, (float)((float)(dy - 60) / 140.0f));
                c = ReikaColorAPI.mixColors((int)c, (int)old, (float)0.25f) | 0xFF000000;
            }
            if (!staticTileRef.canChangeBiomeAt(dx, dz, this.biome)) {
                int n = 10;
                c = ((dx + dz) % n + n) % n >= n / 2 ? ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color, (float)0.5f) : ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color, (float)0.25f);
                c = 0xFF000000 | c;
            }
            api.drawRect(x, y, s, s, c, true);
        }

        public String getName() {
            return this.biome.field_76791_y != null ? this.biome.field_76791_y : this.biome.getClass().getSimpleName() + "@" + this.biome.field_76756_M;
        }

        public boolean isPaintable(GuiPainter.PaintElement original) {
            return original == fallback || TileEntityBiomePainter.getValidBiomesFor(((BiomePaint)original).biome).contains(this.biome);
        }

        public void onPaintedTo(int x, int y) {
            int dx = staticTileRef.field_145851_c + x - 64;
            int dz = staticTileRef.field_145849_e + y - 64;
            staticTileRef.changeBiomeAt(dx, dz, this.biome);
        }
    }
}

