/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Instantiable.Data.CircularDivisionRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;

public class GuiLumenAlveary
extends GuiChromaBase {
    private static final Collection<TileEntityLumenAlveary.AlvearyEffect> allEffects = new ArrayList<TileEntityLumenAlveary.AlvearyEffect>();
    private static final Object BASIC_KEY = new Object();
    private final TileEntityLumenAlveary tile;
    private final ArrayList<TileEntityLumenAlveary.AlvearyEffect> activeEffects = new ArrayList();
    private final AlvearyEffectControlSet controls = new AlvearyEffectControlSet(TileEntityLumenAlveary.AlvearyEffect.class);
    private Categories currentCategory = null;
    private Object selectedKey;

    public GuiLumenAlveary(EntityPlayer ep, TileEntityLumenAlveary te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.tile = te;
        this.setData();
    }

    private AlvearyEffectControlSet getControlSet(Class<? extends TileEntityLumenAlveary.AlvearyEffect> c) {
        AlvearyEffectControlSet set = this.controls;
        AlvearyEffectControlSet child = (AlvearyEffectControlSet)set.children.get(c);
        while (child != null) {
            set = child;
            child = (AlvearyEffectControlSet)set.children.get(c);
        }
        return set;
    }

    private AlvearyEffectControlSet getCurrentControlSet() {
        return this.currentCategory == null ? this.controls : this.getControlSet(this.currentCategory.classRef);
    }

    private void loadControllers() {
        this.controls.children.clear();
        this.controls.controls.clear();
        ArrayList<TileEntityLumenAlveary.AlvearyEffect> c = new ArrayList<TileEntityLumenAlveary.AlvearyEffect>(allEffects);
        AlvearyEffectControlSet bset = new AlvearyEffectControlSet(TileEntityLumenAlveary.AlvearyEffect.class);
        LumenAlvearyEffectControlSet lset = new LumenAlvearyEffectControlSet();
        this.controls.addChild(TileEntityLumenAlveary.AlvearyEffect.class, bset);
        this.controls.addChild(TileEntityLumenAlveary.LumenAlvearyEffect.class, lset);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            TileEntityLumenAlveary.AlvearyEffect ae = (TileEntityLumenAlveary.AlvearyEffect)it.next();
            if (!(ae instanceof TileEntityLumenAlveary.LumenAlvearyEffect)) continue;
            TileEntityLumenAlveary.LumenAlvearyEffect lae = (TileEntityLumenAlveary.LumenAlvearyEffect)ae;
            lset.addControl(lae.color, lae);
            it.remove();
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            VisAlvearyEffectControlSet vset = new VisAlvearyEffectControlSet();
            this.controls.addChild(TileEntityLumenAlveary.VisAlvearyEffect.class, vset);
            it = c.iterator();
            while (it.hasNext()) {
                TileEntityLumenAlveary.AlvearyEffect ae = (TileEntityLumenAlveary.AlvearyEffect)it.next();
                if (!(ae instanceof TileEntityLumenAlveary.VisAlvearyEffect)) continue;
                TileEntityLumenAlveary.VisAlvearyEffect vae = (TileEntityLumenAlveary.VisAlvearyEffect)ae;
                vset.addControl(vae.aspect, vae);
                it.remove();
            }
        }
        for (TileEntityLumenAlveary.AlvearyEffect ae : c) {
            bset.addControl(BASIC_KEY, ae);
        }
    }

    private void setData() {
        this.loadControllers();
        this.activeEffects.clear();
        this.activeEffects.addAll(this.tile.getSelectedEffects());
        Collections.sort(this.activeEffects, TileEntityLumenAlveary.effectSorter);
        this.controls.setActiveStates(this.activeEffects);
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        AlvearyEffectControlSet set = this.getCurrentControlSet();
        Proportionality buttons = set.getCurrentButtonSet(this.selectedKey);
        Object hover = buttons.getClickedSection(x, y);
        if (set.isTopLevel()) {
            AlvearyEffectControlSet cat = (AlvearyEffectControlSet)hover;
            this.selectedKey = null;
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
            if (cat != null) {
                Categories c = cat.getCategory();
                if (c.isValid()) {
                    this.currentCategory = c;
                }
            } else {
                this.currentCategory = null;
            }
        } else if (this.selectedKey != null) {
            AlvearyEffectControl e = (AlvearyEffectControl)hover;
            if (e != null) {
                e.isActive = !e.isActive;
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
                ReikaPacketHelper.sendStringIntPacket((String)"ChromaData", (int)ChromaPackets.ALVEARYEFFECT.ordinal(), (TileEntity)this.tile, (String)e.effect.ID, (int[])new int[]{e.isActive ? 1 : 0});
            } else {
                this.selectedKey = null;
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
            }
        } else if (hover != null) {
            this.selectedKey = hover;
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
        } else {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
            this.currentCategory = null;
        }
    }

    @Override
    protected void func_146976_a(float f, int a, int b) {
        super.func_146976_a(f, a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int x = j + this.field_146999_f / 2;
        int y = k + this.field_147000_g / 2;
        int r = 64;
        AlvearyEffectControlSet set = this.getCurrentControlSet();
        Proportionality buttons = set.getCurrentButtonSet(this.selectedKey);
        String ttip = null;
        Object hover = buttons.getClickedSection(a, b);
        if (set.isTopLevel()) {
            AlvearyEffectControlSet cat = (AlvearyEffectControlSet)hover;
            if (cat != null) {
                ttip = cat.type.getSimpleName().replace("Alveary", "") + "s";
                if (ttip.equals("Effects")) {
                    ttip = "BasicEffects";
                }
                ttip = ReikaStringParser.splitCamelCase((String)ttip);
            }
        } else if (this.selectedKey != null) {
            AlvearyEffectControl e = (AlvearyEffectControl)hover;
            if (e != null) {
                e.isHovered = true;
                ttip = e.getTooltip();
            }
        } else if (hover != null) {
            Collection c = set.controls.get(hover);
            for (AlvearyEffectControl ae2 : c) {
                ae2.isSetHovered = true;
            }
            String pre = set.getKeyName(hover);
            pre = pre == null ? "" : pre + ": ";
            ttip = String.valueOf(pre + c.size() + " Effects");
        }
        int key = System.identityHashCode(set.type);
        if (this.selectedKey != null) {
            key ^= System.identityHashCode(this.selectedKey);
        }
        buttons.setGeometry((double)x, (double)y, (double)r, (double)(key % 360));
        buttons.resetColors();
        buttons.render();
        this.controls.resetHover();
        if (ttip != null) {
            ArrayList<String> li = new ArrayList<String>();
            for (String s : ttip.split("\\\n")) {
                li.add(s);
            }
            api.drawSplitTooltipAt(this.field_146289_q, li, a, b);
        }
        float lf = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)4.0f);
        api.drawCircle((double)x, (double)y, (double)r, 0);
        GL11.glLineWidth((float)lf);
    }

    @Override
    public String getGuiTexture() {
        return "alveary";
    }

    static {
        allEffects.addAll(TileEntityLumenAlveary.getEffectSet());
    }

    private static class VisAlvearyEffectControlSet
    extends AlvearyEffectControlSet<Aspect, VisAlvearyEffectControl, TileEntityLumenAlveary.VisAlvearyEffect> {
        protected VisAlvearyEffectControlSet() {
            super(TileEntityLumenAlveary.VisAlvearyEffect.class);
        }

        @Override
        protected VisAlvearyEffectControl constructControl(Aspect k, TileEntityLumenAlveary.VisAlvearyEffect e, int idx) {
            VisAlvearyEffectControl ret = new VisAlvearyEffectControl(e, idx);
            return ret;
        }

        @Override
        public String getKeyName(Object o) {
            return ((Aspect)o).getName();
        }

        @Override
        protected int getColorForKey(Aspect k) {
            return k.getColor();
        }

        @Override
        protected int getColor() {
            return Aspect.MAGIC.getColor();
        }
    }

    private static class LumenAlvearyEffectControlSet
    extends AlvearyEffectControlSet<CrystalElement, LumenAlvearyEffectControl, TileEntityLumenAlveary.LumenAlvearyEffect> {
        protected LumenAlvearyEffectControlSet() {
            super(TileEntityLumenAlveary.LumenAlvearyEffect.class);
        }

        @Override
        protected LumenAlvearyEffectControl constructControl(CrystalElement k, TileEntityLumenAlveary.LumenAlvearyEffect e, int idx) {
            LumenAlvearyEffectControl ret = new LumenAlvearyEffectControl(e, idx);
            return ret;
        }

        @Override
        public String getKeyName(Object o) {
            return ((CrystalElement)o).displayName;
        }

        @Override
        protected int getColorForKey(CrystalElement k) {
            return k.getColor();
        }

        @Override
        protected int getColor() {
            return 0x22AAFF;
        }

        @Override
        protected boolean isSorted() {
            return true;
        }
    }

    private static class AlvearyEffectControlSet<K, V extends AlvearyEffectControl, E extends TileEntityLumenAlveary.AlvearyEffect>
    implements Comparable<AlvearyEffectControlSet> {
        private final MultiMap<K, V> controls = new MultiMap(MultiMap.CollectionType.LIST, this.getDeterminator());
        private final HashMap<Class, AlvearyEffectControlSet> children = new HashMap();
        private final Proportionality<K> buttonsGlobal = new Proportionality(this.getDeterminator());
        private final Proportionality<AlvearyEffectControlSet> childButtons = new Proportionality((MultiMap.MapDeterminator)new MultiMap.SortedDeterminator());
        private final HashMap<K, Proportionality<V>> buttonsLocal = new HashMap();
        protected final Class type;

        protected AlvearyEffectControlSet(Class<E> c) {
            this.type = c;
            this.buttonsGlobal.drawSeparationLines = true;
            this.childButtons.drawSeparationLines = true;
        }

        public final Categories getCategory() {
            return Categories.getByType(this.type);
        }

        protected final void addControl(K k, E e) {
            V v = this.constructControl(k, e, this.controls.get(k).size());
            this.controls.addValue(k, v);
            this.buttonsGlobal.addValue(k, 10.0);
            this.buttonsGlobal.addColorRenderer(k, (CircularDivisionRenderer.ColorCallback)new CircularDivisionRenderer.IntColorCallback(this.getColorForKey(k)));
            Proportionality p = this.buttonsLocal.get(k);
            if (p == null) {
                p = new Proportionality(this.getDeterminator());
                p.drawSeparationLines = true;
                this.buttonsLocal.put(k, p);
            }
            p.addValue(v, 10.0);
        }

        protected final void addChild(Class c, AlvearyEffectControlSet s) {
            this.children.put(c, s);
            this.childButtons.addValue((Object)s, 10.0);
            this.childButtons.addColorRenderer((Object)s, (CircularDivisionRenderer.ColorCallback)new CircularDivisionRenderer.IntColorCallback(s.getColor()));
        }

        private MultiMap.MapDeterminator getDeterminator() {
            return this.isSorted() ? new MultiMap.SortedDeterminator() : null;
        }

        protected boolean isSorted() {
            return false;
        }

        public String getKeyName(Object o) {
            return null;
        }

        protected int getColor() {
            return 0xFFFFFF;
        }

        protected int getColorForKey(K k) {
            return 0xFFFFFF;
        }

        protected V constructControl(K k, E e, int idx) {
            AlvearyEffectControl ret = new AlvearyEffectControl((TileEntityLumenAlveary.AlvearyEffect)e, idx);
            return (V)ret;
        }

        public final void setActiveStates(Collection<TileEntityLumenAlveary.AlvearyEffect> c) {
            for (AlvearyEffectControl e : this.controls.allValues(false)) {
                e.isActive = c.contains(e.effect);
            }
            for (AlvearyEffectControlSet ch : this.children.values()) {
                ch.setActiveStates(c);
            }
        }

        public void resetHover() {
            for (AlvearyEffectControl e : this.controls.allValues(false)) {
                e.isSetHovered = false;
                e.isHovered = false;
            }
            for (AlvearyEffectControlSet ch : this.children.values()) {
                ch.resetHover();
            }
        }

        public Proportionality getCurrentButtonSet(Object key) {
            if (this.isTopLevel()) {
                return this.childButtons;
            }
            return key == null ? this.buttonsGlobal : this.buttonsLocal.get(key);
        }

        public final boolean isTopLevel() {
            return this.controls.isEmpty() && !this.children.isEmpty();
        }

        @Override
        public final int compareTo(AlvearyEffectControlSet o) {
            return Integer.compare(this.getIndex(), o.getIndex());
        }

        private final int getIndex() {
            return this.getCategory().ordinal();
        }
    }

    private static class VisAlvearyEffectControl
    extends AlvearyEffectControl {
        private final TileEntityLumenAlveary.VisAlvearyEffect effect;

        private VisAlvearyEffectControl(TileEntityLumenAlveary.VisAlvearyEffect l, int idx) {
            super(l, idx);
            this.effect = l;
        }

        @Override
        public int getColor(Object key) {
            int c = this.effect.aspect.getColor();
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)this.getBrightnessModifier());
            float f = this.isHovered ? 0.625f : (this.isSetHovered ? 0.8f : 1.0f);
            return ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)f);
        }
    }

    private static class LumenAlvearyEffectControl
    extends AlvearyEffectControl {
        private final TileEntityLumenAlveary.LumenAlvearyEffect effect;
        private final int hue;

        private LumenAlvearyEffectControl(TileEntityLumenAlveary.LumenAlvearyEffect l, int idx) {
            super(l, idx);
            this.effect = l;
            this.hue = ReikaColorAPI.getHue((int)l.color.getColor()) - 45 + 15 * this.index;
        }

        @Override
        public int getColor(Object key) {
            int c = this.effect.color.getColor();
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)this.getBrightnessModifier());
            if (this.isHovered) {
                return ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.625f);
            }
            if (this.isSetHovered) {
                return ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.8f);
            }
            return c;
        }
    }

    private static class AlvearyEffectControl
    implements CircularDivisionRenderer.ColorCallback,
    Comparable<AlvearyEffectControl> {
        protected final TileEntityLumenAlveary.AlvearyEffect effect;
        protected final int index;
        protected boolean isActive = true;
        protected boolean isHovered = false;
        protected boolean isSetHovered = false;

        private AlvearyEffectControl(TileEntityLumenAlveary.AlvearyEffect l, int idx) {
            this.effect = l;
            this.index = idx;
        }

        public final String getTooltip() {
            String base = this.effect.getDescription() + "\nEnabled: " + this.isActive;
            if (this.effect instanceof TileEntityLumenAlveary.PoweredAlvearyEffect) {
                TileEntityLumenAlveary.PoweredAlvearyEffect pef = (TileEntityLumenAlveary.PoweredAlvearyEffect)this.effect;
                base = base + "\n" + pef.getResource() + ": " + pef.getCost() + "/cycle";
            }
            return base;
        }

        @Override
        public final int compareTo(AlvearyEffectControl o) {
            return TileEntityLumenAlveary.effectSorter.compare(this.effect, o.effect);
        }

        public int getColor(Object key) {
            return ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)this.getBrightnessModifier());
        }

        protected final float getBrightnessModifier() {
            float base = this.isActive ? 0.9375f : 0.375f;
            double mod = this.isActive ? 240.0 : 400.0;
            return (float)((double)base + 0.0625 * Math.sin((double)System.currentTimeMillis() / mod + (double)this.effect.hashCode()));
        }
    }

    private static enum Categories {
        BASIC(TileEntityLumenAlveary.AlvearyEffect.class),
        LUMEN(TileEntityLumenAlveary.LumenAlvearyEffect.class),
        VIS(TileEntityLumenAlveary.VisAlvearyEffect.class);

        public final Class<? extends TileEntityLumenAlveary.AlvearyEffect> classRef;
        private static final Categories[] list;

        private Categories(Class<? extends TileEntityLumenAlveary.AlvearyEffect> c) {
            this.classRef = c;
        }

        protected static Categories getByType(Class c) {
            for (Categories cg : list) {
                if (cg.classRef != c) continue;
                return cg;
            }
            return null;
        }

        public boolean isValid() {
            switch (this) {
                case VIS: {
                    return ModList.THAUMCRAFT.isLoaded();
                }
            }
            return true;
        }

        static {
            list = Categories.values();
        }
    }
}

