/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityParticleSpawner;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.BoundedValue;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.GUI.ScrollingButtonList;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Interfaces.IconEnum;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class GuiParticleSpawner
extends GuiChromaBase {
    private final TileEntityParticleSpawner tile;
    private GuiPage page = GuiPage.POSITION;
    private boolean RGBMode = true;
    private int red;
    private int green;
    private int blue;
    private int hue;
    private float saturation;
    private float luminosity;
    private int color;
    private GuiTextField filename;
    private int selectedIcon = -1;
    private static ArrayList<IconEnum> permittedIcons = new ArrayList();
    public static final int MAX_ICON_ROWS = 6;
    public static final int MAX_ICON_COLS = 7;
    private static final ScrollingButtonList iconButtons = new ScrollingButtonList(6, 7);

    public GuiParticleSpawner(EntityPlayer ep, TileEntityParticleSpawner te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.tile = te;
        this.color = this.tile.particles.particleColor;
        this.red = ReikaColorAPI.getRed((int)this.color);
        this.green = ReikaColorAPI.getGreen((int)this.color);
        this.blue = ReikaColorAPI.getBlue((int)this.color);
        float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        this.hue = (int)(hsv[0] * 360.0f);
        this.saturation = hsv[1];
        this.luminosity = hsv[2];
        this.buildIconList();
    }

    private static void buildIconList() {
        int i;
        permittedIcons.clear();
        iconButtons.clear();
        for (i = 0; i < 16; ++i) {
            permittedIcons.add(CrystalElement.elements[i]);
            iconButtons.addButton();
        }
        for (i = 0; i < ChromaIcons.iconList.length; ++i) {
            ChromaIcons ico = ChromaIcons.iconList[i];
            if (!GuiParticleSpawner.isIconAllowed(ico)) continue;
            permittedIcons.add(ico);
            iconButtons.addButton();
        }
    }

    private static boolean isIconAllowed(ChromaIcons ico) {
        switch (ico) {
            case TRANSPARENT: 
            case GUARDIANOUTER: 
            case SPARKLE_ROUNDED: 
            case REPEATER: 
            case MULTIREPEATER: 
            case BROADCAST: 
            case LASER: 
            case LASEREND: 
            case RIFT: 
            case RIFTHALO: 
            case NOENTER: 
            case CHECK: 
            case QUESTION: 
            case BLUEFIRE: 
            case BATTERY: 
            case BLANK: 
            case ALLCOLORS: 
            case BASICFADE: 
            case BASICFADE_FAST: 
            case FRAME: 
            case REGIONS: 
            case WEAKREPEATER: 
            case LATTICE: 
            case GLOWFRAME_TRANS: 
            case GLOWFRAMEDOT_TRANS: 
            case FAN: 
            case SIDEDFLOW: 
            case WIDEBAR: 
            case AVOLASER: 
            case AVOLASER_CORE: 
            case HIVE: 
            case HIVESPARKS: 
            case CAUSTICS_GENTLE_ALPHA: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_73866_w_() {
        int v;
        int u;
        int y;
        int x;
        int i;
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i2 = 0; i2 < GuiPage.list.length; ++i2) {
            GuiPage.list[i2].initOptions(this.tile, this.RGBMode);
        }
        String file = this.getFullTexturePath();
        int n = 4;
        for (i = 0; i < GuiPage.list.length; ++i) {
            x = j + n;
            y = k + n + 20 * i;
            u = i == this.page.ordinal() ? 198 : 178;
            v = i * 20;
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(i, x, y, 20, 20, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        }
        switch (this.page) {
            case POSITION: 
            case VELOCITY: {
                for (i = 0; i < 12; ++i) {
                    x = j + 29 + i % 2 * 122;
                    y = k + 19 + i / 2 * 24;
                    u = i % 2 == 1 ? 126 : 106;
                    v = 173;
                    CustomSoundGuiButton.CustomSoundImagedGuiButton b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i + 100, x, y, 20, 20, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                    this.field_146292_n.add(b);
                }
                break;
            }
            case COLOR: {
                CustomSoundGuiButton.CustomSoundImagedGuiButton b;
                for (i = 0; i < 16; ++i) {
                    x = j + 27 + i % 8 * 18;
                    y = k + 18 + i / 8 * 18;
                    u = 106;
                    v = 213;
                    b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i + 100, x, y, 20, 20, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                    b.icon = CrystalElement.elements[i].getGlowRune();
                    b.iconWidth = 16;
                    b.iconHeight = 16;
                    this.field_146292_n.add(b);
                }
                for (i = 0; i < 8; ++i) {
                    x = j + 29 + i % 2 * 122;
                    y = k + 58 + i / 2 * 20;
                    u = i % 2 == 1 ? 126 : 106;
                    v = i >= 6 ? 193 : 173;
                    b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i + 200, x, y, 20, 20, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                    this.field_146292_n.add(b);
                }
                int in = 45;
                this.field_146292_n.add(new GuiButton(300, j + 29 + in, k + 142, 143 - in * 2, 20, !this.RGBMode ? "HSV" : "RGB"));
                break;
            }
            case ICON: {
                this.field_146292_n.add(new GuiButton(50, j + 27, k + 144, 20, 20, "^"));
                this.field_146292_n.add(new GuiButton(51, j + 47, k + 144, 20, 20, "v"));
                int i3 = 0;
                for (IconEnum ico : permittedIcons) {
                    if (i3 >= iconButtons.getBaseOffset() && i3 <= iconButtons.getHighestVisible()) {
                        int rowPos = i3 / 7 - iconButtons.getScroll();
                        int x2 = j + 29 + i3 % 7 * 21 - 2;
                        int y2 = k + 18 + rowPos * 21;
                        int u2 = 106;
                        int v2 = 213;
                        CustomSoundGuiButton.CustomSoundImagedGuiButton b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i3 + 100, x2, y2, 20, 20, u2, v2, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                        b.icon = ico.getIcon();
                        b.iconWidth = 16;
                        b.iconHeight = 16;
                        this.field_146292_n.add(b);
                        if (ico == this.tile.particles.particleIcon) {
                            this.selectedIcon = b.field_146127_k - 100;
                        }
                    }
                    ++i3;
                }
                break;
            }
            case TIMING: {
                int u3;
                int y3;
                int x3;
                int i3;
                for (i3 = 0; i3 < 8; ++i3) {
                    x3 = j + 29 + i3 % 2 * 122;
                    y3 = k + 19 + i3 / 2 * 24;
                    u3 = i3 % 2 == 1 ? 126 : 106;
                    int v3 = 173;
                    if (i3 >= 6) {
                        v3 += 20;
                    }
                    CustomSoundGuiButton.CustomSoundImagedGuiButton b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i3 + 100, x3, y3, 20, 20, u3, v3, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                    this.field_146292_n.add(b);
                }
                break;
            }
            case MODIFIER: {
                int u3;
                int y3;
                int x3;
                int i3;
                for (i3 = 0; i3 < 14; ++i3) {
                    x3 = j + 29 + i3 % 2 * 122;
                    y3 = k + 19 + i3 / 2 * 20;
                    u3 = i3 % 2 == 1 ? 126 : 106;
                    int v4 = 173;
                    if (i3 >= 8) {
                        v4 += 20;
                    }
                    CustomSoundGuiButton.CustomSoundImagedGuiButton b = new CustomSoundGuiButton.CustomSoundImagedGuiButton(i3 + 100, x3, y3, 20, 20, u3, v4, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this);
                    this.field_146292_n.add(b);
                }
                break;
            }
            case SAVELOAD: {
                int d = 4;
                this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(-1, j + 31 + d, k + 124, 20, 20, 152, 173, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
                this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(-2, j + 31 - d + this.field_146999_f - 40 - 18, k + 124, 20, 20, 152, 193, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
                String s = "";
                if (this.filename != null) {
                    s = this.filename.func_146179_b();
                }
                this.filename = new GuiTextField(this.field_146289_q, j + 32, k + 106, this.field_146999_f - 40, 16);
                this.filename.func_146203_f(112);
                this.filename.func_146195_b(false);
                this.filename.func_146180_a(s);
            }
        }
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == -1) {
            try {
                this.saveProgram();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (b.field_146127_k == -2) {
            try {
                this.loadProgram();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (b.field_146127_k < GuiPage.list.length) {
            this.page = GuiPage.list[b.field_146127_k];
            iconButtons.reset();
        } else {
            int n = 1;
            if (GuiScreen.func_146272_n()) {
                n = 4;
                if (this.page == GuiPage.COLOR || this.page == GuiPage.TIMING && !ReikaMathLibrary.isValueInsideBoundsIncl((int)2, (int)3, (int)(b.field_146127_k - 100))) {
                    n = 5;
                } else if (this.page == GuiPage.ICON || this.page == GuiPage.MODIFIER && ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)9, (int)(b.field_146127_k - 100))) {
                    n = 1;
                }
            }
            block12: for (int i = 0; i < n; ++i) {
                switch (this.page) {
                    case POSITION: {
                        this.handlePositionButton(b.field_146127_k - 100);
                        continue block12;
                    }
                    case VELOCITY: {
                        this.handleVelocityButton(b.field_146127_k - 100);
                        continue block12;
                    }
                    case COLOR: {
                        this.handleColorButton(b.field_146127_k);
                        continue block12;
                    }
                    case ICON: {
                        if (b.field_146127_k == 50) {
                            if (!iconButtons.scrollUp()) continue block12;
                            this.func_73866_w_();
                            continue block12;
                        }
                        if (b.field_146127_k == 51) {
                            if (!iconButtons.scrollDown()) continue block12;
                            this.func_73866_w_();
                            continue block12;
                        }
                        if (b.field_146127_k < 100) continue block12;
                        int idx = b.field_146127_k - 100;
                        this.tile.particles.particleIcon = permittedIcons.get(idx);
                        this.selectedIcon = idx;
                        continue block12;
                    }
                    case TIMING: {
                        this.handleTimingButton(b.field_146127_k - 100);
                        continue block12;
                    }
                    case MODIFIER: {
                        this.handleModifierButton(b.field_146127_k - 100);
                        continue block12;
                    }
                }
            }
        }
        this.tile.particles.sendData();
        this.func_73866_w_();
    }

    private void saveProgram() throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        this.tile.writeCopyableData(tag);
        NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.getFile());
        nf.data = tag;
        nf.save();
    }

    private void loadProgram() throws IOException {
        NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.getFile());
        nf.load();
        if (nf.data != null) {
            this.tile.particles.readFromNBT(nf.data, this.tile);
        }
    }

    private File getFolder() {
        return new File(new File(DragonAPICore.getMinecraftDirectory(), "ChromatiCraft_Data"), "ParticlePrograms");
    }

    private File getFile() {
        return new File(this.getFolder(), this.filename.func_146179_b() + ".par");
    }

    private void handleModifierButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleGravity.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleGravity.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleGravity.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleGravity.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleSize.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleSize.increase();
                break;
            }
            case 6: {
                this.tile.particles.particleSize.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particleSize.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particleCollision = false;
                break;
            }
            case 9: {
                this.tile.particles.particleCollision = true;
                break;
            }
            case 10: {
                this.tile.particles.rapidExpand = false;
                break;
            }
            case 11: {
                this.tile.particles.rapidExpand = true;
                break;
            }
            case 12: {
                this.tile.particles.noSlowdown = false;
                break;
            }
            case 13: {
                this.tile.particles.noSlowdown = true;
            }
        }
    }

    private void handleTimingButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleLife.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleLife.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleLife.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleLife.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleRate.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleRate.increase();
                break;
            }
            case 6: {
                this.tile.particles.alphaFade = false;
                break;
            }
            case 7: {
                this.tile.particles.alphaFade = true;
            }
        }
    }

    private void handlePositionButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particlePositionX.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particlePositionX.increase();
                break;
            }
            case 2: {
                this.tile.particles.particlePositionX.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particlePositionX.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particlePositionY.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particlePositionY.increase();
                break;
            }
            case 6: {
                this.tile.particles.particlePositionY.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particlePositionY.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particlePositionZ.decrease();
                break;
            }
            case 9: {
                this.tile.particles.particlePositionZ.increase();
                break;
            }
            case 10: {
                this.tile.particles.particlePositionZ.decreaseVariation();
                break;
            }
            case 11: {
                this.tile.particles.particlePositionZ.increaseVariation();
            }
        }
    }

    private void handleVelocityButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleVelocityX.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleVelocityX.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleVelocityX.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleVelocityX.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleVelocityY.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleVelocityY.increase();
                break;
            }
            case 6: {
                this.tile.particles.particleVelocityY.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particleVelocityY.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particleVelocityZ.decrease();
                break;
            }
            case 9: {
                this.tile.particles.particleVelocityZ.increase();
                break;
            }
            case 10: {
                this.tile.particles.particleVelocityZ.decreaseVariation();
                break;
            }
            case 11: {
                this.tile.particles.particleVelocityZ.increaseVariation();
            }
        }
    }

    private void handleColorButton(int id) {
        if (id == 300) {
            this.RGBMode = !this.RGBMode;
            this.roundColors();
        } else if (id >= 200) {
            if (this.RGBMode) {
                switch (id - 200) {
                    case 0: {
                        this.red = Math.max(this.red - 1, 0);
                        break;
                    }
                    case 1: {
                        this.red = Math.min(this.red + 1, 255);
                        break;
                    }
                    case 2: {
                        this.green = Math.max(this.green - 1, 0);
                        break;
                    }
                    case 3: {
                        this.green = Math.min(this.green + 1, 255);
                        break;
                    }
                    case 4: {
                        this.blue = Math.max(this.blue - 1, 0);
                        break;
                    }
                    case 5: {
                        this.blue = Math.min(this.blue + 1, 255);
                    }
                }
                this.calcColors(1);
            } else {
                switch (id - 200) {
                    case 0: {
                        this.hue = Math.max(this.hue - 1, 0);
                        break;
                    }
                    case 1: {
                        this.hue = Math.min(this.hue + 1, 360);
                        break;
                    }
                    case 2: {
                        this.saturation = Math.max(this.saturation - 0.05f, 0.0f);
                        break;
                    }
                    case 3: {
                        this.saturation = Math.min(this.saturation + 0.05f, 1.0f);
                        break;
                    }
                    case 4: {
                        this.luminosity = Math.max(this.luminosity - 0.05f, 0.0f);
                        break;
                    }
                    case 5: {
                        this.luminosity = Math.min(this.luminosity + 0.05f, 1.0f);
                    }
                }
                this.calcColors(0);
            }
            if (id - 200 == 6) {
                this.tile.particles.cyclingColor = false;
            }
            if (id - 200 == 7) {
                this.tile.particles.cyclingColor = true;
            }
        } else if (id >= 100) {
            this.color = CrystalElement.elements[id - 100].getColor();
            this.calcColors(2);
        }
    }

    private void roundColors() {
        if (!this.RGBMode) {
            this.saturation = ReikaMathLibrary.roundToDecimalPlaces((float)this.saturation, (int)1);
            this.luminosity = ReikaMathLibrary.roundToDecimalPlaces((float)this.luminosity, (int)1);
        }
        this.calcColors(0);
    }

    private void calcColors(int mode) {
        switch (mode) {
            case 0: {
                this.color = Color.HSBtoRGB((float)this.hue / 360.0f, this.saturation, this.luminosity);
                this.red = ReikaColorAPI.getRed((int)this.color);
                this.green = ReikaColorAPI.getGreen((int)this.color);
                this.blue = ReikaColorAPI.getBlue((int)this.color);
                break;
            }
            case 1: {
                this.color = ReikaColorAPI.RGBtoHex((int)this.red, (int)this.green, (int)this.blue);
                float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
                this.hue = (int)(hsv[0] * 360.0f);
                this.saturation = hsv[1];
                this.luminosity = hsv[2];
                break;
            }
            case 2: {
                this.red = ReikaColorAPI.getRed((int)this.color);
                this.green = ReikaColorAPI.getGreen((int)this.color);
                this.blue = ReikaColorAPI.getBlue((int)this.color);
                float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
                this.hue = (int)(hsv[0] * 360.0f);
                this.saturation = hsv[1];
                this.luminosity = hsv[2];
                break;
            }
        }
        this.tile.particles.particleColor = this.color;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.page == GuiPage.SAVELOAD) {
            this.filename.func_146192_a(x, y, b);
        }
    }

    protected void func_73869_a(char c, int i) {
        if (!(i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || this.filename != null && this.filename.func_146206_l())) {
            super.func_73869_a(c, i);
        }
        if (this.page == GuiPage.SAVELOAD) {
            this.filename.func_146201_a(c, i);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        int[] pos;
        super.func_146979_b(par1, par2);
        if (this.page == GuiPage.ICON && (pos = iconButtons.getPositionOf(this.selectedIcon)) != null) {
            int s = 18;
            int s2 = s + 3;
            api.drawRectFrame(28 + pos[0] * s2, 19 + pos[1] * s2, s, s, ReikaColorAPI.mixColors((int)0xFF00FF, (int)0x22AAFF, (float)(0.5f + 0.5f * (float)Math.sin((double)System.currentTimeMillis() / 300.0))));
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.page == GuiPage.SAVELOAD) {
            int i;
            api.drawCenteredStringNoShadow(this.field_146289_q, "Particle File:", j + this.field_146999_f / 2, k + 20, 65280);
            String path = this.getFile().getParentFile().getAbsolutePath().replace("\\.\\", "\\") + "\\";
            ArrayList<String> li = new ArrayList<String>();
            int lastFolder = -1;
            int i0 = 0;
            for (i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '\\') {
                    lastFolder = i;
                }
                if (i - i0 < 24) continue;
                li.add(path.substring(i0, lastFolder + 1));
                i0 = lastFolder + 1;
            }
            li.add(path.substring(i0));
            li.remove(".");
            for (i = 0; i < li.size(); ++i) {
                String s = (String)li.get(i);
                this.field_146289_q.func_78276_b(s, j + 35, k + 31 + i * (this.field_146289_q.field_78288_b + 1), 0xFFFFFF);
            }
            this.filename.func_146194_f();
            if (!this.filename.func_146206_l()) {
                // empty if block
            }
            i = this.field_146289_q.func_78256_a(this.filename.func_146179_b());
        }
        int i = 0;
        int sy = this.page == GuiPage.MODIFIER || this.page == GuiPage.COLOR ? 20 : 24;
        for (Option o : this.page.options) {
            int dx = j + 49;
            int dy = k + 19 + sy * i;
            if (this.page == GuiPage.COLOR) {
                dy += 39;
            }
            ++i;
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getFullTexturePath());
            api.func_73729_b(dx, dy, 0, 173, 102, 20);
            String s = o.display + ": " + String.valueOf(o.getValue());
            GL11.glTranslated((double)0.0, (double)0.0, (double)350.0);
            api.drawCenteredStringNoShadow(this.field_146289_q, s, dx + 51, dy + 6, 0xFFFFFF);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-350.0);
            if (!(o instanceof VariableOption)) continue;
            VariableOption v = (VariableOption)o;
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getFullTexturePath());
            api.func_73729_b(dx, dy += sy, 0, 173, 102, 20);
            s = "Variance: " + String.valueOf(v.getVariance());
            GL11.glTranslated((double)0.0, (double)0.0, (double)350.0);
            api.drawCenteredStringNoShadow(this.field_146289_q, s, dx + 51, dy + 6, 0xFFFFFF);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-350.0);
            ++i;
        }
    }

    @Override
    public String getGuiTexture() {
        return "particle";
    }

    static {
        GuiParticleSpawner.buildIconList();
    }

    private static class VariableOption<N extends Number>
    extends Option {
        private final TileEntityParticleSpawner.VariableValue<N> value;

        private VariableOption(String s, TileEntityParticleSpawner.VariableValue<N> v) {
            super(s);
            this.value = v;
        }

        public Number getValue() {
            return this.value.getValue();
        }

        public Number getVariance() {
            return this.value.getVariation();
        }
    }

    private static class SliderOption<N extends Number>
    extends Option {
        private final BoundedValue<N> value;

        private SliderOption(String s, BoundedValue<N> v) {
            super(s);
            this.value = v;
        }

        public Number getValue() {
            return this.value.getValue();
        }
    }

    private static class ToggleOption<N extends Number>
    extends Option {
        private boolean isEnabled;

        private ToggleOption(String s) {
            this(s, false);
        }

        private ToggleOption(String s, boolean b) {
            super(s);
            this.isEnabled = b;
        }

        public Number getValue() {
            return this.isEnabled ? 1 : 0;
        }
    }

    private static abstract class Option<N extends Number> {
        public final String display;

        private Option(String s) {
            this.display = s;
        }

        public abstract N getValue();
    }

    private static enum GuiPage {
        POSITION,
        VELOCITY,
        COLOR,
        ICON,
        TIMING,
        MODIFIER,
        SAVELOAD;

        private static final GuiPage[] list;
        private final ArrayList<Option> options = new ArrayList();

        private void initOptions(TileEntityParticleSpawner p, boolean RGB) {
            this.options.clear();
            switch (this) {
                case POSITION: {
                    this.options.add(new VariableOption("X Position", p.particles.particlePositionX));
                    this.options.add(new VariableOption("Y Position", p.particles.particlePositionY));
                    this.options.add(new VariableOption("Z Position", p.particles.particlePositionZ));
                    break;
                }
                case VELOCITY: {
                    this.options.add(new VariableOption("X Velocity", p.particles.particleVelocityX));
                    this.options.add(new VariableOption("Y Velocity", p.particles.particleVelocityY));
                    this.options.add(new VariableOption("Z Velocity", p.particles.particleVelocityZ));
                    break;
                }
                case COLOR: {
                    int color = p.particles.particleColor;
                    int r = ReikaColorAPI.getRed((int)color);
                    int g = ReikaColorAPI.getGreen((int)color);
                    int b = ReikaColorAPI.getBlue((int)color);
                    if (RGB) {
                        this.options.add(new SliderOption("Red", new BoundedValue((Number)0, (Number)255, (Number)r)));
                        this.options.add(new SliderOption("Green", new BoundedValue((Number)0, (Number)255, (Number)g)));
                        this.options.add(new SliderOption("Blue", new BoundedValue((Number)0, (Number)255, (Number)b)));
                    } else {
                        float[] hsv = Color.RGBtoHSB(r, g, b, null);
                        int hue = (int)(hsv[0] * 360.0f);
                        float sat = hsv[1];
                        float lum = hsv[2];
                        this.options.add(new SliderOption("Hue", new BoundedValue((Number)0, (Number)360, (Number)hue)));
                        this.options.add(new SliderOption("Saturation", new BoundedValue((Number)Float.valueOf(0.0f), (Number)1, (Number)Float.valueOf(sat)).setStep((Number)Float.valueOf(0.03125f))));
                        this.options.add(new SliderOption("Luminosity", new BoundedValue((Number)Float.valueOf(0.0f), (Number)1, (Number)Float.valueOf(lum)).setStep((Number)Float.valueOf(0.03125f))));
                    }
                    this.options.add(new ToggleOption("Cycling Color", p.particles.cyclingColor));
                    break;
                }
                case ICON: {
                    break;
                }
                case TIMING: {
                    this.options.add(new VariableOption("Lifetime", p.particles.particleLife));
                    this.options.add(new SliderOption("Rate", p.particles.particleRate));
                    this.options.add(new ToggleOption("Alpha Fade", p.particles.alphaFade));
                    break;
                }
                case MODIFIER: {
                    this.options.add(new VariableOption("Gravity", p.particles.particleGravity));
                    this.options.add(new VariableOption("Size", p.particles.particleSize));
                    this.options.add(new ToggleOption("Collision", p.particles.particleCollision));
                    this.options.add(new ToggleOption("Fast Expand", p.particles.rapidExpand));
                    this.options.add(new ToggleOption("No Slowdown", p.particles.noSlowdown));
                    break;
                }
            }
        }

        static {
            list = GuiPage.values();
        }
    }
}

