/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile.Inventory;

import Reika.ChromatiCraft.Base.GuiLetterSearchable;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Container.ContainerAutoEnchanter;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityAutoEnchanter;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class GuiAutoEnchanter
extends GuiLetterSearchable<Enchantment> {
    private final TileEntityAutoEnchanter ench;
    private static final ArrayList<Enchantment> validEnchants = new ArrayList();

    public GuiAutoEnchanter(EntityPlayer ep, TileEntityAutoEnchanter tile) {
        super((Container)new ContainerAutoEnchanter(ep, tile), ep, tile);
        this.player = ep;
        this.ench = tile;
        this.field_147000_g = 181;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int dx = 122;
        int dy = 33;
        int w = 4;
        this.field_146292_n.add(new CustomSoundGuiButton(0, j + dx - w, k + dy - 13, 20, 20, "-", (CustomSoundGuiButton.CustomSoundGui)this));
        if (this.ench.isCompatible((Enchantment)this.getActive()) == TileEntityAutoEnchanter.EnchantValidity.VALID) {
            this.field_146292_n.add(new CustomSoundGuiButton(1, j + dx + 20 + w, k + dy - 13, 20, 20, "+", (CustomSoundGuiButton.CustomSoundGui)this));
        } else {
            this.field_146292_n.add(new CustomSoundGuiButton(1, j + dx + 20 + w, k + dy - 13, 20, 20, "x", (CustomSoundGuiButton.CustomSoundGui)this).disable());
        }
        this.field_146292_n.add(new CustomSoundGuiButton(10, j + dx - w, k + dy + 20 + 5 - 13, 48, 20, "Reset", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + 16, k + 72, 7, 14, 200, 200, this.getFullTexturePath(), ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + 154, k + 72, 7, 14, 200, 200, this.getFullTexturePath(), ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
    }

    protected void func_146284_a(GuiButton b) {
        switch (b.field_146127_k) {
            case 0: {
                ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.ENCHANTER.ordinal(), (TileEntity)this.ench, (int[])new int[]{this.getID(), 0, GuiScreen.func_146272_n() ? 1 : 0});
                break;
            }
            case 1: {
                ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.ENCHANTER.ordinal(), (TileEntity)this.ench, (int[])new int[]{this.getID(), 1, GuiScreen.func_146272_n() ? 1 : 0});
                break;
            }
            case 10: {
                ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.ENCHANTERRESET.ordinal(), (TileEntity)this.ench, (int[])new int[0]);
                this.index = 0;
                break;
            }
            case 2: {
                this.decrementEnchant(GuiScreen.func_146272_n(), GuiScreen.func_146271_m());
                break;
            }
            case 3: {
                this.incrementEnchant(GuiScreen.func_146272_n(), GuiScreen.func_146271_m());
            }
        }
        this.func_73866_w_();
    }

    private void incrementEnchant(boolean newType, boolean skipInvalid) {
        Enchantment pre = (Enchantment)this.getActive();
        if (this.index < this.list.size() - 1) {
            do {
                ++this.index;
            } while (this.index < this.list.size() - 1 && (newType && ((Enchantment)this.getActive()).field_77351_y != pre.field_77351_y || skipInvalid && !this.isValidForItem((Enchantment)this.getActive())));
        }
    }

    private boolean isValidForItem(Enchantment e) {
        ItemStack is = this.ench.func_70301_a(0);
        return is == null || this.ench.isEnchantValid(e, is, is.func_77973_b(), false);
    }

    private void decrementEnchant(boolean newType, boolean skipInvalid) {
        Enchantment pre = (Enchantment)this.getActive();
        if (this.index > 0) {
            do {
                --this.index;
            } while (this.index > 0 && (newType && ((Enchantment)this.getActive()).field_77351_y != pre.field_77351_y || skipInvalid && !this.isValidForItem((Enchantment)this.getActive())));
        }
    }

    private String getEnchantDisplayString() {
        Enchantment e = (Enchantment)this.getActive();
        int level = this.ench.getEnchantment(e);
        return level > 0 ? e.func_77316_c(level) : StatCollector.func_74838_a((String)e.func_77320_a()) + " 0";
    }

    private int getID() {
        return ((Enchantment)this.getActive()).field_77352_x;
    }

    @Override
    protected int getTitlePosition() {
        return 4;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glDisable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        int level = this.ench.getLevel();
        if (level > 0) {
            Fluid f = FluidRegistry.getFluid((String)"chroma");
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int h = 54 * level / this.ench.getCapacity();
            this.func_94065_a(35, 68 - h, ico, 16, h);
        }
        int amt = this.ench.getConsumedChroma();
        String sg = String.valueOf((float)amt / 1000.0f);
        this.field_146289_q.func_78276_b("Cost:", 32 - this.field_146289_q.func_78256_a("Cost:"), 28, 0xFFFFFF);
        this.field_146289_q.func_78276_b(sg, 32 - this.field_146289_q.func_78256_a(sg), 38, amt > this.ench.getCapacity() ? 0xFF0000 : (amt > this.ench.getChromaLevel() ? 0xFFFF00 : 65280));
        String display = this.getEnchantDisplayString();
        TileEntityAutoEnchanter.EnchantValidity e = this.ench.isCompatible((Enchantment)this.getActive());
        if (e != TileEntityAutoEnchanter.EnchantValidity.VALID && api.isMouseInBox(this.field_146999_f / 2 - 65 + j, this.field_146999_f / 2 + 65 + j, 70 + k, 85 + k)) {
            api.drawTooltipAt(this.field_146289_q, e.desc, par1, par2);
        }
        api.func_73732_a(this.field_146289_q, display, this.field_146999_f / 2, 75, e.getTextColor());
        float w = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)5.0f);
        if (amt > this.ench.getCapacity()) {
            api.drawLine(35.0, 14.0, 51.0, 68.0, -65536);
            api.drawLine(35.0, 68.0, 51.0, 14.0, -65536);
        } else {
            int a = 54 * amt / this.ench.getCapacity();
            api.drawLine(35.0, (double)(68 - a), 51.0, (double)(68 - a), -9408400);
        }
        GL11.glLineWidth((float)w);
        GL11.glEnable((int)3042);
    }

    @Override
    protected void func_146976_a(float f, int a, int b) {
        super.func_146976_a(f, a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int h = this.ench.getProgressScaled(46);
        this.func_73729_b(j + 66, k + 21, 179, 3, h, 44);
    }

    @Override
    public String getGuiTexture() {
        return "enchanter2";
    }

    @Override
    protected String getString(Enchantment val) {
        return val.func_77316_c(1);
    }

    @Override
    protected boolean isIndexable(Enchantment val) {
        return true;
    }

    @Override
    protected Collection<Enchantment> getAllEntries(EntityPlayer ep) {
        ArrayList<Enchantment> c = new ArrayList<Enchantment>();
        for (Enchantment e : validEnchants) {
            if (TileEntityAutoEnchanter.getAvailableEnchantmentLevel(e, ep) <= 0) continue;
            c.add(e);
        }
        return c;
    }

    @Override
    protected void sortEntries(ArrayList<Enchantment> li) {
        Collections.sort(li, ReikaEnchantmentHelper.enchantmentNameSorter);
    }

    static {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            Enchantment e = Enchantment.field_77331_b[i];
            if (e == null || TileEntityAutoEnchanter.isBlacklisted(e)) continue;
            validEnchants.add(e);
        }
        Collections.sort(validEnchants, ReikaEnchantmentHelper.enchantmentNameSorter);
    }
}

