/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile.Inventory;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.Container.ContainerCastingTable;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiCastingTable
extends GuiChromaBase {
    private final TileEntityCastingTable tile;

    public GuiCastingTable(EntityPlayer ep, TileEntityCastingTable te) {
        super((Container)new ContainerCastingTable(ep, (TileEntity)te), ep, te);
        this.tile = te;
        this.field_147000_g = this.isMultiForm() ? 240 : 209;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int a = (this.field_146294_l - this.field_146999_f) / 2;
        int b = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glPushAttrib((int)1048575);
        if (this.isMultiForm()) {
            HashMap<List<Integer>, TileEntityItemStand> li = this.tile.getOtherStands();
            for (List<Integer> key : li.keySet()) {
                int sx;
                TileEntityItemStand te = li.get(key);
                ItemStack is = te.func_70301_a(0);
                if (is == null) continue;
                int i = key.get(0);
                int k = key.get(1);
                int n = i == 0 ? 0 : (sx = i < 0 ? -1 : 1);
                int sy = k == 0 ? 0 : (k < 0 ? -1 : 1);
                int tx = Math.abs(i) == 2 ? 38 : 64;
                int ty = Math.abs(k) == 2 ? 38 : 63;
                int dx = 80 + sx * tx;
                int dy = 75 + sy * ty;
                api.drawItemStack(field_146296_j, is, dx, dy);
                int x1 = a + dx - 1;
                int x2 = a + dx + 17;
                int y1 = b + dy - 1;
                int n2 = b + dy + 17;
            }
        }
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTerrainTexture();
        CastingRecipe.RecipeType tier = this.tile.getTier();
        int d = 10;
        int[] color = new int[]{0xFFFFFF, 0xFFFF99, 0xFFFF55, 0xFFDD00};
        boolean[] struct = new boolean[]{true, this.tile.hasStructure, this.tile.hasStructure2, this.tile.hasPylonConnections};
        for (int i = 0; i <= tier.ordinal(); ++i) {
            int x = i * d;
            int y = 0;
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            float red = (float)ReikaColorAPI.getRed((int)color[i]) / 255.0f;
            float green = (float)ReikaColorAPI.getGreen((int)color[i]) / 255.0f;
            float blue = (float)ReikaColorAPI.getBlue((int)color[i]) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            this.func_94065_a(x, y, ChromaIcons.DIAMOND.getIcon(), 16, 16);
            if (struct[i]) continue;
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_94065_a(x + 2, y + 2, ChromaIcons.NOENTER.getIcon(), 12, 12);
        }
        GL11.glDisable((int)3042);
        CastingRecipe r = this.tile.getActiveRecipe();
        if (r != null) {
            IIcon ico;
            ChromaResearch res = r.getFragment();
            if (res != null && !ChromaResearchManager.instance.playerHasFragment(this.player, res)) {
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glEnable((int)3042);
                ico = ChromaIcons.QUESTION.getIcon();
                this.func_94065_a(189, 12, ico, 16, 16);
                GL11.glDisable((int)3042);
            } else {
                ItemStack ctr = this.tile.func_70301_a(4);
                ItemStack out = r.getOutputForDisplay(ctr);
                if (ctr != null && out.field_77990_d != null) {
                    ReikaNBTHelper.combineNBT((NBTTagCompound)out.field_77990_d, (NBTTagCompound)r.getOutputTag(this.player, ctr.field_77990_d));
                }
                api.drawItemStack(field_146296_j, out, 189, 12);
                if (api.isMouseInBox(a + 186, a + 207, b + 10, b + 30)) {
                    int mx = api.getMouseRealX();
                    int my = api.getMouseRealY();
                    api.drawTooltipAt(this.field_146289_q, out.func_82833_r(), mx - 30, my);
                }
            }
            this.field_73735_i = 100.0f;
            if (!r.canRunRecipe((TileEntity)this.tile, this.player)) {
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glEnable((int)3042);
                ico = ChromaIcons.NOENTER.getIcon();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                this.func_94065_a(189, 12, ico, 16, 16);
                GL11.glDisable((int)3042);
            }
            this.field_73735_i = 0.0f;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3042);
            Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
            Tessellator.field_78398_a.func_78380_c(240);
            if (r instanceof CastingRecipe.PylonCastingRecipe) {
                CastingRecipe.PylonCastingRecipe p = (CastingRecipe.PylonCastingRecipe)r;
                ElementTagCompound tag = p.getRequiredAura();
                for (CrystalElement e : tag.elementSet()) {
                    int energy = this.tile.getEnergy(e);
                    int w = 4;
                    int x = 183 + e.ordinal() % 4 * w * 2;
                    int h = 35;
                    int y1 = 35 + e.ordinal() / 4 * 40;
                    ChromaFX.drawFillBar(e, x, y1, w, h, (float)energy / (float)tag.getValue(e));
                }
            }
        }
        GL11.glPopAttrib();
    }

    @Override
    protected void func_146976_a(float f, int a, int b) {
        super.func_146976_a(f, a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawFromBackground(j + this.field_146999_f, k, 176, 0, 43, this.field_147000_g);
    }

    @Override
    protected int getTitlePosition() {
        return this.isMultiForm() ? 3 : super.getTitlePosition();
    }

    @Override
    protected boolean labelInventory() {
        return !this.isMultiForm();
    }

    private boolean isMultiForm() {
        return this.tile.isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK);
    }

    @Override
    public String getGuiTexture() {
        return this.tile.isAtLeast(CastingRecipe.RecipeType.PYLON) ? "table5" : (this.isMultiForm() ? "table4" : "table2");
    }
}

