/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile.Inventory;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Container.ContainerTelePump;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.Acquisition.TileEntityTeleportationPump;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class GuiTelePump
extends GuiChromaBase {
    private TileEntityTeleportationPump pump;
    private int dy;
    private ArrayList<Fluid> list = new ArrayList();
    private int active = 0;

    public GuiTelePump(EntityPlayer ep, TileEntityTeleportationPump tile) {
        super((Container)new ContainerTelePump(ep, tile), ep, tile);
        this.player = ep;
        this.pump = tile;
        this.list.addAll(tile.getFluids());
        Collections.sort(this.list, new FluidListSorter(tile));
        this.field_146999_f = 194;
        this.field_147000_g = 168;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        String tex = this.getFullTexturePath();
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1000, j + 7, k + 15, 140, 8, 7, 15, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1001, j + 7, k + 63, 140, 8, 7, 63, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j + 9, k + 31, 136, 24, 0, 168, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 1000) {
            if (this.active > 0) {
                this.scrollUp();
            }
        } else if (b.field_146127_k == 1001) {
            if (this.active < this.list.size() - 1) {
                this.scrollDown();
            }
        } else if (!this.list.isEmpty()) {
            Fluid sel = this.list.get(this.active);
            if (TileEntityTeleportationPump.isFluidDiscovered(sel, this.player)) {
                ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.TELEPUMP.ordinal(), (TileEntity)this.pump, (int[])new int[]{sel.getID()});
                this.player.func_71053_j();
            } else {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)this.player, (float)1.0f, (float)1.0f);
            }
        }
        this.func_73866_w_();
    }

    private void scrollDown() {
        this.dy = 1;
        this.field_146292_n.clear();
    }

    private void scrollUp() {
        this.dy = -1;
        this.field_146292_n.clear();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        String s = this.getFullTexturePath();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)s);
        if (this.active < this.list.size() - 1) {
            this.func_73729_b(9, 55, 0, 168, 136, 6);
        }
        if (this.active > 0) {
            this.func_73729_b(9, 25, 0, 186, 136, 6);
        }
        int h = this.pump.getLiquidScaled(16);
        Fluid f = this.pump.getTankFluid();
        if (f != null) {
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_94065_a(152, 32 - h, ico, 16, h);
        }
        int min = Math.max(0, this.active - 1);
        int max = Math.min(this.list.size() - 1, this.active + 1);
        for (int i = min; i <= max; ++i) {
            f = this.list.get(i);
            boolean disc = TileEntityTeleportationPump.isFluidDiscovered(f, this.player);
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            if (!disc) {
                ico = ChromaIcons.QUESTION.getIcon();
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int dy = 24 * (i - this.active);
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            this.func_94065_a(13, 35 + dy, ico, 16, 16);
            if (i != this.active) continue;
            double ct = disc ? (double)this.pump.getFluidCount(f) / 1000.0 : 0.0;
            String sg = String.format("%s (%.3f%sB)", f.getLocalizedName(), ReikaMathLibrary.getThousandBase((double)ct), ReikaEngLibrary.getSIPrefix((double)ct));
            if (!disc) {
                sg = "[Unknown] (" + ReikaStringParser.padToLength((String)String.valueOf(ReikaRandomHelper.getRandomBetween((int)0, (int)99999)), (int)5, (String)" ") + " B)";
            }
            this.field_146289_q.func_78261_a(sg, 36, 39 + dy, 0xFFFFFF);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)s);
        this.func_73729_b(7, 10, 7, 10, 140, 15);
        this.func_73729_b(7, 61, 7, 61, 140, 15);
        super.func_146979_b(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int a, int b) {
        super.func_146976_a(f, a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.dy > 0) {
            ++this.dy;
        } else if (this.dy < 0) {
            --this.dy;
        }
        if (Math.abs(this.dy) >= 24) {
            this.active = (int)((float)this.active + Math.signum(this.dy));
            this.dy = 0;
            this.func_73866_w_();
        }
    }

    @Override
    public String getGuiTexture() {
        return "telepump3";
    }

    private static class FluidListSorter
    implements Comparator<Fluid> {
        private final TileEntityTeleportationPump tile;

        private FluidListSorter(TileEntityTeleportationPump te) {
            this.tile = te;
        }

        @Override
        public int compare(Fluid o1, Fluid o2) {
            return -1000000 * Integer.compare(this.tile.getFluidCount(o1), this.tile.getFluidCount(o2)) + ReikaFluidHelper.fluidComparator.compare(o1, o2);
        }
    }
}

