/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items;

import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Plants.TileEntityCrystalPlant;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCrystalSeeds
extends ItemCrystalBasic {
    public ItemCrystalSeeds(int tex) {
        super(tex);
    }

    @Override
    public int getNumberTypes() {
        return ChromaItems.getEntryByID(this).getNumberMetadatas();
    }

    @Override
    protected boolean isMetaInCreative(int meta) {
        if ((meta &= 0xFFFFFFF0) == 0) {
            return true;
        }
        return ReikaMathLibrary.isPowerOfTwo((long)meta) && (DragonAPICore.isReikasComputer() || TileEntityCrystalPlant.Modifier.getFromFlag(meta).showsInCreative());
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return super.getItemSpriteIndex(item) - item.func_77960_j() + item.func_77960_j() % 16;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        Block idbelow = world.func_147439_a(x, y - 1, z);
        if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z) || !ReikaPlantHelper.SAPLING.canPlantAt(world, x, y, z)) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, 0, item)) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --item.field_77994_a;
        }
        world.func_147465_d(x, y, z, ChromaBlocks.PLANT.getBlockInstance(), item.func_77960_j() % 16, 3);
        TileEntityCrystalPlant te = (TileEntityCrystalPlant)world.func_147438_o(x, y, z);
        te.setStates(item);
        ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150349_c);
        return true;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        for (int i = 0; i < TileEntityCrystalPlant.Modifier.list.length; ++i) {
            TileEntityCrystalPlant.Modifier m = TileEntityCrystalPlant.Modifier.list[i];
            if (!m.present(is.func_77960_j())) continue;
            li.add(m.displayName);
        }
        if (is.field_77990_d != null && is.field_77990_d.func_74767_n("sterile")) {
            li.add("Will plant a sterile plant, for decoration only");
        }
    }

    public static Collection<ItemStack> getAllVariants(CrystalElement e) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(ChromaItems.SEED.getStackOfMetadata(e.ordinal()));
        for (TileEntityCrystalPlant.Modifier m : TileEntityCrystalPlant.Modifier.list) {
            ret.add(ChromaItems.SEED.getStackOfMetadata(e.ordinal() | m.flag));
        }
        return ret;
    }
}

