/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.Items.Tools.ItemPendant;
import Reika.ChromatiCraft.Magic.Interfaces.PoweredItem;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class ItemBoostedPendant
extends ItemPendant
implements PoweredItem {
    private static final int MAX_CHARGE = 4320000;

    public ItemBoostedPendant(int tex) {
        super(tex);
        this.field_77787_bX = true;
        this.field_77777_bU = 1;
        this.setNoRepair();
    }

    @Override
    protected boolean isEnhanced(ItemStack is) {
        return !ChromaOptions.POWEREDPENDANTS.getState() || ToolChargingSystem.instance.getCharge(is) > 0;
    }

    @Override
    protected void onTick(ItemStack is, World world, EntityPlayer ep, int slot) {
        if (ChromaOptions.POWEREDPENDANTS.getState()) {
            ToolChargingSystem.instance.tryChargeFromPlayer(is, ep);
            ToolChargingSystem.instance.removeCharge(is, this.getChargeConsumptionRate(ep, world, is), ep);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (ChromaOptions.POWEREDPENDANTS.getState()) {
            li.add(String.format("Energy: %.2f%s", Float.valueOf(100.0f * (float)ToolChargingSystem.instance.getCharge(is) / (float)this.getMaxCharge()), "%"));
        }
    }

    public final boolean onEntityItemUpdate(EntityItem ei) {
        return ChromaOptions.POWEREDPENDANTS.getState() ? ToolChargingSystem.instance.tickItem(ei) : super.onEntityItemUpdate(ei);
    }

    public final int getEntityLifespan(ItemStack is, World world) {
        return ChromaOptions.POWEREDPENDANTS.getState() ? Integer.MAX_VALUE : super.getEntityLifespan(is, world);
    }

    public final boolean hasCustomEntity(ItemStack stack) {
        return ChromaOptions.POWEREDPENDANTS.getState();
    }

    public final Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return ChromaOptions.POWEREDPENDANTS.getState() ? new ToolChargingSystem.EntityChargingTool(world, (EntityItem)location, itemstack) : super.createEntity(world, location, itemstack);
    }

    @Override
    public int getMaxCharge() {
        return 4320000;
    }

    @Override
    public boolean hasChargeStates() {
        return false;
    }

    @Override
    public int getChargeStates() {
        return 0;
    }

    @Override
    public int getChargeState(float frac) {
        return 0;
    }

    @Override
    public int getChargeConsumptionRate(EntityPlayer e, World world, ItemStack is) {
        return 1;
    }

    @Override
    public int getChargeRate(ItemStack is, int base) {
        return base * 3 / 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doChargeFX(EntityItem ei, int charge) {
        ItemPoweredChromaTool.doStandardChargeFX(ei, charge);
    }

    @Override
    public CrystalElement getColor(ItemStack is) {
        return CrystalElement.elements[is.func_77960_j()];
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean onRender(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        if (is.field_77990_d != null && is.field_77990_d.func_74767_n("tooltip")) {
            return false;
        }
        ToolChargingSystem.instance.renderItemAux(ri, is, type);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean doPreGLTransforms(ItemStack is, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public float getPlayerChargeCoefficient(ItemStack is) {
        return 3.6f;
    }

    @Override
    public int getPlayerBufferExtractionRate(ItemStack is) {
        return 1;
    }

    @Override
    public String getNotes(int subpage) {
        return ChromaOptions.POWEREDPENDANTS.getState() ? "Enhanced pendants require charging with the corresponding crystal element" : "";
    }

    @Override
    public int getMaxSubpage() {
        return 1;
    }

    @Override
    public boolean replaceOriginal() {
        return false;
    }
}

