/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBottleneckFinder
extends ItemChromaTool {
    public ItemBottleneckFinder(int index) {
        super(index);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float af, float bf, float cf) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof CrystalReceiver) {
            boolean flag = false;
            CrystalReceiver r = (CrystalReceiver)te;
            for (CrystalElement e : CrystalElement.elements) {
                CrystalPath p;
                if (!r.isConductingElement(e) || (p = CrystalNetworker.instance.getConnectivity(e, r)) == null) continue;
                flag = true;
                p.blink(200, r);
                TreeMap<Integer, ArrayList<WorldLocation>> throughputLimits = new TreeMap<Integer, ArrayList<WorldLocation>>();
                TreeMap lossLevels = new TreeMap();
                for (CrystalNetworkTile cr : p.getTileList()) {
                    int loss;
                    int thru = cr.maxThroughput();
                    WorldLocation loc = new WorldLocation(cr.getWorld(), cr.getX(), cr.getY(), cr.getZ());
                    Collection<WorldLocation> c = (ArrayList<WorldLocation>)throughputLimits.get(thru);
                    if (c == null) {
                        c = new ArrayList<WorldLocation>();
                        throughputLimits.put(thru, (ArrayList<WorldLocation>)c);
                    }
                    c.add(loc);
                    if (!(cr instanceof CrystalRepeater) || (loss = ((CrystalRepeater)cr).getSignalDegradation(TileEntityAuraPoint.isPointWithin(world, x, y, z, 512))) <= 0) continue;
                    c = (Collection)lossLevels.get(loss);
                    if (c == null) {
                        c = new ArrayList();
                        lossLevels.put(loss, c);
                    }
                    c.add(loc);
                }
                HashSet<WorldLocation> sentLoss = new HashSet<WorldLocation>();
                HashSet<WorldLocation> sentThrough = new HashSet<WorldLocation>();
                for (int i = 0; i < WarningLevels.list.length; ++i) {
                    Collection worstLoss;
                    WarningLevels w = WarningLevels.list[i];
                    Collection worstThrough = throughputLimits.isEmpty() ? null : (Collection)throughputLimits.remove(throughputLimits.firstKey());
                    Collection collection = worstLoss = lossLevels.isEmpty() ? null : (Collection)lossLevels.remove(lossLevels.lastKey());
                    if (worstThrough != null) {
                        for (WorldLocation loc : worstThrough) {
                            if (sentThrough.contains(loc)) continue;
                            ItemBottleneckFinder.triggerWarning((EntityPlayerMP)ep, loc, e, w, true);
                            sentThrough.add(loc);
                        }
                    }
                    if (worstLoss == null) continue;
                    for (WorldLocation loc : worstLoss) {
                        if (sentLoss.contains(loc)) continue;
                        ItemBottleneckFinder.triggerWarning((EntityPlayerMP)ep, loc, e, w, false);
                        sentLoss.add(loc);
                    }
                }
            }
            if (flag) {
                ReikaMusicHelper.MusicKey[] mk = new ReikaMusicHelper.MusicKey[]{ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.G5, ReikaMusicHelper.MusicKey.C6};
                for (int i = 0; i < 5; ++i) {
                    float f = (float)mk[i].getRatio(ReikaMusicHelper.MusicKey.C5);
                    ScheduledTickEvent.ScheduledSoundEvent evt = new ScheduledTickEvent.ScheduledSoundEvent((SoundEnum)ChromaSounds.REPEATERRING, (Entity)ep, 1.0f, f);
                    evt.attenuate = false;
                    TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)evt), 1 + i * 13);
                }
            } else {
                ChromaSounds.ERROR.playSoundAtBlock(te);
            }
            return true;
        }
        return false;
    }

    private static void triggerWarning(EntityPlayerMP ep, WorldLocation loc, CrystalElement e, WarningLevels w, boolean isThroughput) {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.BOTTLENECK.ordinal(), (PacketTarget)new PacketTarget.PlayerTarget(ep), (int[])new int[]{loc.dimensionID, loc.xCoord, loc.yCoord, loc.zCoord, w.ordinal(), isThroughput ? 1 : 0, e.ordinal()});
    }

    public static enum WarningLevels {
        FIRST,
        SECOND,
        THIRD;

        public static final WarningLevels[] list;

        public IIcon getIcon() {
            return ChromaIcons.BLACKHOLE.getIcon();
        }

        static {
            list = WarningLevels.values();
        }
    }
}

