/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBulkMover
extends ItemChromaTool {
    public ItemBulkMover(int index) {
        super(index);
    }

    public static int getStoredItems(ItemStack tool) {
        return tool.field_77990_d != null ? tool.field_77990_d.func_74762_e("count") : 0;
    }

    public static ItemStack getStoredItem(ItemStack tool) {
        return tool.field_77990_d != null ? ItemStack.func_77949_a((NBTTagCompound)tool.field_77990_d.func_74775_l("item")) : null;
    }

    public static void setStoredItem(ItemStack tool, ItemStack store) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (store != null) {
            store.func_77955_b(tag);
        }
        tool.field_77990_d.func_74782_a("item", (NBTBase)tag);
    }

    public static int getNumberToCarry(ItemStack tool) {
        return tool.field_77990_d != null ? tool.field_77990_d.func_74762_e("space") : 0;
    }

    public static void setNumberToCarry(ItemStack tool, int amt) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        tool.field_77990_d.func_74768_a("space", amt);
    }

    private static boolean hasItems(ItemStack tool) {
        return ItemBulkMover.getStoredItems(tool) > 0;
    }

    private static void removeItems(ItemStack tool, int rem) {
        int has = tool.field_77990_d.func_74762_e("count");
        tool.field_77990_d.func_74768_a("count", has - rem);
    }

    private static void addItems(ItemStack tool, int add) {
        int has = tool.field_77990_d.func_74762_e("count");
        tool.field_77990_d.func_74768_a("count", has + add);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (!ItemBulkMover.hasItems(is)) {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.BULKMOVER.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        InventoryInteraction ii;
        if (world.field_72995_K) {
            return true;
        }
        if (ItemBulkMover.getStoredItem(is) != null && ItemBulkMover.getNumberToCarry(is) > 0 && (ii = this.getInteraction(world, x, y, z, s, ep)) != null) {
            if (ItemBulkMover.hasItems(is)) {
                int added = ii.addItems(ItemBulkMover.getStoredItem(is), ItemBulkMover.getStoredItems(is));
                ItemBulkMover.removeItems(is, added);
            } else {
                int rem = ii.drawItems(ItemBulkMover.getStoredItem(is), ItemBulkMover.getNumberToCarry(is));
                ItemBulkMover.addItems(is, rem);
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        int amt = ItemBulkMover.getStoredItems(is);
        ItemStack has = ItemBulkMover.getStoredItem(is);
        if (has != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = amt;
            objectArray[1] = has.func_82833_r();
            objectArray[2] = ItemBulkMover.getNumberToCarry(is);
            String s = String.format("Has %d of %s; set to move up to %d", objectArray);
            li.add(s);
        } else {
            li.add("No stored items.");
        }
    }

    private InventoryInteraction getInteraction(World world, int x, int y, int z, int side, EntityPlayer ep) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (InterfaceCache.GRIDHOST.instanceOf((Object)te)) {
            return new AEInteraction(((IGridHost)te).getGridNode(ForgeDirection.VALID_DIRECTIONS[side]), ep);
        }
        if (te instanceof IInventory) {
            return new IInvInteraction((IInventory)te);
        }
        return null;
    }

    private static interface InventoryInteraction {
        public int addItems(ItemStack var1, int var2);

        public int drawItems(ItemStack var1, int var2);
    }

    private static class IInvInteraction
    implements InventoryInteraction {
        private final IInventory inventory;

        private IInvInteraction(IInventory ii) {
            this.inventory = ii;
        }

        @Override
        public int addItems(ItemStack is, int max) {
            return max - ReikaInventoryHelper.addToInventoryWithLeftover((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)max), (IInventory)this.inventory, (boolean)false);
        }

        @Override
        public int drawItems(ItemStack is, int max) {
            return ReikaInventoryHelper.drawFromInventory((ItemStack)is, (int)max, (IInventory)this.inventory);
        }
    }

    private static class AEInteraction
    implements InventoryInteraction {
        private final MESystemReader me;

        private AEInteraction(IGridNode ign, EntityPlayer ep) {
            this.me = new MESystemReader(ign, ep);
        }

        @Override
        public int addItems(ItemStack is, int max) {
            return (int)((long)max - this.me.addItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)max), false));
        }

        @Override
        public int drawItems(ItemStack is, int max) {
            return (int)this.me.removeItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)max), false, true);
        }
    }
}

