/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Block.BlockChromaTrail;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCaveExitFinder
extends ItemChromaTool {
    private static final AbstractSearch.TerminationCondition skyFinder = new AbstractSearch.TerminationCondition(){

        public boolean isValidTerminus(World world, int x, int y, int z) {
            return world.func_72937_j(x, y, z);
        }
    };
    private static final AbstractSearch.PropagationCondition pathFinder = new AbstractSearch.PropagationCondition(){

        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            Block b = world.func_147439_a(x, y, z);
            return b.isAir((IBlockAccess)world, x, y, z) || b == ChromaBlocks.HOVER.getBlockInstance() || b == Blocks.field_150466_ao || b == Blocks.field_150454_av || b == Blocks.field_150411_aY || b == ChromaBlocks.TRAIL.getBlockInstance() || ReikaBlockHelper.isLiquid((Block)b) || ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)x, (int)y, (int)z);
        }
    };

    public ItemCaveExitFinder(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (world.field_72995_K) {
            return is;
        }
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)ep.field_70163_u);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        boolean deep = ep.func_70093_af();
        if (!deep && skyFinder.isValidTerminus(world, x, y, z)) {
            return is;
        }
        BreadthFirstSearch s = new BreadthFirstSearch(x, y, z);
        AbstractSearch.PropagationCondition f = deep ? new DownwardsFinder(y) : pathFinder;
        AbstractSearch.TerminationCondition t = skyFinder;
        if (deep) {
            s.limit = new BlockBox(x, y, z, x, y, z).expand(400, 256, 400);
            BlockArray b = new BlockArray();
            b.recursiveAddCallbackWithBounds(world, x, y, z, s.limit.minX, 0, s.limit.minZ, s.limit.maxX, 256, s.limit.maxZ, f);
            t = new LowYFinder(b.getMinY());
        }
        while (!s.tick(world, f, t)) {
        }
        LinkedList li = s.getResult();
        if (!li.isEmpty()) {
            int n = 0;
            ArrayList<Object> li2 = new ArrayList<Object>();
            for (Coordinate c : li) {
                if (n % 4 == 0 && !c.equals(li.getLast())) {
                    li2.add(c);
                }
                ++n;
            }
            li2.add(li.getLast());
            for (int i = 0; i < li2.size(); ++i) {
                Coordinate prev;
                Coordinate c;
                c = (Coordinate)li2.get(i);
                Coordinate next = i < li2.size() - 1 ? (Coordinate)li2.get(i + 1) : null;
                Coordinate coordinate = prev = i > 0 ? (Coordinate)li2.get(i - 1) : null;
                if (!c.getBlock((IBlockAccess)world).isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
                c.setBlock(world, ChromaBlocks.TRAIL.getBlockInstance());
                BlockChromaTrail.TileChromaTrail te = (BlockChromaTrail.TileChromaTrail)c.getTileEntity((IBlockAccess)world);
                if (te == null) {
                    te = new BlockChromaTrail.TileChromaTrail();
                    te.field_145850_b = world;
                    te.field_145851_c = c.xCoord;
                    te.field_145848_d = c.yCoord;
                    te.field_145849_e = c.zCoord;
                    world.func_147455_a(c.xCoord, c.yCoord, c.zCoord, (TileEntity)te);
                }
                te.setData(prev, next);
            }
        }
        return is;
    }

    private static final class LowYFinder
    implements AbstractSearch.TerminationCondition {
        private final int endY;

        private LowYFinder(int y) {
            this.endY = y;
        }

        public boolean isValidTerminus(World world, int x, int y, int z) {
            return y == this.endY;
        }
    }

    private static final class DownwardsFinder
    implements AbstractSearch.PropagationCondition {
        private final int startY;

        private DownwardsFinder(int y) {
            this.startY = y;
        }

        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            return pathFinder.isValidLocation(world, x, y, z, from) && y <= this.startY;
        }
    }
}

