/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.GUI.Book.GuiNavigation;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class ItemChromaBook
extends ItemChromaTool {
    public ItemChromaBook(int index) {
        super(index);
    }

    public void func_150895_a(Item item, CreativeTabs cr, List li) {
        li.add(new ItemStack((Item)this));
        ItemStack is = new ItemStack((Item)this);
        is.field_77990_d = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ChromaResearch r : ChromaResearch.getAllObtainableFragments()) {
            list.func_74742_a((NBTBase)new NBTTagString(r.name()));
        }
        is.field_77990_d.func_74782_a("pages", (NBTBase)list);
        is.field_77990_d.func_74757_a("creative", true);
        li.add(is);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            if (!ItemChromaBook.isCreative(is)) {
                ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.BOOKPAGES.ordinal(), null, 0, 0, 0);
            }
        } else {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.resetGuis();
            }
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.BOOKNAV.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public static void clearNoteTexts(ItemStack is) {
        if (is.field_77990_d != null) {
            is.field_77990_d.func_82580_o("notes");
        }
    }

    public static void addNoteText(ItemStack is, String s) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        NBTTagList li = is.field_77990_d.func_150295_c("notes", ReikaNBTHelper.NBTTypes.STRING.ID);
        li.func_74742_a((NBTBase)new NBTTagString(s));
        is.field_77990_d.func_74782_a("notes", (NBTBase)li);
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (ItemChromaBook.isCreative(is)) {
            li.add("Creative Spawned");
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = ItemChromaBook.getNumberPages(is);
            objectArray[1] = ChromaResearch.getAllObtainableFragments().size();
            li.add(String.format("Has %d of %d pages.", objectArray));
            int blanks = ItemChromaBook.getBlanksStored(is);
            li.add(String.format("Has %d extra blank fragment%s.", blanks, blanks == 1 ? "" : "s"));
        }
    }

    public static boolean isCreative(ItemStack is) {
        return ChromaItems.HELP.matchWith(is) && is.field_77990_d != null && is.field_77990_d.func_74767_n("creative");
    }

    public static int getBlanksStored(ItemStack is) {
        return ChromaItems.HELP.matchWith(is) && is.field_77990_d != null ? is.field_77990_d.func_74762_e("blanks") : 0;
    }

    public static void addBlanks(ItemStack is, int amt) {
        if (ChromaItems.HELP.matchWith(is)) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            int get = is.field_77990_d.func_74762_e("blanks");
            is.field_77990_d.func_74768_a("blanks", get + amt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void resetGuis() {
        GuiNavigation.resetOffset();
    }

    public void setItems(ItemStack is, ArrayList<ChromaResearch> li) {
        if (is == null || is.func_77973_b() != this) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (ChromaResearch r : li) {
            if (r == null) continue;
            NBTTagString tag = new NBTTagString(r.name());
            list.func_74742_a((NBTBase)tag);
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74782_a("pages", (NBTBase)list);
    }

    public ArrayList<ChromaResearch> getItemList(ItemStack tool) {
        ArrayList<ChromaResearch> li = new ArrayList<ChromaResearch>();
        if (tool == null || tool.func_77973_b() != this) {
            return li;
        }
        if (tool.field_77990_d != null) {
            NBTTagList list = tool.field_77990_d.func_150295_c("pages", ReikaNBTHelper.NBTTypes.STRING.ID);
            Iterator it = list.field_74747_a.iterator();
            while (it.hasNext()) {
                NBTTagString tag = (NBTTagString)it.next();
                String s = tag.func_150285_a_();
                ChromaResearch r = ChromaResearch.getByName(s);
                if (r == null) {
                    ChromatiCraft.logger.logError((Object)("Null research item {" + s + "} in the book?!"));
                    it.remove();
                    continue;
                }
                int idx = ChromaResearch.getAllObtainableFragments().indexOf(r);
                if (idx < 0) {
                    it.remove();
                    throw new WTFException("How did you get a parent (OR NONEXISTENT) fragment '" + r + "' in the book!?!", true);
                }
                li.add(r);
            }
        }
        return li;
    }

    public static boolean hasPage(ItemStack is, ChromaResearch b) {
        if (ItemChromaBook.isCreative(is)) {
            return true;
        }
        if (b.isAlwaysPresent()) {
            return true;
        }
        if (b == ChromaResearch.PACKCHANGES) {
            return true;
        }
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b("pages")) {
            return false;
        }
        return is.field_77990_d.func_150295_c((String)"pages", (int)ReikaNBTHelper.NBTTypes.STRING.ID).field_74747_a.contains(new NBTTagString(b.name()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getItemSpriteIndex(ItemStack is) {
        int n;
        int base = super.getItemSpriteIndex(is);
        if (!ItemChromaBook.isCreative(is)) {
            if (!ItemChromaBook.hasAllPages(is)) {
                n = base;
                return n;
            }
        }
        n = base + 1;
        return n;
    }

    private static boolean hasAllPages(ItemStack is) {
        for (ChromaResearch r : ChromaResearch.getAllObtainableFragments()) {
            if (ItemChromaBook.hasPage(is, r)) continue;
            return false;
        }
        return true;
    }

    public static int getNumberPages(ItemStack is) {
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b("pages")) {
            return 0;
        }
        return is.field_77990_d.func_150295_c("pages", ReikaNBTHelper.NBTTypes.STRING.ID).func_74745_c();
    }

    public static void recoverFragment(EntityPlayer ep, ChromaResearch r, ItemStack book) {
        ReikaInventoryHelper.findAndDecrStack((Item)Items.field_151121_aF, (int)-1, (ItemStack[])ep.field_71071_by.field_70462_a);
        ReikaInventoryHelper.findAndDecrStack((ItemStack)ReikaItemHelper.inksac, (ItemStack[])ep.field_71071_by.field_70462_a);
        ItemChromaBook item = (ItemChromaBook)book.func_77973_b();
        ArrayList<ChromaResearch> li = item.getItemList(book);
        li.add(r);
        item.setItems(book, li);
    }

    public static int checkForInk(ItemStack[] inv) {
        for (int i = 0; i < inv.length; ++i) {
            ItemStack in = inv[i];
            if (in == null) continue;
            if (ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)ReikaItemHelper.inksac)) {
                return i;
            }
            if (!ReikaItemHelper.isInOreTag((ItemStack)in, (String)"dyeBlack")) continue;
            return i;
        }
        return -1;
    }
}

