/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.Interfaces.Linkable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LinkedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LinkerCallback;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Block.Dimension.Structure.NonEuclid.BlockTeleport;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityTransportWindow;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.CopyableSettings;
import Reika.DragonAPI.Interfaces.TileEntity.NBTCopyable;
import Reika.DragonAPI.Interfaces.TileEntity.SimpleConnection;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemConnector
extends ItemChromaTool {
    public ItemConnector(int index) {
        super(index);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        boolean flag;
        Linkage l;
        TileEntity tile;
        WorldLocation loc;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof NBTCopyable) {
            if (is.field_77990_d != null && is.field_77990_d.func_74764_b("NBT_transfer")) {
                ((NBTCopyable)te).readCopyableData(is.field_77990_d.func_74775_l("NBT_transfer"));
                is.field_77990_d = null;
            } else {
                if (is.field_77990_d == null) {
                    is.field_77990_d = new NBTTagCompound();
                }
                NBTTagCompound tag = new NBTTagCompound();
                ((NBTCopyable)te).writeCopyableData(tag);
                is.field_77990_d.func_74782_a("NBT_transfer", (NBTBase)tag);
            }
            return true;
        }
        if (te instanceof LinkerCallback) {
            is.field_77990_d = new NBTTagCompound();
            NBTTagCompound tag = new NBTTagCompound();
            new WorldLocation(te).writeToTag(tag);
            is.field_77990_d.func_74782_a("callback", (NBTBase)tag);
            return true;
        }
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && ep.field_71075_bZ.field_75098_d) {
            if (is.field_77990_d != null && is.field_77990_d.func_74767_n("noneuclid")) {
                int dx = is.field_77990_d.func_74762_e("x1");
                int dy = is.field_77990_d.func_74762_e("y1");
                int dz = is.field_77990_d.func_74762_e("z1");
                int face = is.field_77990_d.func_74762_e("facing");
                TileEntity tile2 = world.func_147438_o(dx, dy, dz);
                if (tile2 instanceof BlockTeleport.TileEntityTeleport) {
                    ((BlockTeleport.TileEntityTeleport)tile2).facing = ForgeDirection.VALID_DIRECTIONS[face].getOpposite();
                    ((BlockTeleport.TileEntityTeleport)tile2).destination = new BlockVector(x - dx, y + 1 - dy, z - dz, ForgeDirection.VALID_DIRECTIONS[s].getOpposite());
                    ReikaJavaLibrary.pConsole((Object)((BlockTeleport.TileEntityTeleport)tile2).destination);
                }
                is.field_77990_d = null;
                return true;
            }
            if (te instanceof BlockTeleport.TileEntityTeleport) {
                if (is.field_77990_d == null) {
                    is.field_77990_d = new NBTTagCompound();
                }
                is.field_77990_d.func_74768_a("x1", x);
                is.field_77990_d.func_74768_a("y1", y);
                is.field_77990_d.func_74768_a("z1", z);
                is.field_77990_d.func_74768_a("facing", s);
                is.field_77990_d.func_74757_a("noneuclid", true);
                ReikaJavaLibrary.pConsole((Object)is.field_77990_d);
                return true;
            }
        } else if (is.field_77990_d != null && is.field_77990_d.func_74764_b("callback") && (loc = WorldLocation.readTag((NBTTagCompound)is.field_77990_d.func_74775_l("callback"))) != null && (tile = loc.getTileEntity()) instanceof LinkerCallback) {
            ((LinkerCallback)tile).linkTo(world, x, y, z);
            is.field_77990_d = null;
            return true;
        }
        if ((l = Linkage.getLink(te)) == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Invalid tile.");
            is.field_77990_d = null;
            return false;
        }
        Linkage[] ls = this.getLinks(is);
        if (ls == null || ls[0] == null || ls[1] == null || ls[0] != ls[1]) {
            // empty if block
        }
        ChromaSounds sn = (flag = l.tryLink(is, ep, te)) ? ChromaSounds.USE : ChromaSounds.ERROR;
        sn.playSound((Entity)ep);
        return flag;
    }

    private Linkage[] getLinks(ItemStack is) {
        if (is.field_77990_d == null) {
            return null;
        }
        TileEntity te1 = null;
        TileEntity te2 = null;
        if (is.field_77990_d.func_74764_b("x1")) {
            int x1 = is.field_77990_d.func_74762_e("x1");
            int y1 = is.field_77990_d.func_74762_e("y1");
            int z1 = is.field_77990_d.func_74762_e("z1");
            int dim1 = is.field_77990_d.func_74762_e("w1");
            WorldServer w1 = DimensionManager.getWorld((int)dim1);
            if (w1 != null) {
                te1 = w1.func_147438_o(x1, y1, z1);
            }
        }
        if (is.field_77990_d.func_74764_b("x2")) {
            int x2 = is.field_77990_d.func_74762_e("x2");
            int y2 = is.field_77990_d.func_74762_e("y2");
            int z2 = is.field_77990_d.func_74762_e("z2");
            int dim2 = is.field_77990_d.func_74762_e("w2");
            WorldServer w2 = DimensionManager.getWorld((int)dim2);
            if (w2 != null) {
                te2 = w2.func_147438_o(x2, y2, z2);
            }
        }
        return new Linkage[]{Linkage.getLink(te1), Linkage.getLink(te2)};
    }

    private static boolean connectRift(LinkedTile te, World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("x1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("x2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("w1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("w2", Integer.MIN_VALUE);
        }
        if (is.field_77990_d.func_74762_e("x1") == Integer.MIN_VALUE) {
            is.field_77990_d.func_74768_a("x1", x);
            is.field_77990_d.func_74768_a("y1", y);
            is.field_77990_d.func_74768_a("z1", z);
            is.field_77990_d.func_74768_a("w1", world.field_73011_w.field_76574_g);
        } else {
            is.field_77990_d.func_74768_a("x2", x);
            is.field_77990_d.func_74768_a("y2", y);
            is.field_77990_d.func_74768_a("z2", z);
            is.field_77990_d.func_74768_a("w2", world.field_73011_w.field_76574_g);
        }
        int x1 = is.field_77990_d.func_74762_e("x1");
        int y1 = is.field_77990_d.func_74762_e("y1");
        int z1 = is.field_77990_d.func_74762_e("z1");
        int x2 = is.field_77990_d.func_74762_e("x2");
        int y2 = is.field_77990_d.func_74762_e("y2");
        int z2 = is.field_77990_d.func_74762_e("z2");
        int dim1 = is.field_77990_d.func_74762_e("w1");
        int dim2 = is.field_77990_d.func_74762_e("w2");
        WorldServer w1 = DimensionManager.getWorld((int)dim1);
        WorldServer w2 = DimensionManager.getWorld((int)dim2);
        if (x1 != Integer.MIN_VALUE && y1 != Integer.MIN_VALUE && z1 != Integer.MIN_VALUE && x1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE && z2 != Integer.MIN_VALUE) {
            TileEntity te1 = world.func_147438_o(x1, y1, z1);
            TileEntity te2 = world.func_147438_o(x2, y2, z2);
            if (!(te1 instanceof LinkedTile) || !(te2 instanceof LinkedTile)) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Link failed.");
                is.field_77990_d = null;
                return false;
            }
            LinkedTile rf1 = (LinkedTile)te1;
            LinkedTile rf2 = (LinkedTile)te2;
            if (rf1 == rf2) {
                ReikaChatHelper.writeString((String)"Cannot link a rift to itself!");
                is.field_77990_d = null;
                return false;
            }
            rf1.reset();
            rf2.reset();
            boolean flag = rf1.linkTo((World)w2, x2, y2, z2);
            if (flag) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Linked " + rf1 + " and " + rf2));
                rf1.setPrimary(true);
            } else {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Link failed.");
            }
            is.field_77990_d = null;
        }
        return false;
    }

    private static boolean connectWindow(TileEntityTransportWindow te, World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("x1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("x2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z2", Integer.MIN_VALUE);
        }
        if (is.field_77990_d.func_74762_e("x1") == Integer.MIN_VALUE) {
            is.field_77990_d.func_74768_a("x1", x);
            is.field_77990_d.func_74768_a("y1", y);
            is.field_77990_d.func_74768_a("z1", z);
        } else {
            is.field_77990_d.func_74768_a("x2", x);
            is.field_77990_d.func_74768_a("y2", y);
            is.field_77990_d.func_74768_a("z2", z);
        }
        int x1 = is.field_77990_d.func_74762_e("x1");
        int y1 = is.field_77990_d.func_74762_e("y1");
        int z1 = is.field_77990_d.func_74762_e("z1");
        int x2 = is.field_77990_d.func_74762_e("x2");
        int y2 = is.field_77990_d.func_74762_e("y2");
        int z2 = is.field_77990_d.func_74762_e("z2");
        if (x1 != Integer.MIN_VALUE && y1 != Integer.MIN_VALUE && z1 != Integer.MIN_VALUE && x1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE && z2 != Integer.MIN_VALUE) {
            TileEntityTransportWindow rf1 = (TileEntityTransportWindow)world.func_147438_o(x1, y1, z1);
            TileEntityTransportWindow rf2 = (TileEntityTransportWindow)world.func_147438_o(x2, y2, z2);
            if (rf1 == null) {
                ReikaChatHelper.writeString((String)("Tile missing at " + x1 + ", " + y1 + ", " + z1));
                is.field_77990_d = null;
                return false;
            }
            if (rf2 == null) {
                ReikaChatHelper.writeString((String)("Tile missing at " + x2 + ", " + y2 + ", " + z2));
                is.field_77990_d = null;
                return false;
            }
            if (rf1 == rf2) {
                ReikaChatHelper.writeString((String)"Cannot link a window to itself!");
                is.field_77990_d = null;
                return false;
            }
            if (rf1.canLinkTo(rf2)) {
                rf1.linkTo(rf2);
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Linked " + (Object)((Object)rf1) + " and " + (Object)((Object)rf2)));
            } else {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Cannot link windows; states/frames do not match.");
            }
            is.field_77990_d = null;
        }
        return false;
    }

    private static boolean trySimpleConnection(SimpleConnection te, World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            new WorldLocation((TileEntity)te).writeToNBT("end1", is.field_77990_d);
            return true;
        }
        WorldLocation c1 = WorldLocation.readFromNBT((String)"end1", (NBTTagCompound)is.field_77990_d);
        if (c1 == null) {
            ReikaChatHelper.writeString((String)"No valid other end found");
            return false;
        }
        return te.tryConnect(c1.getWorld(), c1.xCoord, c1.yCoord, c1.zCoord);
    }

    private static boolean tryConnection(Linkable te, World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            new WorldLocation((TileEntity)te).writeToNBT("end1", is.field_77990_d);
            return true;
        }
        WorldLocation c1 = WorldLocation.readFromNBT((String)"end1", (NBTTagCompound)is.field_77990_d);
        if (c1 == null) {
            ReikaChatHelper.writeString((String)"No valid other end found");
            return false;
        }
        TileEntity te0 = c1.getTileEntity((IBlockAccess)world);
        if (!(te0 instanceof Linkable)) {
            ReikaChatHelper.writeString((String)"Tile at other end is invalid");
            return false;
        }
        int dl = c1.getTaxicabDistanceTo(x, y, z) - 1;
        is.field_77990_d = null;
        Linkable bb = (Linkable)te0;
        bb.resetOther();
        te.resetOther();
        bb.reset();
        te.reset();
        if (te.tryConnect(world, te0.field_145851_c, te0.field_145848_d, te0.field_145849_e) && bb.tryConnect(world, x, y, z)) {
            return true;
        }
        ReikaChatHelper.writeString((String)"Connection is invalid");
        return false;
    }

    private static <T> boolean tryCopySettings(CopyableSettings<T> te, World world, int x, int y, int z, ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("x1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z1", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("x2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("y2", Integer.MIN_VALUE);
            is.field_77990_d.func_74768_a("z2", Integer.MIN_VALUE);
        }
        if (is.field_77990_d.func_74762_e("x1") == Integer.MIN_VALUE) {
            is.field_77990_d.func_74768_a("x1", x);
            is.field_77990_d.func_74768_a("y1", y);
            is.field_77990_d.func_74768_a("z1", z);
            is.field_77990_d.func_74768_a("w1", world.field_73011_w.field_76574_g);
        } else {
            is.field_77990_d.func_74768_a("x2", x);
            is.field_77990_d.func_74768_a("y2", y);
            is.field_77990_d.func_74768_a("z2", z);
            is.field_77990_d.func_74768_a("w2", world.field_73011_w.field_76574_g);
        }
        int ex = is.field_77990_d.func_74762_e("x1");
        int ey = is.field_77990_d.func_74762_e("y1");
        int ez = is.field_77990_d.func_74762_e("z1");
        int rx = is.field_77990_d.func_74762_e("x2");
        int ry = is.field_77990_d.func_74762_e("y2");
        int rz = is.field_77990_d.func_74762_e("z2");
        WorldServer w1 = DimensionManager.getWorld((int)is.field_77990_d.func_74762_e("w1"));
        WorldServer w2 = DimensionManager.getWorld((int)is.field_77990_d.func_74762_e("w2"));
        int dl = Math.abs(ex - rx + ey - ry + ez - rz) - 1;
        if (rx != Integer.MIN_VALUE && ry != Integer.MIN_VALUE && rz != Integer.MIN_VALUE && ex != Integer.MIN_VALUE && ey != Integer.MIN_VALUE && ez != Integer.MIN_VALUE) {
            CopyableSettings em = (CopyableSettings)w1.func_147438_o(ex, ey, ez);
            CopyableSettings rec = (CopyableSettings)w2.func_147438_o(rx, ry, rz);
            if (em == null) {
                ReikaChatHelper.writeString((String)("Tile missing at " + ex + ", " + ey + ", " + ez));
                is.field_77990_d = null;
                return false;
            }
            if (rec == null) {
                ReikaChatHelper.writeString((String)("Tile missing at " + rx + ", " + ry + ", " + rz));
                is.field_77990_d = null;
                return false;
            }
            if (rec == em) {
                ReikaChatHelper.writeString((String)"Cannot copy a tile to itself!");
                is.field_77990_d = null;
                return false;
            }
            if (rec.copySettingsFrom((Object)em)) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Copied settings from " + em + " to " + rec));
            } else {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Copy Failed.");
            }
            is.field_77990_d = null;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        is.field_77990_d = null;
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (is.field_77990_d != null) {
            int x1 = is.field_77990_d.func_74762_e("x1");
            int y1 = is.field_77990_d.func_74762_e("y1");
            int z1 = is.field_77990_d.func_74762_e("z1");
            int x2 = is.field_77990_d.func_74762_e("x2");
            int y2 = is.field_77990_d.func_74762_e("y2");
            int z2 = is.field_77990_d.func_74762_e("z2");
            int w1 = is.field_77990_d.func_74762_e("w1");
            int w2 = is.field_77990_d.func_74762_e("w2");
            if (x1 != Integer.MIN_VALUE) {
                li.add(String.format("Connected to %d, %d, %d in DIM%d", x1, y1, z1, w1));
            }
        }
    }

    private static enum Linkage {
        RIFT,
        WINDOW,
        LINKABLE,
        SIMPLE,
        SETTINGS;


        private static Linkage getLink(TileEntity te) {
            if (te == null) {
                return null;
            }
            if (te instanceof LinkedTile) {
                return RIFT;
            }
            if (te instanceof TileEntityTransportWindow) {
                return WINDOW;
            }
            if (te instanceof Linkable) {
                return LINKABLE;
            }
            if (te instanceof SimpleConnection) {
                return SIMPLE;
            }
            if (te instanceof CopyableSettings) {
                return SETTINGS;
            }
            return null;
        }

        private boolean tryLink(ItemStack is, EntityPlayer ep, TileEntity te) {
            switch (this) {
                case RIFT: {
                    return ItemConnector.connectRift((LinkedTile)te, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, is, ep);
                }
                case WINDOW: {
                    return ItemConnector.connectWindow((TileEntityTransportWindow)te, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, is, ep);
                }
                case LINKABLE: {
                    return ItemConnector.tryConnection((Linkable)te, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, is, ep);
                }
                case SIMPLE: {
                    return ItemConnector.trySimpleConnection((SimpleConnection)te, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, is, ep);
                }
                case SETTINGS: {
                    return ItemConnector.tryCopySettings((CopyableSettings)te, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, is, ep);
                }
            }
            return false;
        }
    }

    private static enum CopyMode {
        COPY,
        BROADCAST;

    }
}

