/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Block.BlockCrystalTank;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Block.MachineRegistryBlock;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Interfaces.TileEntity.PartialTank;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import buildcraft.transport.TileGenericPipe;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemEnderBucket
extends ItemChromaTool {
    public ItemEnderBucket(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        MovingObjectPosition mov = this.func_77621_a(world, ep, true);
        if (mov != null && mov.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (!world.field_72995_K) {
                this.actAt(world, mov.field_72311_b, mov.field_72312_c, mov.field_72309_d, mov.field_72310_e, ep, is);
            }
            return is;
        }
        if (ep.func_70093_af()) {
            if (!world.field_72995_K) {
                this.stepMode(is);
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Bucket now in " + this.getMode((ItemStack)is).displayName + " mode."));
            }
        } else {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.ENDERBUCKET.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return this.actAt(world, x, y, z, s, ep, is);
        }
        return false;
    }

    public void stepMode(ItemStack is) {
        is.func_77964_b((is.func_77960_j() + 1) % BucketMode.list.length);
    }

    private boolean actAt(World world, int x, int y, int z, int s, EntityPlayer ep, ItemStack is) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        BucketMode mode = this.getMode(is);
        Operation o = this.getOperation(world, x, y, z, ep, mode);
        if (o != null && o.apply(world, x, y, z, dir, ep, is, this.getActiveLink(is, ep))) {
            if (o == Operation.ADDTANK) {
                ChromaSounds.USE.playSoundAtBlock(world, x, y, z);
            } else {
                ReikaSoundHelper.playSoundFromServerAtBlock((World)world, (int)x, (int)y, (int)z, (String)"game.neutral.swim", (float)0.7f, (float)(0.7f + 0.3f * world.field_73012_v.nextFloat()), (boolean)true);
            }
            return true;
        }
        return false;
    }

    private Operation getOperation(World world, int x, int y, int z, EntityPlayer ep, BucketMode mode) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidHandler) {
            if (ep.func_70093_af()) {
                return Operation.ADDTANK;
            }
            return mode == BucketMode.PLACE ? Operation.TANKFILL : Operation.TANKDRAIN;
        }
        return mode == BucketMode.PLACE ? Operation.PLACEWORLD : Operation.PICKUPWORLD;
    }

    public BucketMode getMode(ItemStack is) {
        return BucketMode.list[is.func_77960_j()];
    }

    public int getActiveLinkIndex(ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            return -1;
        }
        int idx = is.field_77990_d.func_74764_b("selected") ? is.field_77990_d.func_74762_e("selected") : -1;
        return idx;
    }

    private TankLink getActiveLink(ItemStack is, EntityPlayer ep) {
        int idx = this.getActiveLinkIndex(is, ep);
        if (idx < 0) {
            return null;
        }
        ArrayList<TankLink> li = this.getLinks(is, ep);
        return idx >= 0 && idx < li.size() ? li.get(idx) : null;
    }

    public ArrayList<TankLink> getLinks(ItemStack is, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            return new ArrayList<TankLink>();
        }
        ArrayList<TankLink> ret = new ArrayList<TankLink>();
        NBTTagList li = is.field_77990_d.func_150295_c("links", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)it.next();
            TankLink tl = TankLink.createFromTag(tag);
            if (ep.field_70170_p.field_72995_K || tl.isValid()) {
                ret.add(tl);
                continue;
            }
            it.remove();
        }
        return ret;
    }

    public void removeLinkIndex(ItemStack is, int idx) {
        if (idx < 0 || is.field_77990_d == null) {
            return;
        }
        NBTTagList li = is.field_77990_d.func_150295_c("links", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        if (idx < li.field_74747_a.size()) {
            li.field_74747_a.remove(idx);
        }
    }

    private void addFluidHandler(TileEntity te, EntityPlayer ep, ItemStack is) {
        TankLink tl2;
        if (te instanceof BlockCrystalTank.CrystalTankAuxTile) {
            te = ((BlockCrystalTank.CrystalTankAuxTile)te).getTankController();
        }
        if (te instanceof PartialTank && !((PartialTank)te).hasTank()) {
            te = null;
        }
        if (InterfaceCache.BCPIPE.instanceOf(te) && !(((TileGenericPipe)te).pipe.transport instanceof IFluidHandler)) {
            te = null;
        }
        if (te == null) {
            return;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        ArrayList<TankLink> set = this.getLinks(is, ep);
        for (TankLink tl2 : set) {
            if (!tl2.tank.equals(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
            return;
        }
        NBTTagList li = is.field_77990_d.func_150295_c("links", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        tl2 = new TankLink((TileEntity)te);
        li.func_74742_a((NBTBase)tl2.writeTag());
        is.field_77990_d.func_74782_a("links", (NBTBase)li);
    }

    public void setLinkIndex(ItemStack is, int idx) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("selected", idx);
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return super.getItemSpriteIndex(item) + item.func_77960_j();
    }

    private static boolean tryAddFluid(IFluidHandler ifl, Fluid f, boolean doAdd) {
        FluidStack fs = new FluidStack(f, 1000);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int amt = ifl.fill(dir, fs, doAdd);
            if (amt < 1000) continue;
            return true;
        }
        return false;
    }

    private static FluidStack tryDrainFluid(IFluidHandler ifl, Fluid seek, boolean doDrain) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            FluidStack fs = ifl.drain(dir, 1000, doDrain);
            if (fs == null || seek != null && seek != fs.getFluid() || fs.amount < 1000) continue;
            return fs;
        }
        return null;
    }

    public static class TankLink {
        public final WorldLocation tank;
        private final BlockKey cachedBlock;
        private ItemStack cachedIcon;
        private Fluid cachedFluid;

        private TankLink(TileEntity te) {
            this(new WorldLocation(te), new BlockKey(te.field_145850_b.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e), te.field_145850_b.func_72805_g(te.field_145851_c, te.field_145848_d, te.field_145849_e)));
            this.cachedFluid = this.getCurrentFluidToDrain(false, false);
        }

        private TankLink(WorldLocation loc, BlockKey bk) {
            this.tank = loc;
            this.cachedBlock = bk;
            this.cachedIcon = this.calcItem();
        }

        public boolean isValid() {
            return this.cachedBlock != null && this.tank.getBlockKey().equals((Object)this.cachedBlock);
        }

        public IFluidHandler getTank() {
            TileEntity te = this.tank != null ? this.tank.getTileEntity() : null;
            return te instanceof IFluidHandler ? (IFluidHandler)te : null;
        }

        private ItemStack calcItem() {
            Block b = this.tank.getBlock();
            int meta = this.tank.getBlockMetadata();
            if (b instanceof MachineRegistryBlock) {
                TileEnum te = ((MachineRegistryBlock)b).getMachine((IBlockAccess)this.tank.getWorld(), this.tank.xCoord, this.tank.yCoord, this.tank.zCoord);
                return te.getCraftedProduct(this.tank.getTileEntity());
            }
            if (InterfaceCache.BCPIPEBLOCK.instanceOf((Object)b)) {
                return (ItemStack)b.getDrops(this.tank.getWorld(), this.tank.xCoord, this.tank.yCoord, this.tank.zCoord, this.tank.getBlockMetadata(), 0).get(0);
            }
            return b == Blocks.field_150350_a ? null : new ItemStack(b, 1, meta);
        }

        public ItemStack getIcon() {
            if (this.cachedIcon == null) {
                this.cachedIcon = this.calcItem();
            }
            return this.cachedIcon != null ? this.cachedIcon.func_77946_l() : null;
        }

        public String getDisplayName() {
            ItemStack is = this.getIcon();
            String s = is != null ? is.func_82833_r() : "";
            return s;
        }

        public Fluid getCurrentFluidToDrain(boolean doDrain, boolean render) {
            IFluidHandler ifl = this.getTank();
            if (ifl == null) {
                return render ? this.cachedFluid : null;
            }
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                FluidStack fs = ifl.drain(dir, 1000, doDrain);
                if (fs == null || fs.amount < 1000) continue;
                this.cachedFluid = fs.getFluid();
                return this.cachedFluid;
            }
            return null;
        }

        public boolean tryAddFluid(FluidStack fs, boolean doAdd) {
            IFluidHandler ifl = this.getTank();
            if (ifl == null) {
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                int added = ifl.fill(dir, fs, doAdd);
                if (added < fs.amount) continue;
                return true;
            }
            return false;
        }

        public NBTTagCompound writeTag() {
            NBTTagCompound tag = this.tank.writeToTag();
            this.cachedBlock.writeToNBT("cache", tag);
            if (this.cachedIcon != null) {
                NBTTagCompound item = new NBTTagCompound();
                this.cachedIcon.func_77955_b(item);
                tag.func_74782_a("item", (NBTBase)item);
            }
            if (this.cachedFluid != null) {
                tag.func_74778_a("fluid", this.cachedFluid.getName());
            }
            return tag;
        }

        public static TankLink createFromTag(NBTTagCompound tag) {
            WorldLocation loc = WorldLocation.readTag((NBTTagCompound)tag);
            BlockKey bk = BlockKey.readFromNBT((String)"cache", (NBTTagCompound)tag);
            TankLink lk = new TankLink(loc, bk);
            if (tag.func_74764_b("item")) {
                ItemStack is;
                NBTTagCompound item = tag.func_74775_l("item");
                lk.cachedIcon = is = ItemStack.func_77949_a((NBTTagCompound)item);
            }
            if (tag.func_74764_b("fluid")) {
                lk.cachedFluid = FluidRegistry.getFluid((String)tag.func_74779_i("fluid"));
            }
            return lk;
        }
    }

    public static enum BucketMode {
        PICKUP("Pickup"),
        PLACE("Place");

        public final String displayName;
        public static final BucketMode[] list;

        private BucketMode(String s) {
            this.displayName = s;
        }

        static {
            list = BucketMode.values();
        }
    }

    private static enum Operation {
        PICKUPWORLD,
        TANKDRAIN,
        PLACEWORLD,
        TANKFILL,
        ADDTANK;


        private boolean apply(World world, int x, int y, int z, ForgeDirection dir, EntityPlayer ep, ItemStack is, TankLink link) {
            switch (this) {
                case ADDTANK: {
                    ((ItemEnderBucket)is.func_77973_b()).addFluidHandler(world.func_147438_o(x, y, z), ep, is);
                    return true;
                }
                case PICKUPWORLD: {
                    if (link == null) {
                        return false;
                    }
                    FluidStack fs = ReikaWorldHelper.getDrainableFluid((World)world, (int)x, (int)y, (int)z);
                    if (fs != null && link.tryAddFluid(fs, false)) {
                        link.tryAddFluid(fs, true);
                        world.func_147449_b(x, y, z, Blocks.field_150350_a);
                        return true;
                    }
                    return false;
                }
                case PLACEWORLD: {
                    Fluid f;
                    if (link == null) {
                        return false;
                    }
                    if (ReikaBlockHelper.isLiquid((Block)world.func_147439_a(x, y, z))) {
                        return false;
                    }
                    if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x += dir.offsetX), (int)(y += dir.offsetY), (int)(z += dir.offsetZ)) && (f = link.getCurrentFluidToDrain(false, false)) != null && f.getBlock() != null) {
                        if (ReikaFluidHelper.lookupFluidForBlock((Block)world.func_147439_a(x, y, z)) == f && ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)x, (int)y, (int)z)) {
                            return false;
                        }
                        link.getCurrentFluidToDrain(true, false);
                        world.func_147465_d(x, y, z, f.getBlock(), 0, 3);
                        world.func_147471_g(x, y, z);
                        world.func_147439_a(x, y, z).func_149695_a(world, x, y, z, f.getBlock());
                        return true;
                    }
                    return false;
                }
                case TANKDRAIN: {
                    if (link == null) {
                        return false;
                    }
                    if (link.tank.equals(world, x, y, z)) {
                        return false;
                    }
                    IFluidHandler ifl = (IFluidHandler)world.func_147438_o(x, y, z);
                    if (ifl == null) {
                        return false;
                    }
                    Fluid f = link.getCurrentFluidToDrain(false, false);
                    FluidStack fs = ItemEnderBucket.tryDrainFluid(ifl, f, false);
                    if (fs != null && link.tryAddFluid(fs, false)) {
                        ItemEnderBucket.tryDrainFluid(ifl, f, true);
                        link.tryAddFluid(fs, true);
                        return true;
                    }
                    return false;
                }
                case TANKFILL: {
                    if (link == null) {
                        return false;
                    }
                    if (link.tank.equals(world, x, y, z)) {
                        return false;
                    }
                    IFluidHandler ifl = (IFluidHandler)world.func_147438_o(x, y, z);
                    if (ifl == null) {
                        return false;
                    }
                    Fluid f = link.getCurrentFluidToDrain(false, false);
                    if (f != null && ItemEnderBucket.tryAddFluid(ifl, f, false)) {
                        link.getCurrentFluidToDrain(true, false);
                        ItemEnderBucket.tryAddFluid(ifl, f, true);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

