/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemRecipeCacheCapsule
extends ItemChromaTool {
    public ItemRecipeCacheCapsule(int index) {
        super(index);
        this.field_77777_bU = 4;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityCastingTable te;
        if (world.field_72995_K) {
            return false;
        }
        if (ChromaTiles.getTile((IBlockAccess)world, x, y, z) == ChromaTiles.TABLE && (te = (TileEntityCastingTable)world.func_147438_o(x, y, z)).isOwnedByPlayer(player)) {
            CachedRecipe cr = ItemRecipeCacheCapsule.getRecipe(stack);
            if (cr != null) {
                if (cr.applyToTable(te)) {
                    ItemRecipeCacheCapsule.setRecipe(stack, null);
                    ChromaSounds.CAST.playSoundAtBlock((TileEntity)te, 0.5f, 2.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                } else {
                    ChromaSounds.ERROR.playSoundAtBlock((TileEntity)te);
                }
            } else {
                ItemRecipeCacheCapsule.setRecipe(stack, new CachedRecipe(ItemRecipeCacheCapsule.findClosestRecipe(te), te));
                ChromaSounds.USE.playSoundAtBlock((TileEntity)te);
            }
        }
        return true;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        CachedRecipe pos = ItemRecipeCacheCapsule.getRecipe(is);
        if (pos != null) {
            li.add("Storing recipe: " + (pos.recipe != null ? pos.recipe.getDisplayName() : "Unknown") + " at table " + pos.tableLoc);
        } else {
            li.add("Contains no recipe.");
        }
    }

    private static CachedRecipe getRecipe(ItemStack is) {
        return is.field_77990_d != null && is.field_77990_d.func_74764_b("recipe") ? CachedRecipe.loadRecipe(is.field_77990_d.func_74775_l("recipe")) : null;
    }

    private static void setRecipe(ItemStack is, CachedRecipe cr) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        if (cr != null) {
            NBTTagCompound tag = new NBTTagCompound();
            cr.writeToNBT(tag);
            is.field_77990_d.func_74782_a("recipe", (NBTBase)tag);
        } else {
            is.field_77990_d.func_82580_o("recipe");
        }
    }

    private static CastingRecipe.MultiBlockCastingRecipe findClosestRecipe(TileEntityCastingTable te) {
        CastingRecipe.MultiBlockCastingRecipe ret = null;
        int diffs = Integer.MAX_VALUE;
        for (CastingRecipe r : RecipesCastingTable.instance.getAllRecipes()) {
            if (!(r instanceof CastingRecipe.MultiBlockCastingRecipe)) continue;
            int diff = ItemRecipeCacheCapsule.getRecipeDifference(te, (CastingRecipe.MultiBlockCastingRecipe)r);
            if (ret != null && diff >= diffs) continue;
            ret = (CastingRecipe.MultiBlockCastingRecipe)r;
            diffs = diff;
        }
        return ret;
    }

    private static int getRecipeDifference(TileEntityCastingTable te, CastingRecipe.MultiBlockCastingRecipe r) {
        int ret = 0;
        for (Map.Entry<List<Integer>, TileEntityItemStand> e : te.getOtherStands().entrySet()) {
            ItemMatch at = r.getAuxItem(e.getKey());
            ItemStack has = e.getValue().func_70301_a(0);
            if (!(at != null ? !at.match(has) : has != null)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        int base = super.getItemSpriteIndex(item);
        return ItemRecipeCacheCapsule.getRecipe(item) == null ? base : base + 1;
    }

    private static class CachedRecipe {
        private final CastingRecipe.MultiBlockCastingRecipe recipe;
        private final Coordinate tableLoc;
        private final HashMap<Coordinate, ItemStack> standContents = new HashMap();

        private CachedRecipe(String id, Coordinate c) {
            this.recipe = Strings.isNullOrEmpty((String)id) ? null : (CastingRecipe.MultiBlockCastingRecipe)RecipesCastingTable.instance.getRecipeByStringID(id);
            this.tableLoc = c;
        }

        private CachedRecipe(CastingRecipe.MultiBlockCastingRecipe rec, TileEntityCastingTable table) {
            this.tableLoc = new Coordinate((TileEntity)table);
            this.recipe = rec;
            for (TileEntityItemStand te : table.getOtherStands().values()) {
                ItemStack is = te.func_70301_a(0);
                this.standContents.put(new Coordinate((TileEntity)te), is != null ? is.func_77946_l() : null);
                te.func_70299_a(0, null);
                te.syncAllData(true);
            }
            table.syncAllData(true);
        }

        public boolean applyToTable(TileEntityCastingTable te) {
            if (!this.tableLoc.equals((TileEntity)te)) {
                return false;
            }
            for (Coordinate coordinate : this.standContents.keySet()) {
                if (ChromaTiles.getTile((IBlockAccess)te.field_145850_b, coordinate.xCoord, coordinate.yCoord, coordinate.zCoord) == ChromaTiles.STAND) continue;
                return false;
            }
            te.dumpAllStands();
            for (Map.Entry entry : this.standContents.entrySet()) {
                TileEntityItemStand te2 = (TileEntityItemStand)((Coordinate)entry.getKey()).getTileEntity((IBlockAccess)te.field_145850_b);
                te2.func_70299_a(0, (ItemStack)entry.getValue());
                te2.syncAllData(true);
            }
            te.syncAllData(true);
            return true;
        }

        private void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("recipeID", this.recipe != null ? this.recipe.getIDString() : "");
            this.tableLoc.writeToNBT("location", tag);
            NBTTagList li = new NBTTagList();
            for (Map.Entry<Coordinate, ItemStack> e : this.standContents.entrySet()) {
                NBTTagCompound at = new NBTTagCompound();
                e.getKey().writeToNBT("pos", at);
                if (e.getValue() != null) {
                    e.getValue().func_77955_b(at);
                }
                li.func_74742_a((NBTBase)at);
            }
            tag.func_74782_a("items", (NBTBase)li);
        }

        private static CachedRecipe loadRecipe(NBTTagCompound tag) {
            String id = tag.func_74779_i("recipeID");
            Coordinate loc = Coordinate.readFromNBT((String)"location", (NBTTagCompound)tag);
            NBTTagList li = tag.func_150295_c("items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            HashMap<Coordinate, ItemStack> map = new HashMap<Coordinate, ItemStack>();
            for (Object o : li.field_74747_a) {
                NBTTagCompound at = (NBTTagCompound)o;
                Coordinate c = Coordinate.readFromNBT((String)"pos", (NBTTagCompound)at);
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)at);
                map.put(c, item);
            }
            CachedRecipe ret = new CachedRecipe(id, loc);
            ret.standContents.putAll(map);
            return ret;
        }
    }
}

