/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.Ability.LightCast;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.OpenPathFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.ParticleController.BlendListColorController;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemSplineAttack
extends ItemChromaTool {
    public static final int MAX_RANGE = 40;
    public static final int MAX_HOPS = 6;
    public static final int COOLDOWN = 10;
    private final Random rand = new Random();
    private static RayTracer losTrace = RayTracer.getVisualLOS();
    private final SplineTargeting attackableSelector = new SplineTargeting();

    public ItemSplineAttack(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        if (world.func_82737_E() - is.field_77990_d.func_74763_f("lastfire") < 10L) {
            ChromaSounds.ERROR.playSound((Entity)ep);
            return is;
        }
        this.rand.setSeed(ep.func_110124_au().getLeastSignificantBits() ^ ep.func_110124_au().getMostSignificantBits() + (is.field_77990_d.func_74763_f("lastfire") << 7));
        this.rand.nextBoolean();
        EntityTarget tgt = this.getFirstEntityTarget(world, ep);
        if (tgt == null) {
            return is;
        }
        ArrayList<EntityTarget> li = new ArrayList<EntityTarget>();
        EntityTarget from = tgt;
        while (from != null) {
            li.add(from);
            List<EntityTarget> next = li.size() < 6 ? this.getAttackableEntitiesFrom(world, from.entity, ep, li) : null;
            from = next == null || next.isEmpty() ? null : (EntityTarget)ReikaJavaLibrary.getRandomListEntry((Random)this.rand, next);
        }
        Spline s = new Spline(Spline.SplineType.CHORDAL);
        if (world.field_72995_K) {
            DecimalPosition pos = new DecimalPosition(ep.field_70165_t, ep.field_70163_u - 0.375, ep.field_70161_v);
            s.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(pos));
        }
        int i = 1;
        float f = 0.5f * (float)((double)CrystalMusicManager.instance.getRandomScaledDing(CrystalElement.BLACK) / CrystalMusicManager.instance.getDingPitchScale(CrystalElement.BLACK));
        int maxdur = -1;
        for (EntityTarget e : li) {
            if (!world.field_72995_K) {
                int tick = i * 4;
                maxdur = Math.max(tick, maxdur);
                TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledTickEvent.DelayedAttack(e.entity, DamageSource.func_76354_b((Entity)ep, (Entity)ep), 6.0f)), tick);
                ScheduledTickEvent.ScheduledSoundEvent ev = new ScheduledTickEvent.ScheduledSoundEvent((SoundEnum)ChromaSounds.ORB.getDownshiftedPitch(), (Entity)ep, 0.5f, f);
                ev.attenuate = false;
                ev.broadcastRange = 96;
                TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)ev), tick);
            }
            if (world.field_72995_K) {
                s.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(((EntityTarget)e).entity.field_70165_t, ((EntityTarget)e).entity.field_70163_u + (double)(((EntityTarget)e).entity.field_70131_O / 2.0f), ((EntityTarget)e).entity.field_70161_v)));
            }
            ++i;
        }
        is.field_77990_d.func_74772_a("lastfire", world.func_82737_E() + (long)maxdur);
        if (world.field_72995_K) {
            this.doTrail(world, s);
        }
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    private void doTrail(World world, Spline s) {
        List trail = s.get(128, false);
        ColorBlendList cbl = new ColorBlendList(6.0f, new int[]{0, 0x2288FF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0x404040});
        BlendListColorController clr = new BlendListColorController(cbl);
        int i = 0;
        for (DecimalPosition pos : trail) {
            EntityBlurFX fx = new EntityCCBlurFX(world, pos.xCoord, pos.yCoord, pos.zCoord).setLife(15).setScale(2.0f).setAlphaFading();
            fx.setColorController((ColorController)clr).freezeLife(i / 64);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            ++i;
        }
    }

    private EntityTarget getFirstEntityTarget(World world, EntityPlayer ep) {
        Vec3 vec = ep.func_70040_Z();
        for (double d = 0.0; d <= 40.0; d += 1.0) {
            double dx = ep.field_70165_t + vec.field_72450_a * d;
            double dy = ep.field_70163_u + 1.62 + vec.field_72448_b * d;
            double dz = ep.field_70161_v + vec.field_72449_c * d;
            double r = 1.0 + d / 4.0;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)dx, (double)dy, (double)dz, (double)dx, (double)dy, (double)dz).func_72314_b(r, r, r);
            List li = world.func_94576_a((Entity)ep, box, (IEntitySelector)this.attackableSelector);
            ArrayList<EntityTarget> li2 = new ArrayList<EntityTarget>();
            for (EntityLivingBase e : li) {
                LinkedList<Coordinate> pos;
                if (e == ep || (pos = this.getPath((EntityLivingBase)ep, e)) == null) continue;
                li2.add(new EntityTarget(e, pos));
            }
            if (li2.isEmpty()) continue;
            return (EntityTarget)ReikaJavaLibrary.getRandomListEntry((Random)this.rand, li2);
        }
        return null;
    }

    private LinkedList<Coordinate> getPath(EntityLivingBase from, EntityLivingBase to) {
        losTrace.setOrigins(from.field_70165_t, from.field_70163_u + (double)(from.field_70131_O / 2.0f), from.field_70161_v, to.field_70165_t, to.field_70163_u + (double)(to.field_70131_O / 2.0f), to.field_70161_v);
        if (losTrace.isClearLineOfSight(from.field_70170_p)) {
            LinkedList<Coordinate> li = new LinkedList<Coordinate>();
            li.add(new Coordinate((Entity)from));
            li.add(new Coordinate((Entity)to));
            return li;
        }
        BlockBox box = BlockBox.between((Entity)from, (Entity)to).expand(8, 6, 8);
        return BreadthFirstSearch.getOpenPathBetween((World)from.field_70170_p, (Coordinate)new Coordinate((Entity)from), (Coordinate)new Coordinate((Entity)to), (int)16, (BlockBox)box);
    }

    private List<EntityTarget> getAttackableEntitiesFrom(World world, EntityLivingBase from, EntityPlayer owner, List<EntityTarget> path) {
        for (double d = 1.0; d <= 40.0; d += Math.sqrt(d)) {
            d = Math.ceil(d);
            AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)from, (double)d);
            List li = world.func_94576_a((Entity)from, box, (IEntitySelector)this.attackableSelector);
            ArrayList<EntityTarget> li2 = new ArrayList<EntityTarget>();
            for (EntityLivingBase e : li) {
                LinkedList<Coordinate> pos;
                if (e == owner) continue;
                boolean flag = true;
                for (EntityTarget at : path) {
                    if (at.entity != e) continue;
                    flag = false;
                    break;
                }
                if ((pos = flag ? this.getPath(from, e) : null) == null) continue;
                li2.add(new EntityTarget(e, pos));
            }
            if (li2.isEmpty()) continue;
            return li2;
        }
        return null;
    }

    private static class EntityTarget {
        private final EntityLivingBase entity;
        private final LinkedList<Coordinate> path;

        private EntityTarget(EntityLivingBase e, LinkedList<Coordinate> li) {
            this.entity = e;
            this.path = li;
        }
    }

    private static class PathFinder
    extends OpenPathFinder {
        private static final HashSet<BlockKey> passableBlocks = new HashSet();

        private static void initPassable() {
            if (passableBlocks.isEmpty()) {
                for (BlockKey blockKey : RayTracer.getTransparentBlocks()) {
                    passableBlocks.add(blockKey);
                }
                for (Block block : LightCast.getPassthroughBlocks()) {
                    passableBlocks.add(new BlockKey(block));
                }
            }
        }

        public PathFinder(Coordinate c1, Coordinate c2, int r) {
            super(c1, c2, r);
        }

        protected boolean isValidBlock(World world, int x, int y, int z) {
            return super.isValidBlock(world, x, y, z) || this.isPassableBlock(world, x, y, z);
        }

        private boolean isPassableBlock(World world, int x, int y, int z) {
            PathFinder.initPassable();
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z);
            return passableBlocks.contains(bk);
        }
    }

    private static class SplineTargeting
    implements IEntitySelector {
        private SplineTargeting() {
        }

        public boolean func_82704_a(Entity e) {
            return this.isValidType(e);
        }

        private boolean isValidType(Entity e) {
            if (e instanceof EntityPlayer) {
                EntityPlayer ep = (EntityPlayer)e;
                if (ep.field_71075_bZ.field_75098_d) {
                    return false;
                }
                if (MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71219_W()) {
                    return false;
                }
            }
            return e instanceof EntityLivingBase;
        }
    }
}

