/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Item.SpriteRenderCallback;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemStructureMap
extends ItemChromaTool
implements SpriteRenderCallback {
    private static final String TAG_NAME = "mapdata";

    public ItemStructureMap(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (!(world.field_72995_K || is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_NAME))) {
            if (ep.func_70093_af()) {
                StructureSearch s = StructureSearch.list[is.func_77960_j()];
                int x0 = MathHelper.func_76128_c((double)ep.field_70165_t);
                int z0 = MathHelper.func_76128_c((double)ep.field_70161_v);
                StructureMapData data = s.getLocations((WorldServer)world, x0, z0);
                if (is.field_77990_d == null) {
                    is.field_77990_d = new NBTTagCompound();
                }
                is.field_77990_d.func_74782_a(TAG_NAME, (NBTBase)data.writeToNBT());
            } else {
                boolean flag = true;
                while (flag) {
                    is.func_77964_b((is.func_77960_j() + 1) % StructureSearch.list.length);
                    flag = StructureSearch.list[is.func_77960_j()].skip();
                }
            }
        }
        return is;
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (!held || is.field_77990_d == null || is.field_77990_d.func_74764_b(TAG_NAME)) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        li.add("Seeking " + StructureSearch.list[is.func_77960_j()].displayName());
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b(TAG_NAME)) {
            if (GuiScreen.func_146271_m()) {
                StructureMapData map = StructureMapData.readFromNBT(is.field_77990_d.func_74775_l(TAG_NAME));
                map.addTooltip(li);
            } else {
                li.add("Map is populated.");
            }
        } else {
            li.add("Map is empty.");
        }
    }

    public boolean doPreGLTransforms(ItemStack is, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean onRender(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderMap(ItemStack item, float ptick, EntityPlayer ep) {
        if (item.field_77990_d == null || !item.field_77990_d.func_74764_b(TAG_NAME)) {
            return;
        }
        StructureMapData data = StructureMapData.readFromNBT(item.field_77990_d.func_74775_l(TAG_NAME));
        ReikaRenderHelper.disableEntityLighting();
        ReikaRenderHelper.disableLighting();
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glEnable((int)3553);
        StructureSearch type = StructureSearch.list[item.func_77960_j()];
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/StructureMap/overlay_typed.png");
        double ou = (double)(type.ordinal() % 4) / 4.0;
        double ov = (double)(type.ordinal() / 4) / 4.0;
        v5.func_78382_b();
        v5.func_78380_c(240);
        v5.func_78378_d(0xFFFFFF);
        int b0 = 7;
        double rz = -0.01;
        int px = data.originX;
        int pz = data.originZ;
        int max = type.getSearchRange();
        if (max == -1) {
            px = data.bounds.getCenterX();
            pz = data.bounds.getCenterZ();
            Coordinate far = data.bounds.getFarthestPointFrom(px, data.bounds.getCenterY(), pz);
            max = Math.max(Math.abs(far.xCoord - px), Math.abs(far.zCoord - pz));
        }
        v5.func_78374_a((double)(0 - b0), (double)(128 + b0), rz, ou, ov + 0.25);
        v5.func_78374_a((double)(128 + b0), (double)(128 + b0), rz, ou + 0.25, ov + 0.25);
        v5.func_78374_a((double)(128 + b0), (double)(0 - b0), rz, ou + 0.25, ov);
        v5.func_78374_a((double)(0 - b0), (double)(0 - b0), rz, ou, ov);
        v5.func_78381_a();
        int d = 12;
        GL11.glDepthMask((boolean)false);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/StructureMap/marker.png");
        v5.func_78382_b();
        v5.func_78380_c(240);
        double sc = 2.0;
        for (Map.Entry e : data.map.entrySet()) {
            Coordinate loc = (Coordinate)e.getKey();
            StructurePresence s = (StructurePresence)((Object)e.getValue());
            int x = (int)Math.round((double)(loc.xCoord - px) * 40.0 / (double)max + 64.0);
            int z = (int)Math.round((double)(loc.zCoord - pz) * 40.0 / (double)max + 64.0);
            v5.func_78378_d(s.renderColor);
            v5.func_78374_a((double)x - sc, (double)z + sc, rz * 2.0, 0.0, 1.0);
            v5.func_78374_a((double)x + sc, (double)z + sc, rz * 2.0, 1.0, 1.0);
            v5.func_78374_a((double)x + sc, (double)z - sc, rz * 2.0, 1.0, 0.0);
            v5.func_78374_a((double)x - sc, (double)z - sc, rz * 2.0, 0.0, 0.0);
        }
        v5.func_78381_a();
    }

    private static enum StructurePresence {
        EXPECTED(0xFFFF00),
        CONFIRMED(65280),
        FAILED(0xFF0000);

        public final int renderColor;

        private StructurePresence(int c) {
            this.renderColor = c;
        }
    }

    private static class StructureMapData {
        private final HashMap<Coordinate, StructurePresence> map;
        private final int originX;
        private final int originZ;
        private final BlockBox bounds;
        private final int confirmedCount;

        private StructureMapData(HashMap<Coordinate, StructurePresence> data, int x, int z, int cc, BlockBox box) {
            this.map = data;
            this.originX = x;
            this.originZ = z;
            this.confirmedCount = cc;
            this.bounds = box;
        }

        public void addTooltip(List li) {
            li.add("Confirmed " + this.confirmedCount + "/" + this.map.size() + " locations.");
        }

        public static StructureMapData readFromNBT(NBTTagCompound data) {
            HashMap<Coordinate, StructurePresence> values = new HashMap<Coordinate, StructurePresence>();
            NBTTagList li = data.func_150295_c(ItemStructureMap.TAG_NAME, ReikaNBTHelper.NBTTypes.COMPOUND.ordinal());
            int cc = 0;
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                Coordinate loc = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)tag);
                StructurePresence s = StructurePresence.valueOf(tag.func_74779_i("state"));
                if (s == StructurePresence.CONFIRMED) {
                    ++cc;
                }
                values.put(loc, s);
            }
            NBTTagCompound meta = data.func_74775_l("metadata");
            return new StructureMapData(values, meta.func_74762_e("rootX"), meta.func_74762_e("rootZ"), cc, BlockBox.readFromNBT((NBTTagCompound)meta));
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound ret = new NBTTagCompound();
            NBTTagList tag = new NBTTagList();
            for (Map.Entry<Coordinate, StructurePresence> e : this.map.entrySet()) {
                NBTTagCompound val = new NBTTagCompound();
                e.getKey().writeToNBT("loc", val);
                val.func_74778_a("state", e.getValue().name());
                tag.func_74742_a((NBTBase)val);
            }
            NBTTagCompound meta = new NBTTagCompound();
            this.bounds.writeToNBT(meta);
            meta.func_74768_a("rootX", this.originX);
            meta.func_74768_a("rootZ", this.originZ);
            ret.func_74782_a(ItemStructureMap.TAG_NAME, (NBTBase)tag);
            ret.func_74782_a("metadata", (NBTBase)meta);
            return ret;
        }
    }

    public static enum StructureSearch {
        STRONGHOLD,
        TOWERS,
        CAVERN(ChromaStructures.CAVERN),
        BURROW(ChromaStructures.BURROW),
        OCEAN(ChromaStructures.OCEAN),
        DESERT(ChromaStructures.DESERT),
        SNOWSTRUCT(ChromaStructures.SNOWSTRUCT),
        MINESHAFT,
        BIOME(ChromaStructures.BIOMEFRAG);

        private static final StructureSearch[] list;
        private final ChromaStructures structure;

        private StructureSearch() {
            this(null);
        }

        private boolean skip() {
            return this == MINESHAFT;
        }

        public int getSearchRange() {
            if (this.structure != null) {
                return 2048;
            }
            switch (this) {
                case STRONGHOLD: 
                case TOWERS: {
                    return -1;
                }
            }
            return 1;
        }

        private StructureSearch(ChromaStructures s) {
            this.structure = s;
        }

        public String displayName() {
            if (this == TOWERS) {
                return ChromaFontRenderer.FontType.OBFUSCATED.id + "GlowingTowers";
            }
            if (this.structure != null) {
                return this.structure.getDisplayName();
            }
            return ReikaStringParser.capFirstChar((String)this.name());
        }

        private StructureMapData getLocations(WorldServer world, int x0, int z0) {
            HashMap<Coordinate, StructurePresence> li = new HashMap<Coordinate, StructurePresence>();
            int cc = 0;
            BlockBox bounds = BlockBox.nothing();
            if (this.structure != null) {
                int range = 128;
                for (int i = -range; i <= range; ++i) {
                    for (int k = -range; k <= range; ++k) {
                        int rx = x0 + i * 16;
                        int rz = z0 + k * 16;
                        DungeonGenerator.StructureGenStatus at = DungeonGenerator.instance.getGenStatus(this.structure, world, rx, rz);
                        if (!at.hasStructure()) continue;
                        Coordinate c = new Coordinate(rx, 0, rz);
                        boolean cf = at.isFinalized();
                        if (cf) {
                            ++cc;
                        }
                        bounds = bounds.addCoordinate(c.xCoord, c.yCoord, c.zCoord);
                        li.put(c, cf ? StructurePresence.CONFIRMED : StructurePresence.EXPECTED);
                    }
                }
            } else {
                switch (this) {
                    case STRONGHOLD: {
                        MapGenStronghold mg = ((ChunkProviderGenerate)world.field_73059_b.field_73246_d).field_73225_u;
                        Field f = ReikaReflectionHelper.getProtectedInheritedField((Object)mg, (String)(FMLForgePlugin.RUNTIME_DEOBF ? "field_75039_c" : "worldObj"));
                        f.setAccessible(true);
                        try {
                            f.set(mg, world);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ReikaObfuscationHelper.invoke((String)"canSpawnStructureAtCoords", (Object)mg, (Object[])new Object[]{0, 0});
                        List li0 = (List)ReikaObfuscationHelper.invoke((String)"getCoordList", (Object)mg, (Object[])new Object[0]);
                        if (li0 != null) {
                            for (Object o : li0) {
                                Coordinate c = new Coordinate((ChunkPosition)o).to2D();
                                bounds = bounds.addCoordinate(c.xCoord, c.yCoord, c.zCoord);
                                li.put(c, StructurePresence.EXPECTED);
                            }
                        }
                        for (StructureStart ss : mg.field_75053_d.values()) {
                            StructureBoundingBox sbb;
                            if (!ss.func_75069_d() || (sbb = ss.func_75071_a()) == null) continue;
                            Coordinate c = new Coordinate(sbb.func_78881_e(), 0, sbb.func_78891_g());
                            bounds = bounds.addCoordinate(c.xCoord, c.yCoord, c.zCoord);
                            li.put(c, StructurePresence.CONFIRMED);
                            ++cc;
                        }
                        break;
                    }
                    case TOWERS: {
                        for (Towers t : Towers.towerList) {
                            Coordinate c = t.getGeneratedLocation();
                            if (c == null) {
                                c = new Coordinate(t.getRootPosition().field_77276_a, 0, t.getRootPosition().field_77275_b);
                            }
                            bounds = bounds.addCoordinate(c.xCoord, c.yCoord, c.zCoord);
                            boolean cf = ReikaWorldHelper.isChunkGenerated((WorldServer)world, (int)c.xCoord, (int)c.zCoord);
                            if (cf) {
                                ++cc;
                            }
                            li.put(c, cf ? StructurePresence.CONFIRMED : StructurePresence.EXPECTED);
                        }
                        break;
                    }
                }
            }
            return new StructureMapData(li, x0, z0, cc, bounds);
        }

        static {
            list = StructureSearch.values();
        }
    }
}

