/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemWarpCapsule
extends ItemChromaTool {
    public ItemWarpCapsule(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        DecimalPosition pos = ItemWarpCapsule.getPosition(is);
        int dim = ItemWarpCapsule.getDimension(is);
        if (pos == null) {
            ItemWarpCapsule.setPosition(is, (Entity)ep);
        } else if (!world.field_72995_K && ep instanceof EntityPlayerMP) {
            ItemWarpCapsule.teleport((EntityPlayerMP)ep, pos, dim);
        }
        return is;
    }

    private static void teleport(EntityPlayerMP ep, DecimalPosition pos, int dim) {
        if (ItemWarpCapsule.canTeleport((EntityPlayer)ep, pos, dim)) {
            double dz;
            double dx;
            double r = 12.0;
            double dy = pos.yCoord;
            WorldServer world = (WorldServer)ep.field_70170_p;
            AxisAlignedBB test = ReikaAABBHelper.copyAABB((AxisAlignedBB)ep.field_70121_D).func_72331_e(0.25, 0.25, 0.25);
            do {
                dx = ReikaRandomHelper.getRandomPlusMinus((double)pos.xCoord, (double)r);
                dz = ReikaRandomHelper.getRandomPlusMinus((double)pos.zCoord, (double)r);
                test.func_72317_d(dx - test.field_72340_a, dy - test.field_72338_b, dz - test.field_72339_c);
            } while (!world.func_72945_a((Entity)ep, test).isEmpty());
            do {
                double maxh = 1.0 + ep.field_70170_p.field_73012_v.nextDouble() * 8.0;
                dy = pos.yCoord + maxh;
                test.func_72317_d(dx - test.field_72340_a, dy - test.field_72338_b, dz - test.field_72339_c);
            } while (!world.func_72945_a((Entity)ep, test).isEmpty());
            ep.func_70634_a(dx, dy, dz);
            double vel = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
            double[] v = ReikaPhysicsHelper.polarToCartesian((double)vel, (double)(ep.field_70170_p.field_73012_v.nextDouble() * 360.0), (double)(ep.field_70170_p.field_73012_v.nextDouble() * 360.0));
            ep.field_70159_w = v[0];
            ep.field_70181_x = v[1];
            ep.field_70179_y = v[2];
            ep.field_70133_I = true;
            ep.field_70143_R = ep.field_70170_p.field_73012_v.nextFloat() * 5.0f + (float)Math.max(-ep.field_70181_x * 5.0, 0.0);
            ep.func_70062_b(0, null);
            ReikaSoundHelper.playSoundFromServer((World)world, (double)dx, (double)dy, (double)dz, (String)"mob.endermen.portal", (float)2.0f, (float)1.0f, (boolean)true);
            ReikaSoundHelper.playSoundFromServer((World)world, (double)dx, (double)dy, (double)dz, (String)"mob.endermen.portal", (float)2.0f, (float)1.0f, (boolean)true);
            ChromaSounds.RIFT.playSound((Entity)ep, 1.0f, 0.5f);
            ChromaSounds.RIFT.playSound((Entity)ep, 1.0f, 0.75f);
            ep.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 5));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canTeleport(EntityPlayer ep, DecimalPosition pos, int dim) {
        if (dim != ep.field_70170_p.field_73011_w.field_76574_g) return false;
        if (!new WorldLocation((Entity)ep).canSeeTheSky()) return false;
        DecimalPosition decimalPosition = new DecimalPosition((Entity)ep);
        if (!(pos.getDistanceTo(decimalPosition) <= 2000.0)) return false;
        return true;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        DecimalPosition pos = ItemWarpCapsule.getPosition(is);
        if (pos != null) {
            li.add("Linked to around " + pos.formattedString(1) + " in DIM" + ItemWarpCapsule.getDimension(is));
        }
    }

    private static int getDimension(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("dim") : 0;
    }

    private static DecimalPosition getPosition(ItemStack is) {
        return is.field_77990_d != null ? DecimalPosition.readFromNBT((String)"pos", (NBTTagCompound)is.field_77990_d) : null;
    }

    private static void setPosition(ItemStack is, Entity e) {
        DecimalPosition p = new DecimalPosition(e);
        is.field_77990_d = new NBTTagCompound();
        p.writeToNBT("pos", is.field_77990_d);
        is.field_77990_d.func_74768_a("dim", e.field_70170_p.field_73011_w.field_76574_g);
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        int base = super.getItemSpriteIndex(item);
        return ItemWarpCapsule.getPosition(item) == null ? base : base + 1;
    }
}

