/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Powered;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ColoredMultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Render.ProbeInfoOverlayRenderer;
import Reika.ChromatiCraft.Auxiliary.Render.StructureErrorOverlays;
import Reika.ChromatiCraft.Auxiliary.Structure.RitualStructure;
import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.BlockMultiBlock;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class ItemCrystalProbe
extends ItemPoweredChromaTool {
    public static final int CHARGE_TIME = 50;

    public ItemCrystalProbe(int index) {
        super(index);
    }

    public void func_77615_a(ItemStack is, World world, EntityPlayer ep, int count) {
        count = MathHelper.func_76125_a((int)(this.func_77626_a(is) - count), (int)0, (int)50);
        if (count >= 50) {
            this.fire(is, world, ep);
        }
        ep.func_71008_a(null, 0);
    }

    private void fire(ItemStack is, World world, EntityPlayer ep) {
        if (world.field_72995_K) {
            return;
        }
        MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)5.0, (boolean)false);
        if (mov != null) {
            int x = mov.field_72311_b;
            int y = mov.field_72312_c;
            int z = mov.field_72309_d;
            int s = mov.field_72310_e;
            Inspections i = Inspections.list[this.getActionType(is)];
            if (i != null && i.isValid(world, x, y, z) && ToolChargingSystem.instance.getCharge(is) >= i.energyCost) {
                ChromaSounds.LOREHEX.playSound((Entity)ep, 1.0f, 1.0f);
                if (i.doEffect(world, x, y, z, s, ep, is)) {
                    ToolChargingSystem.instance.removeCharge(is, i.energyCost, ep);
                }
            }
        }
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            int type = this.getActionType(is);
            type = (type + 1) % Inspections.list.length;
            is.field_77990_d.func_74768_a("type", type);
        } else if (!this.handleUseAllowance(ep) && this.isActivated(ep, is, true)) {
            ep.func_71008_a(is, this.func_77626_a(is));
        }
        return is;
    }

    private int getActionType(ItemStack is) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        int type = is.field_77990_d != null ? is.field_77990_d.func_74762_e("type") : 0;
        return type;
    }

    public void onUsingTick(ItemStack is, EntityPlayer ep, int count) {
        count = this.func_77626_a(is) - count;
        count = MathHelper.func_76125_a((int)count, (int)0, (int)50);
        if (!ep.field_70170_p.field_72995_K) {
            ChromaSounds.USE.playSound((Entity)ep, 0.25f + 2.0f * (float)count / 50.0f, MathHelper.func_76131_a((float)0.5f, (float)(2.0f * (float)count / 50.0f), (float)2.0f));
        }
    }

    public boolean func_77636_d(ItemStack is) {
        return (double)((float)ToolChargingSystem.instance.getCharge(is) / (float)this.getMaxCharge()) > 0.8;
    }

    @Override
    public CrystalElement getColor(ItemStack is) {
        return CrystalElement.BLUE;
    }

    @Override
    public int getMaxCharge() {
        return 12000;
    }

    @Override
    public int getChargeStates() {
        return 4;
    }

    @Override
    public int getChargeState(float frac) {
        return frac >= (float)Inspections.getMostExpensiveOperation().energyCost / (float)this.getMaxCharge() ? Math.max(1, super.getChargeState(frac)) : 0;
    }

    @Override
    public boolean isActivated(EntityPlayer e, ItemStack is, boolean held) {
        return ToolChargingSystem.instance.getCharge(is) >= this.getRequiredCharge(is);
    }

    private int getRequiredCharge(ItemStack is) {
        return Inspections.list[this.getActionType((ItemStack)is)].energyCost;
    }

    @Override
    public int getChargeConsumptionRate(EntityPlayer e, World world, ItemStack is) {
        return 0;
    }

    @Override
    protected boolean doTick(ItemStack is, World world, EntityPlayer e, boolean held) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderExtraIcons(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY && GuiScreen.func_146271_m()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            GL11.glDisable((int)2896);
            double sc = 1.0;
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            GL11.glTranslated((double)(0.5 / sc), (double)(-0.5 / sc), (double)0.0);
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
            int d = 1 + this.getActionType(is);
            if (d == 1 && System.currentTimeMillis() / 500L % 2L == 0L) {
                d = 0;
            }
            double u = 0.0625 * (double)d;
            double v = 0.125;
            double s = 0.0625;
            Tessellator v5 = Tessellator.field_78398_a;
            double z = 50.0;
            v5.func_78382_b();
            v5.func_78374_a(0.0, 0.0, z, u, v + s);
            v5.func_78374_a(1.0, 0.0, z, u + s, v + s);
            v5.func_78374_a(1.0, 1.0, z, u + s, v);
            v5.func_78374_a(0.0, 1.0, z, u, v);
            v5.func_78381_a();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    @Override
    public String getNotes(int subpage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Action Types:\n");
        for (Inspections i : Inspections.list) {
            sb.append("  ");
            sb.append(i.displayName());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append(super.getNotes(subpage));
        return sb.toString();
    }

    private static enum Inspections {
        REPEATER_CONNECTIVITY(60, CrystalReceiver.class),
        STRUCTURE_CHECK(1000, MultiBlockChromaTile.class),
        MULTIBLOCK(1500, BlockMultiBlock.class);

        public final int energyCost;
        private final Class trigger;
        private static final Inspections[] list;

        private Inspections(int energy, Class check) {
            this.energyCost = energy;
            this.trigger = check;
        }

        private boolean doEffect(World world, int x, int y, int z, int s, EntityPlayer ep, ItemStack is) {
            switch (this) {
                case REPEATER_CONNECTIVITY: {
                    for (CrystalElement e : CrystalElement.elements) {
                        CrystalReceiver te = (CrystalReceiver)world.func_147438_o(x, y, z);
                        boolean can = te.isConductingElement(e);
                        boolean flag = can && CrystalNetworker.instance.checkConnectivity(e, te);
                        ProbeInfoOverlayRenderer.instance.markConnectivity(ep, e, flag, can);
                    }
                    return true;
                }
                case STRUCTURE_CHECK: {
                    ChromaStructures str;
                    MultiBlockChromaTile te = (MultiBlockChromaTile)world.func_147438_o(x, y, z);
                    if (te.canStructureBeInspected() && (str = te.getPrimaryStructure()) != null) {
                        FilledBlockArray arr;
                        Coordinate c = te.getStructureOffset();
                        if (c == null) {
                            c = new Coordinate(0, 0, 0);
                        }
                        str.getStructure().resetToDefaults();
                        switch (str) {
                            case RITUAL: {
                                ((RitualStructure)str.getStructure()).initializeEnhance(true, false);
                                break;
                            }
                        }
                        CrystalElement e = str.requiresColor ? ((ColoredMultiBlockChromaTile)te).getColor() : null;
                        FilledBlockArray filledBlockArray = arr = str.requiresColor ? str.getArray(world, x, y, z, e) : str.getArray(world, x + c.xCoord, y + c.yCoord, z + c.zCoord);
                        if (!arr.matchInWorld((FilledBlockArray.BlockMatchFailCallback)StructureErrorOverlays.instance)) {
                            // empty if block
                        }
                        return true;
                    }
                    return false;
                }
                case MULTIBLOCK: {
                    BlockMultiBlock b = (BlockMultiBlock)world.func_147439_a(x, y, z);
                    b.checkForFullMultiBlock(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[s].getOpposite(), (FilledBlockArray.BlockMatchFailCallback)StructureErrorOverlays.instance);
                    return true;
                }
            }
            return false;
        }

        public String displayName() {
            return WordUtils.capitalize((String)this.name(), (char[])new char[]{' ', '_'});
        }

        private boolean isValid(World world, int x, int y, int z) {
            Block b = world.func_147439_a(x, y, z);
            if (this.trigger.isAssignableFrom(b.getClass())) {
                return true;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            return te != null && this.trigger.isAssignableFrom(te.getClass());
        }

        public static Inspections getMostExpensiveOperation() {
            Inspections ret = null;
            for (Inspections i : Inspections.values()) {
                if (ret != null && ret.energyCost >= i.energyCost) continue;
                ret = i;
            }
            return ret;
        }

        static {
            list = Inspections.values();
        }
    }
}

