/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Powered;

import Reika.ChromatiCraft.API.Interfaces.EnchantableItem;
import Reika.ChromatiCraft.API.Interfaces.OrePings;
import Reika.ChromatiCraft.Auxiliary.Render.OreOverlayRenderer;
import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Interfaces.Item.ToolSprite;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemOrePick
extends ItemPoweredChromaTool
implements ToolSprite,
EnchantableItem {
    private static final float SONAR_COST = 0.025f;
    private static final float SCAN_COST = 0.0015f;
    private static final int CHARGE_TIME = 30;

    public ItemOrePick(int index) {
        super(index);
        this.func_77656_e(720);
    }

    @Override
    protected boolean doTick(ItemStack is, World world, EntityPlayer ep, boolean held) {
        OrePings.OrePingDelegate type = null;
        float r = 8.0f;
        float i = 0.0f;
        while (i <= r) {
            DecimalPosition xyz = ReikaVectorHelper.getPlayerLookCoords((EntityPlayer)ep, (double)i);
            OrePings.OrePingDelegate at = this.getOreType(world, MathHelper.func_76128_c((double)xyz.xCoord), MathHelper.func_76128_c((double)xyz.yCoord), MathHelper.func_76128_c((double)xyz.zCoord));
            if (at != null) {
                type = at;
                break;
            }
            i = (float)((double)i + 0.2);
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_82580_o("oreType");
        is.field_77990_d.func_74757_a("ore", type != null);
        if (type != null) {
            NBTTagCompound tag = new NBTTagCompound();
            type.getPrimary().func_77955_b(tag);
            is.field_77990_d.func_74782_a("oreType", (NBTBase)tag);
        }
        return ep instanceof EntityPlayerMP && !ReikaPlayerAPI.isMiningWith((EntityPlayerMP)((EntityPlayerMP)ep), (ItemStack)is);
    }

    public void onUsingTick(ItemStack is, EntityPlayer ep, int count) {
        count = this.func_77626_a(is) - count;
        count = MathHelper.func_76125_a((int)count, (int)0, (int)30);
        if (!ep.field_70170_p.field_72995_K && count > 1) {
            ChromaSounds.NETWORKOPTCHARGE.playSound((Entity)ep, 0.25f + 2.0f * (float)count / 30.0f, MathHelper.func_76131_a((float)0.5f, (float)(2.0f * (float)count / 30.0f), (float)2.0f));
        }
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 7200;
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (!this.handleUseAllowance(ep) && this.isActivated(ep, is, true)) {
            ep.func_71008_a(is, this.func_77626_a(is));
        }
        return is;
    }

    public void func_77615_a(ItemStack is, World world, EntityPlayer ep, int count) {
        count = MathHelper.func_76125_a((int)(this.func_77626_a(is) - count), (int)0, (int)30);
        if (count >= 30 && (float)ToolChargingSystem.instance.getCharge(is) >= 0.025f) {
            this.fire(is, world, ep);
        } else if (count > 5) {
            ChromaSounds.ERROR.playSound((Entity)ep);
        }
        ep.func_71008_a(null, 0);
    }

    private void fire(ItemStack is, World world, EntityPlayer ep) {
        if (!world.field_72995_K) {
            ToolChargingSystem.instance.removeCharge(is, (int)(0.025f * (float)this.getMaxCharge()), ep);
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int y = MathHelper.func_76128_c((double)ep.field_70163_u);
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            OreOverlayRenderer.instance.startPing(world, x, y, z, ep);
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if ((float)ToolChargingSystem.instance.getCharge(is) < 0.0015f) {
            return false;
        }
        OrePings.OrePingDelegate ore = this.getOreType(world, x, y, z);
        if (ore != null) {
            if (!world.field_72995_K) {
                ToolChargingSystem.instance.removeCharge(is, (int)(0.0015f * (float)this.getMaxCharge()), ep);
                OreOverlayRenderer.instance.startScan(world, x, y, z, ep);
            }
            return true;
        }
        return false;
    }

    private OrePings.OrePingDelegate getOreType(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return OreOverlayRenderer.instance.getForBlock(id, meta);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return toolClass.toLowerCase(Locale.ENGLISH).contains("pick") ? 2 : super.getHarvestLevel(stack, toolClass);
    }

    public boolean canHarvestBlock(Block b, ItemStack is) {
        return Items.field_151035_b.canHarvestBlock(b, is);
    }

    public final IIcon func_77617_a(int dmg) {
        return Items.field_151050_s.func_77617_a(0);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) ? 4.0f : super.getDigSpeed(stack, block, meta);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        set.add("pickaxe");
        set.add("pickax");
        return set;
    }

    public boolean func_150894_a(ItemStack is, World world, Block b, int x, int y, int z, EntityLivingBase elb) {
        if (b.func_149712_f(world, x, y, z) > 0.0f) {
            is.func_77972_a(1, elb);
            ToolChargingSystem.instance.addCharge(is, this.getMaxCharge() * 4 / this.func_77612_l());
        }
        return true;
    }

    @Override
    public CrystalElement getColor(ItemStack is) {
        return CrystalElement.BROWN;
    }

    @Override
    public int getMaxCharge() {
        return 180000;
    }

    @Override
    public int getChargeStates() {
        return 1;
    }

    @Override
    public boolean hasChargeStates() {
        return false;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        int base = super.getItemSpriteIndex(item) - item.func_77960_j();
        if (item.field_77990_d != null && item.field_77990_d.func_74767_n("ore")) {
            ++base;
        }
        return base;
    }

    @Override
    public boolean isActivated(EntityPlayer e, ItemStack is, boolean held) {
        return held;
    }

    @Override
    public int getChargeConsumptionRate(EntityPlayer e, World world, ItemStack is) {
        return is.field_77990_d.func_74767_n("ore") ? 8 : 1;
    }

    @Override
    public Event.Result getEnchantValidity(Enchantment e, ItemStack is) {
        return e == Enchantment.field_77347_r || e == Enchantment.field_77349_p || e == Enchantment.field_77346_s || e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound") ? Event.Result.ALLOW : Event.Result.DENY;
    }

    public EnumEnchantmentType getEnchantingCategory() {
        return EnumEnchantmentType.digger;
    }
}

