/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Powered;

import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Instantiable.ParticleController.OrbitMotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemPurifyCrystal
extends ItemPoweredChromaTool {
    private static final String TAG = "last_purify";
    public static final int CHARGE_STATES = 4;
    public static final int MAX_CHARGE = 2592000;

    public ItemPurifyCrystal(int index) {
        super(index);
    }

    @Override
    public boolean doTick(ItemStack is, World world, EntityPlayer e, boolean held) {
        e.getEntityData().func_74772_a(TAG, world.func_82737_E());
        if (world.field_72995_K) {
            this.doHeldFX(is, (Entity)e);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void doHeldFX(ItemStack is, Entity e) {
        if (field_77697_d.nextInt(8) == 0) {
            double r = 2.5;
            double ec = 0.0;
            double i = e.field_70173_aa * 4;
            double raan = 0.0;
            Orbit o = new Orbit(r, ec, i, raan, 0.0, 0.0);
            OrbitMotionController p = new OrbitMotionController(o, e.field_70165_t, e.field_70163_u, e.field_70161_v).trackEntity(e);
            p.thetaSpeed = ReikaRandomHelper.getRandomBetween((double)1.5, (double)5.0);
            int l = 60 + field_77697_d.nextInt(120);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25);
            EntityBlurFX fx = new EntityCCBlurFX(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v).setIcon(ChromaIcons.CENTER).setPositionController((PositionController)p).setLife(l).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static boolean isActive(EntityPlayer ep) {
        return ep.field_70170_p.func_82737_E() - ep.getEntityData().func_74763_f(TAG) < 20L;
    }

    @Override
    public boolean isActivated(EntityPlayer e, ItemStack is, boolean held) {
        return true;
    }

    @Override
    public CrystalElement getColor(ItemStack is) {
        return CrystalElement.WHITE;
    }

    @Override
    public int getMaxCharge() {
        return 2592000;
    }

    @Override
    public int getChargeStates() {
        return 4;
    }

    @Override
    public int getChargeConsumptionRate(EntityPlayer e, World world, ItemStack is) {
        return CrystalPotionController.instance.isWorldHostile(world) ? 12 : 1;
    }
}

