/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Powered;

import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.Formula.PeriodicExpression;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.FlashColorController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemStructureFinder
extends ItemPoweredChromaTool {
    private static final double RANGE = 512.0;
    private static final double FUZZ = 96.0;
    private static ChromaStructures[] TYPES;
    private static final int[] COLORS;
    private static final Random rand;

    public static int getColor(ChromaStructures s) {
        return COLORS[s.ordinal()];
    }

    public ItemStructureFinder(int index) {
        super(index);
    }

    @Override
    public boolean doTick(ItemStack is, World world, EntityPlayer e, boolean held) {
        if (!world.field_72995_K) {
            DungeonGenerator.StructureSeekData loc;
            boolean debug;
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            int type = this.getStructureType(is);
            if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
                this.sendParticle(e, e.field_70165_t, -50.0, e.field_70161_v, TYPES[type], false, true);
                return false;
            }
            ChromaStructures s = TYPES[type];
            double r = 512.0 * this.getSightRangeModifier(s);
            boolean bl = debug = ReikaObfuscationHelper.isDeObfEnvironment() && KeyWatcher.instance.isKeyDown(e, KeyWatcher.Key.LCTRL) && ReikaPlayerAPI.isReika((EntityPlayer)e);
            if (debug) {
                r = 5000.0;
            }
            if ((loc = DungeonGenerator.instance.getNearestRealStructure(s, (WorldServer)world, e.field_70165_t, e.field_70161_v, r, false)) != null) {
                double fz;
                double dist = loc.location.getDistanceTo((Entity)e);
                double d = fz = debug ? 0.0 : 96.0;
                if (dist <= fz) {
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)fz);
                    double py = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70163_u, (double)fz);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)fz);
                    this.sendParticle(e, px, py, pz, TYPES[type], true, loc.isKnownSuccess);
                } else {
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)loc.location.xCoord + 0.5), (double)fz);
                    double py = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70163_u, (double)fz);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)loc.location.zCoord + 0.5), (double)fz);
                    this.sendParticle(e, px, py, pz, TYPES[type], false, loc.isKnownSuccess);
                }
            }
        }
        return true;
    }

    private double getSightRangeModifier(ChromaStructures s) {
        switch (s) {
            case OCEAN: 
            case BIOMEFRAG: {
                return 2.0;
            }
        }
        return 1.0;
    }

    private void sendParticle(EntityPlayer ep, double sx, double sy, double sz, ChromaStructures s, boolean close, boolean genned) {
        if (ep instanceof EntityPlayerMP) {
            PacketTarget.PlayerTarget pt = new PacketTarget.PlayerTarget((EntityPlayerMP)ep);
            ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.STRUCTFIND.ordinal(), (World)ep.field_70170_p, (double)sx, (double)sy, (double)sz, (PacketTarget)pt, (int[])new int[]{s.ordinal(), close ? 1 : 0, genned ? 1 : 0});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doHeldFX(EntityPlayer ep, double sx, double sy, double sz, ChromaStructures s, boolean close, boolean genned) {
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.0625, (double)(-ep.field_70125_A), (double)(ep.field_70759_as + 90.0f + 60.0f));
        double px = ep.field_70165_t + xyz[0];
        double py = ep.field_70163_u + xyz[1];
        double pz = ep.field_70161_v + xyz[2];
        double dx = sx - px;
        double dy = sy - py;
        double dz = sz - pz;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 0.015625;
        float sc = 0.125f + rand.nextFloat() * 0.25f;
        int l = 10;
        int c = COLORS[s.ordinal()];
        if (!genned) {
            if (ep.func_70681_au().nextInt(3) == 0) {
                return;
            }
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)0.5f);
            l = 15;
            sc = (float)((double)sc * 1.25);
            v *= 0.67;
        }
        double vx = dx / dd * v;
        double vy = dy / dd * v;
        double vz = dz / dd * v;
        EntityCCBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, px, py, pz, vx, vy, vz);
        if (close) {
            l *= 2;
            sc = (float)((double)sc * 0.5);
            fx.setIcon(ChromaIcons.FADE_RAY);
            double d = rand.nextDouble() * 360.0;
            PeriodicExpression e = new PeriodicExpression().addWave(0.5, 16.0, d).normalize();
            fx.setColorController((ColorController)new FlashColorController((MathExpression)e, c, 0xFFFFFF));
            fx.field_70159_w *= 0.375;
            fx.field_70181_x *= 0.375;
            fx.field_70179_y *= 0.375;
        }
        if (!genned && !close) {
            fx.setIcon(ChromaIcons.FADE_GENTLE);
        }
        fx.setLife(l).setScale(sc).setColor(c);
        if (sy == -50.0) {
            fx.setLife(40 + rand.nextInt(21));
            fx.setColliding();
            fx.field_70181_x *= 0.7;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private int getStructureType(ItemStack is) {
        if (TYPES == null) {
            TYPES = DungeonGenerator.instance.getStructureTypes().toArray(new ChromaStructures[DungeonGenerator.instance.getStructureTypes().size()]);
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        int type = is.field_77990_d != null ? is.field_77990_d.func_74762_e("type") : 0;
        return type;
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        super.func_77624_a(is, ep, li, vb);
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            int type = this.getStructureType(is);
            li.add(String.format("Type: " + (Object)((Object)TYPES[type]), new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        int type = this.getStructureType(is);
        type = (type + 1) % TYPES.length;
        is.field_77990_d.func_74768_a("type", type);
        return is;
    }

    @Override
    protected boolean isActivated(EntityPlayer e, ItemStack is, boolean held) {
        return held;
    }

    @Override
    public CrystalElement getColor(ItemStack is) {
        return CrystalElement.BLACK;
    }

    @Override
    public int getMaxCharge() {
        return 36000;
    }

    @Override
    public int getChargeStates() {
        return 2;
    }

    @Override
    public int getChargeState(float frac) {
        return (double)frac > 0.1 ? 1 : 0;
    }

    @Override
    public int getChargeConsumptionRate(EntityPlayer e, World world, ItemStack is) {
        return 1;
    }

    static {
        COLORS = new int[ChromaStructures.structureList.length];
        ItemStructureFinder.COLORS[ChromaStructures.BURROW.ordinal()] = 7976835;
        ItemStructureFinder.COLORS[ChromaStructures.CAVERN.ordinal()] = 9413557;
        ItemStructureFinder.COLORS[ChromaStructures.OCEAN.ordinal()] = 6341828;
        ItemStructureFinder.COLORS[ChromaStructures.DESERT.ordinal()] = 12543325;
        ItemStructureFinder.COLORS[ChromaStructures.SNOWSTRUCT.ordinal()] = 15749312;
        ItemStructureFinder.COLORS[ChromaStructures.BIOMEFRAG.ordinal()] = 0x22AAFF;
        rand = new Random();
    }
}

