/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemBlockChangingWand;
import Reika.ChromatiCraft.Block.Decoration.BlockEtherealLight;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.PlayerReference;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.GeoStrata.Registry.GeoBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemExcavationWand
extends ItemBlockChangingWand {
    private static final int MAX_DEPTH = 12;
    private static final int MAX_DEPTH_BOOST = 18;
    private static final HashMap<Integer, PlayerReference> breakers = new HashMap();

    public ItemExcavationWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.YELLOW, 2);
    }

    public float getDigSpeed(ItemStack is, Block b, int meta) {
        return 5.0f;
    }

    public boolean canHarvestBlock(Block b, ItemStack is) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean canSpreadOn(World world, int x, int y, int z, Block b, int meta) {
        if (world.field_73011_w.func_76569_d() && b == Blocks.field_150348_b) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && b == Blocks.field_150424_aL) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == 1 && (b == Blocks.field_150377_bs || b == Blocks.field_150343_Z)) {
            return false;
        }
        if (b == ChromaBlocks.BEDROCKCRACK.getBlockInstance()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return !(te instanceof CrystalNetworkTile) && !(te instanceof TileEntityStructControl);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer ep) {
        World world = ep.field_70170_p;
        if (!this.canSpreadOn(world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z))) {
            return false;
        }
        if (!world.field_72995_K) {
            ProgressiveRecursiveBreaker.ProgressiveBreaker b = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, this.getDepth(ep));
            b.call = this;
            b.silkTouch = ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77348_q, (ItemStack)itemstack) > 0;
            b.drops = !ep.field_71075_bZ.field_75098_d;
            b.fortune = ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)itemstack);
            if (ep.func_70093_af()) {
                b.extraSpread = true;
            }
            if (ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)ChromaEnchants.AUTOCOLLECT.getEnchantment(), (ItemStack)itemstack) > 0) {
                b.dropInventory = ep.field_71071_by;
            }
            b.taxiCabDistance = true;
            b.player = ep;
            b.hungerFactor = 0.125f;
            HashSet<BlockKey> set = this.getSpreadBlocks(world, x, y, z);
            for (BlockKey bk : set) {
                b.addBlock(bk);
            }
            breakers.put(b.hashCode(), new PlayerReference(ep));
        }
        return true;
    }

    private HashSet<BlockKey> getSpreadBlocks(World world, int x, int y, int z) {
        int meta;
        ModWoodList mod;
        int meta2;
        Iterator iterator;
        int i;
        HashSet<BlockKey> set = new HashSet<BlockKey>();
        Block bk = world.func_147439_a(x, y, z);
        set.add(new BlockKey(bk, world.func_72805_g(x, y, z)));
        if (bk == Blocks.field_150439_ay) {
            set.add(new BlockKey(Blocks.field_150450_ax));
        } else if (bk == Blocks.field_150450_ax) {
            set.add(new BlockKey(Blocks.field_150439_ay));
        } else if (bk instanceof BlockStairs) {
            for (i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        } else if (bk == ChromaBlocks.GLOWLEAF.getBlockInstance()) {
            for (i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        } else if (ModList.GEOSTRATA.isLoaded() && bk == GeoBlocks.LAVAROCK.getBlockInstance()) {
            for (i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        } else if (bk == TwilightForestHandler.BlockEntry.NAGASTONE.getBlock()) {
            for (i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        } else if (bk == TwilightForestHandler.BlockEntry.AURORA.getBlock()) {
            for (i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        }
        ReikaTreeHelper tree = ReikaTreeHelper.getTree((Block)bk, (int)world.func_72805_g(x, y, z));
        if (tree != null) {
            iterator = tree.getLogMetadatas().iterator();
            while (iterator.hasNext()) {
                meta2 = (Integer)iterator.next();
                set.add(new BlockKey(bk, meta2));
            }
        }
        if ((tree = ReikaTreeHelper.getTreeFromLeaf((Block)bk, (int)world.func_72805_g(x, y, z))) != null) {
            iterator = tree.getLeafMetadatas().iterator();
            while (iterator.hasNext()) {
                meta2 = (Integer)iterator.next();
                set.add(new BlockKey(bk, meta2));
            }
        }
        if ((mod = ModWoodList.getModWood((Block)bk, (int)world.func_72805_g(x, y, z))) != null) {
            Iterator iterator2 = mod.getLogMetadatas().iterator();
            while (iterator2.hasNext()) {
                meta = (Integer)iterator2.next();
                set.add(new BlockKey(bk, meta));
            }
        }
        if ((mod = ModWoodList.getModWoodFromLeaf((Block)bk, (int)world.func_72805_g(x, y, z))) != null) {
            Iterator iterator3 = mod.getLeafMetadatas().iterator();
            while (iterator3.hasNext()) {
                meta = (Integer)iterator3.next();
                set.add(new BlockKey(bk, meta));
            }
        }
        return set;
    }

    @Override
    public int getDepth(EntityPlayer ep) {
        return ItemExcavationWand.canUseBoostedEffect(ep) ? 18 : 12;
    }

    public void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
    }

    public void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        PlayerReference p = breakers.get(b.hashCode());
        if (p != null) {
            EntityPlayer ep = p.getPlayer(world);
            if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77343_v, (ItemStack)p.getHeldItem())) {
                this.placeSomeLight(world, x, y, z);
            }
            if (ep != null) {
                this.drainPlayer(ep);
            } else {
                b.terminate();
            }
        }
    }

    private void placeSomeLight(World world, int x, int y, int z) {
        if (world.func_72957_l(x, y, z) < 8 && !world.func_72937_j(x, y, z)) {
            world.func_147465_d(x, y, z, ChromaBlocks.LIGHT.getBlockInstance(), BlockEtherealLight.Flags.PARTICLES.getFlag(), 3);
        }
    }

    public boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        EntityPlayer ep;
        PlayerReference p = breakers.get(b.hashCode());
        if (p != null && (ep = p.getPlayer(world)) != null) {
            return this.sufficientEnergy(ep) && this.canBreakBlock(world, x, y, z, id, meta, ep);
        }
        return false;
    }

    private boolean canBreakBlock(World world, int x, int y, int z, Block id, int meta, EntityPlayer ep) {
        return (world.field_72995_K || ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)ep))) && this.canSpreadOn(world, x, y, z, id, meta);
    }

    public void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        breakers.remove(b.hashCode());
    }

    @Override
    public void getSpreadBlocks(World world, int x, int y, int z, BlockArray arr, EntityPlayer ep, ItemStack is) {
        HashSet<BlockKey> set = this.getSpreadBlocks(world, x, y, z);
        if (ep.func_70093_af()) {
            arr.extraSpread = true;
        }
        arr.taxiCabDistance = true;
        arr.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
    }
}

