/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Base.ItemBlockChangingWand;
import Reika.ChromatiCraft.Block.BlockCrystalTank;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemInventoryLinker;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModInteract.ReikaChiselHandler;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemTransitionWand
extends ItemBlockChangingWand {
    private static HashMap<Integer, BlockReplace> breakers = new HashMap();
    private static final int MAX_DEPTH = 18;
    private static final int MAX_DEPTH_BOOST = 24;

    public ItemTransitionWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.GRAY, 2);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            is.field_77990_d.func_82580_o("bbox");
        } else {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TRANSITION.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if (!world.field_72995_K) {
            if (ep.func_70093_af()) {
                this.setStoredItem(is, this.parseItemStack(world, x, y, z));
            } else {
                ItemStack store = this.getStoredItem(is);
                if (store == null) {
                    return false;
                }
                Block id = Block.func_149634_a((Item)store.func_77973_b());
                int meta = store.func_77960_j();
                if (id == null || id == Blocks.field_150350_a) {
                    return false;
                }
                TransitionMode mode = this.getMode(is);
                if (id == world.func_147439_a(x, y, z) && meta == world.func_72805_g(x, y, z) && mode != TransitionMode.VOLUMETRIC) {
                    return false;
                }
                if (mode == TransitionMode.VOLUMETRIC && !this.setOrGetBlockBox(is, x, y, z)) {
                    return false;
                }
                int depth = mode == TransitionMode.VOLUMETRIC || mode == TransitionMode.COLUMN ? Integer.MAX_VALUE : this.getDepth(ep);
                ProgressiveRecursiveBreaker.ProgressiveBreaker br = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, depth);
                br.call = this;
                br.drops = false;
                br.extraSpread = false;
                br.player = ep;
                br.silkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)ep);
                BlockReplace brp = new BlockReplace(ep, id, meta, mode);
                brp.silkTouch = br.silkTouch;
                br.causeUpdates = false;
                if (mode == TransitionMode.VOLUMETRIC) {
                    br.bounds = this.getStoredBox(is);
                    br.isOmni = true;
                    br.pathTracking = true;
                }
                if (mode == TransitionMode.COLUMN) {
                    br.bounds = new BlockBox(x, 0, z, x, 256, z);
                }
                is.field_77990_d.func_82580_o("bbox");
                breakers.put(br.hashCode(), brp);
            }
        }
        return true;
    }

    @Override
    public boolean canSpreadOn(World world, int x, int y, int z, Block b, int meta) {
        return true;
    }

    private ItemStack parseItemStack(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b instanceof BlockLeaves) {
            meta &= 3;
        } else if (b == ChromaBlocks.TANK.getBlockInstance()) {
            meta -= meta % 2;
        }
        return new ItemStack(b, 1, meta);
    }

    @Override
    public int getDepth(EntityPlayer ep) {
        return ItemTransitionWand.canUseBoostedEffect(ep) ? 24 : 18;
    }

    private boolean setOrGetBlockBox(ItemStack is, int x, int y, int z) {
        BlockBox bb = this.getStoredBox(is);
        if (bb == null) {
            NBTTagCompound tag;
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            if ((tag = is.field_77990_d.func_74775_l("bbox")).func_82582_d()) {
                tag.func_74768_a("minx", x);
                tag.func_74768_a("miny", y);
                tag.func_74768_a("minz", z);
            } else {
                tag.func_74768_a("maxx", x);
                tag.func_74768_a("maxy", y);
                tag.func_74768_a("maxz", z);
            }
            is.field_77990_d.func_74782_a("bbox", (NBTBase)tag);
        }
        return (bb = this.getStoredBox(is)) != null;
    }

    private BlockBox getStoredBox(ItemStack is) {
        NBTTagCompound tag;
        if (is.field_77990_d != null && (tag = is.field_77990_d.func_74775_l("bbox")).func_150296_c().size() == 6) {
            return BlockBox.readFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public ItemStack getStoredItem(ItemStack tool) {
        if (tool.field_77990_d != null) {
            NBTTagCompound tag = tool.field_77990_d.func_74775_l("stored");
            ItemStack ret = ItemStack.func_77949_a((NBTTagCompound)tag);
            return ret;
        }
        return null;
    }

    public void setStoredItem(ItemStack tool, ItemStack tostore) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tostore.func_77955_b(tag);
        tool.field_77990_d.func_74782_a("stored", (NBTBase)tag);
    }

    public void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists) {
                ItemStack is;
                BlockCrystalTank.CrystalTankAuxTile te;
                TileEntityCrystalTank con;
                if (this.isUpgradingTank(world, x, y, z, id, meta, r) && (con = (te = (BlockCrystalTank.CrystalTankAuxTile)world.func_147438_o(x, y, z)).getTankController()) != null) {
                    con.pauseCapacityUpdate();
                }
                ArrayList li = id.getDrops(world, x, y, z, meta, 0);
                if (r.silkTouch && (is = ReikaBlockHelper.getSilkTouch((World)world, (int)x, (int)y, (int)z, (Block)id, (int)meta, (EntityPlayer)r.player, (boolean)true)) != null) {
                    li.clear();
                    li.add(is);
                }
                for (ItemStack is2 : li) {
                    r.drops.add(is2);
                }
            } else {
                b.terminate();
            }
        }
    }

    public void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists) {
                int ret;
                BlockCrystalTank.CrystalTankAuxTile te;
                TileEntityCrystalTank con;
                world.func_147465_d(x, y, z, r.place, r.placeM, 3);
                ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)r.place);
                if (this.isUpgradingTank(world, x, y, z, id, meta, r) && (con = (te = (BlockCrystalTank.CrystalTankAuxTile)world.func_147438_o(x, y, z)).getTankController()) != null) {
                    con.unpauseCapacityUpdate();
                }
                this.drainPlayer(r.player);
                if (!((BlockReplace)r).player.field_71075_bZ.field_75098_d && !ReikaPlayerAPI.findAndDecrItem((EntityPlayer)r.player, (Block)r.place, (int)r.placeM) && ModList.CHISEL.isLoaded() && (ret = ReikaChiselHandler.getChiselableSource((IInventory)((BlockReplace)r).player.field_71071_by, (Block)r.place, (int)r.placeM)) != -1) {
                    ReikaInventoryHelper.decrStack((int)ret, (IInventory)((BlockReplace)r).player.field_71071_by, (int)1);
                }
            } else {
                b.terminate();
            }
        }
    }

    public boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (!(world.func_147438_o(x, y, z) == null || this.isUpgradingTank(world, x, y, z, id, meta, r) || ModList.TINKERER.isLoaded() && TinkerBlockHandler.getInstance().isSmelteryBlock(id))) {
            return false;
        }
        if (!((BlockReplace)r).player.field_71075_bZ.field_75098_d) {
            if (ReikaBlockHelper.isUnbreakable((World)world, (int)x, (int)y, (int)z, (Block)id, (int)meta, (EntityPlayer)r.player)) {
                return false;
            }
            if (id instanceof SemiUnbreakable && ((SemiUnbreakable)id).isUnbreakable(world, x, y, z, meta)) {
                return false;
            }
        }
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists && this.sufficientEnergy(r.player) && this.playerHas(r.player, r.place, r.placeM)) {
                boolean perm = world.field_72995_K || ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)r.player));
                switch (r.mode) {
                    case CONTIGUOUS: {
                        return perm;
                    }
                    case AIRONLY: {
                        return perm && ReikaWorldHelper.checkForAdjNonCube((World)world, (int)x, (int)y, (int)z) != null;
                    }
                    case VOLUMETRIC: {
                        return perm;
                    }
                    case COLUMN: {
                        return perm;
                    }
                }
            }
        }
        return false;
    }

    private boolean isUpgradingTank(World world, int x, int y, int z, Block id, int meta, BlockReplace r) {
        return id == ChromaBlocks.TANK.getBlockInstance() && r != null && r.place == id && id.func_149692_a(meta) != id.func_149692_a(r.placeM);
    }

    private boolean playerHas(EntityPlayer ep, Block b, int m) {
        int ret;
        if (ReikaPlayerAPI.playerHasOrIsCreative((EntityPlayer)ep, (Block)b, (int)m)) {
            return true;
        }
        return ModList.CHISEL.isLoaded() && (ret = ReikaChiselHandler.getChiselableSource((IInventory)ep.field_71071_by, (Block)b, (int)m)) != -1;
    }

    public void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        BlockReplace r = breakers.get(b.hashCode());
        EntityPlayer ep = r.player;
        if (!ep.field_71075_bZ.field_75098_d) {
            for (ItemStack is : r.drops) {
                int added;
                if (ItemInventoryLinker.tryLinkItem(ep, is)) continue;
                if (Chromabilities.MEINV.enabledOn(ep) && (added = AbilityHelper.instance.addStackToMESystem(ep, is)) > 0) {
                    if (added >= is.field_77994_a) continue;
                    is.field_77994_a -= added;
                }
                ReikaPlayerAPI.addOrDropItem((ItemStack)is, (EntityPlayer)ep);
            }
        }
        breakers.remove(b.hashCode());
    }

    public void setMode(ItemStack is, TransitionMode mode) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    public TransitionMode getMode(ItemStack is) {
        if (is.field_77990_d != null) {
            int idx = is.field_77990_d.func_74762_e("mode");
            return TransitionMode.list[idx];
        }
        return TransitionMode.CONTIGUOUS;
    }

    @Override
    public void getSpreadBlocks(World world, int x, int y, int z, BlockArray arr, EntityPlayer ep, ItemStack is) {
        final BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z);
        switch (this.getMode(is)) {
            case CONTIGUOUS: {
                arr.recursiveAddWithBoundsMetadata((IBlockAccess)world, x, y, z, bk.blockID, bk.metadata, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
                break;
            }
            case AIRONLY: {
                AbstractSearch.PropagationCondition pc = new AbstractSearch.PropagationCondition(){

                    public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
                        return bk.matchInWorld(world, x, y, z) && ReikaWorldHelper.isExposedToAir((World)world, (int)x, (int)y, (int)z);
                    }
                };
                arr.recursiveAddCallbackWithBounds(world, x, y, z, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32, pc);
                break;
            }
            case VOLUMETRIC: {
                NBTTagCompound tag;
                BlockBox box = this.getStoredBox(is);
                if (box == null && is.field_77990_d != null && (tag = is.field_77990_d.func_74775_l("bbox")).func_150296_c().size() == 3) {
                    int x0 = tag.func_74762_e("minx");
                    int y0 = tag.func_74762_e("miny");
                    int z0 = tag.func_74762_e("minz");
                    box = new BlockBox(x0, y0, z0, x, y, z);
                }
                if (box == null) break;
                for (int dx = box.minX; dx <= box.maxX; ++dx) {
                    for (int dz = box.minZ; dz <= box.maxZ; ++dz) {
                        for (int dy = box.minY; dy <= box.maxY; ++dy) {
                            if (world.func_147439_a(dx, dy, dz) == Blocks.field_150350_a) continue;
                            arr.addBlockCoordinate(dx, dy, dz);
                        }
                    }
                }
                break;
            }
            case COLUMN: {
                arr.addBlockCoordinate(x, y, z);
                int d = 1;
                boolean flag = true;
                while (flag) {
                    flag = false;
                    if (bk.matchInWorld(world, x, y + d, z)) {
                        arr.addBlockCoordinate(x, y + d, z);
                        flag = true;
                    }
                    ++d;
                }
                d = 1;
                flag = true;
                while (flag) {
                    flag = false;
                    if (bk.matchInWorld(world, x, y - d, z)) {
                        arr.addBlockCoordinate(x, y - d, z);
                        flag = true;
                    }
                    ++d;
                }
                break;
            }
        }
    }

    public static enum TransitionMode {
        CONTIGUOUS("Contiguous"),
        AIRONLY("Exposed Contiguous"),
        VOLUMETRIC("Volumetric"),
        COLUMN("Columnar");

        public final String desc;
        public static final TransitionMode[] list;

        private TransitionMode(String s) {
            this.desc = s;
        }

        static {
            list = TransitionMode.values();
        }
    }

    private static class BlockReplace {
        private final EntityPlayer player;
        private final Block place;
        private final int placeM;
        private final TransitionMode mode;
        private ArrayList<ItemStack> drops = new ArrayList();
        private boolean silkTouch;

        private BlockReplace(EntityPlayer ep, Block b, int meta, TransitionMode m) {
            this.place = b;
            this.placeM = meta;
            this.player = ep;
            this.mode = m;
        }
    }
}

