/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Artefact;

import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.World.IWG.UnknownArtefactGenerator;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;

public class ArtefactSpawner
implements TickRegistry.TickHandler {
    private static final int SPAWN_DISTANCE = 32;
    private static final int DESPAWN_DISTANCE = 64;
    private static final int SPAWN_LIMIT = 3;
    private static final int FORCED_SPAWN_LIMIT = 20;
    private static final Random rand = new Random();
    private final ArrayList<SpawnedArtefact> artefacts = new ArrayList();
    public static final ArtefactSpawner instance = new ArtefactSpawner();

    private ArtefactSpawner() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        EntityPlayer pl = (EntityPlayer)tickData[0];
        if (pl.field_70170_p.field_72995_K) {
            return;
        }
        if (!UnknownArtefactGenerator.instance.canGenerateIn(pl.field_70170_p)) {
            this.artefacts.clear();
            return;
        }
        EntityPlayerMP ep = (EntityPlayerMP)pl;
        if (rand.nextInt(2) == 0 && this.canSpawnArtefactNearPlayer((EntityPlayer)ep)) {
            ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.PARTICLE.ordinal(), (World)ep.field_70170_p, (int)MathHelper.func_76128_c((double)ep.field_70165_t), (int)((int)ep.field_70163_u + 1), (int)MathHelper.func_76128_c((double)ep.field_70161_v), (PacketTarget)new PacketTarget.PlayerTarget(ep), (List)ReikaJavaLibrary.makeListFrom((Object[])new Integer[]{ReikaParticleHelper.PORTAL.ordinal(), 1}));
        }
        if (this.artefacts.size() < 3 && rand.nextInt(1000) == 0 && this.canSpawnArtefactNearPlayer((EntityPlayer)ep)) {
            double a = Math.toRadians(rand.nextDouble() * 360.0);
            double dx = ep.field_70165_t + 32.0 * Math.cos(a);
            double dz = ep.field_70161_v + 32.0 * Math.sin(a);
            this.addArtefact(dx, dz, (EntityPlayer)ep, Integer.MAX_VALUE);
        }
        if (!this.artefacts.isEmpty()) {
            Iterator<SpawnedArtefact> it = this.artefacts.iterator();
            while (it.hasNext()) {
                SpawnedArtefact a = it.next();
                if (!a.tick(ep)) continue;
                it.remove();
            }
        }
    }

    public void addArtefact(double dx, double dz, EntityPlayer ep, int life) {
        int z;
        int y;
        int x;
        if (this.artefacts.size() < 20 && UnknownArtefactGenerator.canGenerateArtefactAt(ep.field_70170_p, x = MathHelper.func_76128_c((double)dx), y = ep.field_70170_p.func_72825_h(x, z = MathHelper.func_76128_c((double)dz)) - 1, z)) {
            double dy = (double)y - 0.5;
            this.artefacts.add(new SpawnedArtefact(dx, dy, dz, ep, life));
        }
    }

    private boolean canSpawnArtefactNearPlayer(EntityPlayer ep) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        int cx = ReikaMathLibrary.roundDownToX((int)16, (int)MathHelper.func_76128_c((double)ep.field_70165_t));
        int cz = ReikaMathLibrary.roundDownToX((int)16, (int)MathHelper.func_76128_c((double)ep.field_70161_v));
        return UnknownArtefactGenerator.instance.isUAChunk(ep.field_70170_p, cx, cz);
    }

    public boolean isOnTopOfArtefact(World world, int x, int y, int z) {
        if (!this.artefacts.isEmpty()) {
            Iterator<SpawnedArtefact> it = this.artefacts.iterator();
            while (it.hasNext()) {
                SpawnedArtefact a = it.next();
                Coordinate c = a.position.getCoordinate();
                if (!c.equals(x, y - 1, z)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void checkPlayerBreak(BlockEvent.BreakEvent evt) {
        EntityPlayer ep = evt.getPlayer();
        if (ep instanceof EntityPlayerMP && !ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            int cx = ReikaMathLibrary.roundDownToX((int)16, (int)evt.x);
            int cz = ReikaMathLibrary.roundDownToX((int)16, (int)evt.z);
            if (this.isOnTopOfArtefact(evt.world, evt.x, evt.y, evt.z)) {
                this.confirmUA(evt.world, evt.x, evt.y, evt.z);
            }
        }
    }

    private void confirmUA(World world, int x, int y, int z) {
        world.func_147449_b(x, y - 1, z, ChromaBlocks.ARTEFACT.getBlockInstance());
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "UA Spawner";
    }

    public static class SpawnedArtefact {
        private final DecimalPosition position;
        private final UUID spawnedByPlayer;
        private final int maxLife;
        private int age;

        private SpawnedArtefact(double x, double y, double z, EntityPlayer ep) {
            this(x, y, z, ep, Integer.MAX_VALUE);
        }

        private SpawnedArtefact(double x, double y, double z, EntityPlayer ep, int l) {
            this.position = new DecimalPosition(x, y, z);
            this.spawnedByPlayer = ep.func_110124_au();
            this.maxLife = l;
        }

        private boolean tick(EntityPlayerMP ep) {
            ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.UAFX.ordinal(), (World)ep.field_70170_p, (double)this.position.xCoord, (double)this.position.yCoord, (double)this.position.zCoord, (PacketTarget)new PacketTarget.PlayerTarget(ep), (int[])new int[0]);
            ++this.age;
            return this.age >= this.maxLife || ep.func_110124_au().equals(this.spawnedByPlayer) && ep.func_70092_e(this.position.xCoord, this.position.yCoord, this.position.zCoord) >= 4096.0;
        }
    }
}

