/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Artefact;

import Reika.ChromatiCraft.Auxiliary.VillageTradeHandler;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.ASM.ASMCalls;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.PlayerSpecificTrade;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import org.apache.commons.codec.Charsets;

public class UATrades
implements ReikaFileReader.ConnectionErrorHandler {
    public static final int BASE_TRADE_YIELD = 48;
    public static final UATrades instance = new UATrades();
    private final HashMap<String, Integer> prices = new HashMap();
    private int MAX_PRICE = -1;
    private final HashMap<Class<? extends UATypeTrade>, Double> tradeList = new HashMap();
    private final MultiMap<String, EDCommodityHook> externalHooks = new MultiMap().setNullEmpty();

    private UATrades() {
    }

    public void loadData() {
        Throwable throwable;
        BufferedReader r;
        this.loadDefaults();
        this.tradeList.put(UATrade.class, 0.2);
        this.tradeList.put(MetaAlloyTrade.class, 0.1);
        boolean jvm = ReikaJVMParser.isArgumentPresent((String)"useCachedEDDBForCC");
        if (jvm) {
            File f = new File(DragonAPICore.getMinecraftDirectory(), "ChromatiCraft_Data/eddbcache.json");
            if (f.exists() && System.currentTimeMillis() - f.lastModified() < 86400000L) {
                try {
                    r = ReikaFileReader.getReader((File)f, (Charset)Charsets.UTF_8);
                    throwable = null;
                    try {
                        if (r != null) {
                            this.loadJSONData(r);
                            return;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (r != null) {
                            if (throwable != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                r.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                f.delete();
            }
        }
        try {
            URL url = new URL("https://eddb.io/archive/v6/commodities.json");
            r = ReikaFileReader.getReader((URL)url, (int)2000, (ReikaFileReader.ConnectionErrorHandler)this, null);
            throwable = null;
            try {
                if (r == null) {
                    throw new IOException("Could not read URL!");
                }
                this.loadJSONData(r);
                if (jvm) {
                    File f = new File(DragonAPICore.getMinecraftDirectory(), "ChromatiCraft_Data/eddbcache.json");
                    f.getParentFile().mkdirs();
                    f.delete();
                    ReikaFileReader.copyFile((InputStream)url.openStream(), (OutputStream)new FileOutputStream(f), (int)4096, null);
                    ChromatiCraft.logger.log((Object)"Downloaded eddb.io commodity data for caching.");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerCommodityHook(EDCommodityHook ech) {
        this.externalHooks.addValue((Object)ech.getCommodityID(), (Object)ech);
    }

    private void loadJSONData(Reader r) {
        JsonReader jr = new JsonReader(r);
        jr.setLenient(true);
        JsonElement e = new JsonParser().parse(jr);
        if (e instanceof JsonArray) {
            JsonArray j = (JsonArray)e;
            for (JsonElement elem : j) {
                JsonObject obj;
                JsonElement n;
                String data;
                if (!(elem instanceof JsonObject) || !this.prices.containsKey(data = (n = (obj = (JsonObject)elem).get("name")).getAsString())) continue;
                int price = obj.get("average_price").getAsInt();
                this.prices.put(data, price);
                ChromatiCraft.logger.log((Object)("Loading price data for " + data + " from eddb.io database: " + price + " CR"));
                Collection c = this.externalHooks.get((Object)data);
                if (c == null) continue;
                for (EDCommodityHook eh : c) {
                    JsonElement max = obj.get("max_sell_price");
                    JsonElement upper = obj.get("sell_price_upper_average");
                    eh.onPriceReceived(price, upper != null ? upper.getAsInt() : price, max != null ? max.getAsInt() : price);
                }
            }
        }
    }

    private void loadDefaults() {
        this.addPrice("Thargoid Sensor", 288000);
        this.addPrice("Meta-Alloys", 114000);
        for (EDCommodityHook eh : this.externalHooks.allValues(false)) {
            this.addPrice(eh.getCommodityID(), 0);
        }
    }

    private void addPrice(String id, int val) {
        this.prices.put(id, val);
        this.MAX_PRICE = Math.max(this.MAX_PRICE, val);
    }

    public void addTradesToVillager(EntityVillager ev, MerchantRecipeList li, Random rand) {
        MerchantRecipe trade;
        for (Map.Entry<Class<? extends UATypeTrade>, Double> e : this.tradeList.entrySet()) {
            trade = e.getKey();
            if (!VillageTradeHandler.instance.withRandomChance(ev, e.getValue(), trade.getSimpleName()) || this.hasTrade(ev.field_70963_i, (Class<? extends UATypeTrade>)trade)) continue;
            try {
                ev.field_70963_i.add(trade.newInstance());
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not add trade type " + trade + " to villager!"));
                ex.printStackTrace();
            }
        }
        for (EDCommodityHook eh : this.externalHooks.allValues(false)) {
            if (!VillageTradeHandler.instance.withRandomChance(ev, eh.getChancePerVillager(), eh.getCommodityID()) || this.hasTrade(ev.field_70963_i, trade = eh.createTrade())) continue;
            try {
                ev.field_70963_i.add((Object)trade);
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not add delegated trade " + trade + " to villager!"));
                e.printStackTrace();
            }
        }
    }

    private boolean hasTrade(MerchantRecipeList li, MerchantRecipe tr) {
        for (Object r : li) {
            if (r.getClass() != tr.getClass() || !ASMCalls.matchTrades((MerchantRecipe)((MerchantRecipe)r), (MerchantRecipe)tr)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTrade(MerchantRecipeList li, Class<? extends UATypeTrade> tr) {
        for (Object r : li) {
            if (r.getClass() != tr) continue;
            return true;
        }
        return false;
    }

    private static int calcValue(String id) {
        int price = UATrades.instance.prices.get(id);
        return price * 48 / UATrades.instance.MAX_PRICE;
    }

    public void onServerRedirected() {
        ChromatiCraft.logger.logError((Object)"Could not load commodity price data - server redirected!");
    }

    public void onTimedOut() {
        ChromatiCraft.logger.logError((Object)"Could not load commodity price data - timed out!");
    }

    public void onNoInternet() {
        ChromatiCraft.logger.logError((Object)"Could not load commodity price data - no internet connection!");
    }

    public void onServerNotFound() {
        ChromatiCraft.logger.logError((Object)"Could not load commodity price data - server not found!");
    }

    public static interface EDCommodityHook {
        public String getCommodityID();

        public double getChancePerVillager();

        public MerchantRecipe createTrade();

        public void onPriceReceived(int var1, int var2, int var3);
    }

    public static class MetaAlloyTrade
    extends UATypeTrade {
        MetaAlloyTrade() {
            super(ChromaBlocks.METAALLOYLAMP.getStackOf(), "Meta-Alloys");
        }

        public boolean isValid(EntityPlayer ep) {
            return true;
        }
    }

    public static class UATrade
    extends UATypeTrade {
        UATrade() {
            super(ChromaItems.ARTEFACT.getStackOfMetadata(ItemUnknownArtefact.ArtefactTypes.ARTIFACT.ordinal()), "Thargoid Sensor");
        }

        public boolean isValid(EntityPlayer ep) {
            return ProgressStage.ARTEFACT.isPlayerAtStage(ep);
        }
    }

    public static abstract class UATypeTrade
    extends MerchantRecipe
    implements PlayerSpecificTrade {
        public final int emeraldValue;

        protected UATypeTrade(ItemStack in, String priceID) {
            super(in, new ItemStack(Items.field_151166_bC, UATrades.calcValue(priceID), 0));
            this.emeraldValue = UATrades.calcValue(priceID);
        }

        public final void func_77399_f() {
        }
    }
}

