/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.CastingTuning;

import Reika.ChromatiCraft.Magic.CastingTuning.TuningKey;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CastingTuningManager {
    public static final CastingTuningManager instance = new CastingTuningManager();
    public static final String NBT_KEY = "CASTTUNING";
    final HashMap<ReikaDirectionHelper.FanDirections, Coordinate> tuningKeys = new HashMap();
    private final PlayerMap<TuningKey> data = new PlayerMap();
    private final Random rand = new Random();

    private CastingTuningManager() {
        for (ReikaDirectionHelper.FanDirections dir : ReikaDirectionHelper.FanDirections.list) {
            if (dir.isCardinal()) continue;
            int n = dir.isOctagonal() ? 6 : 3;
            Coordinate c = new Coordinate(dir.directionX * n, 0, dir.directionZ * n);
            this.tuningKeys.put(dir, c);
        }
    }

    public TuningKey getTuningKey(EntityPlayer ep) {
        return this.getTuningKey(ep.field_70170_p, ep.func_110124_au());
    }

    public TuningKey getTuningKey(World world, UUID uid) {
        TuningKey ret = (TuningKey)this.data.directGet(uid);
        if (ret == null) {
            ret = this.calculateTuningKey(world, uid);
            this.data.directPut(uid, (Object)ret);
        }
        return ret;
    }

    private TuningKey calculateTuningKey(World world, UUID ep) {
        TuningKey tk = new TuningKey(ep);
        if (ep.equals(DragonAPICore.Reika_UUID)) {
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.WNW), CrystalElement.RED);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.NW), CrystalElement.BLACK);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.NNW), CrystalElement.BLUE);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.NNE), CrystalElement.BLACK);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.NE), CrystalElement.LIME);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.ENE), CrystalElement.YELLOW);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.ESE), CrystalElement.WHITE);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.SE), CrystalElement.LIGHTBLUE);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.SSE), CrystalElement.BLACK);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.SSW), CrystalElement.MAGENTA);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.SW), CrystalElement.PURPLE);
            tk.putRune(this.tuningKeys.get(ReikaDirectionHelper.FanDirections.WSW), CrystalElement.RED);
        } else {
            long seed = this.generateTuningSeed(world, ep);
            this.seed(seed);
            int n = 12;
            int i = 0;
            ArrayList<Coordinate> li = new ArrayList<Coordinate>(this.tuningKeys.values());
            Collections.sort(li);
            Collections.shuffle(li, this.rand);
            for (Coordinate c : li) {
                tk.putRune(c, CrystalElement.elements[this.rand.nextInt(16)]);
                if (++i < n) continue;
                break;
            }
        }
        return tk;
    }

    private long generateTuningSeed(World world, UUID ep) {
        if (world.field_72995_K) {
            return this.fetchClientSeed();
        }
        long seed = ep.getMostSignificantBits() ^ ep.getLeastSignificantBits();
        return seed ^= ReikaWorldHelper.getCurrentWorldID((World)world).worldCreationTime;
    }

    @SideOnly(value=Side.CLIENT)
    private long fetchClientSeed() {
        NBTTagCompound data;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        NBTTagCompound tag = ChromaResearchManager.instance.getRootNBTTag((EntityPlayer)ep);
        boolean flag = false;
        if (!tag.func_74764_b(NBT_KEY)) {
            flag = true;
        }
        if (!(data = tag.func_74775_l(NBT_KEY)).func_74764_b("rootSeed")) {
            flag = true;
        }
        if (flag) {
            ReikaPlayerAPI.requestCustomDataSyncFromClient((EntityPlayer)ep);
        }
        return data.func_74763_f("rootSeed");
    }

    private void seed(long seed) {
        this.rand.setSeed(seed);
        this.rand.nextBoolean();
        this.rand.nextBoolean();
    }

    public Collection<Coordinate> getTuningKeyLocations() {
        return Collections.unmodifiableCollection(this.tuningKeys.values());
    }

    public void calculateAndCacheKey(EntityPlayer player) {
        TuningKey tk = this.getTuningKey(player);
        NBTTagCompound tag = ChromaResearchManager.instance.getRootNBTTag(player);
        NBTTagCompound data = tag.func_74775_l(NBT_KEY);
        data.func_74772_a("rootSeed", this.generateTuningSeed(player.field_70170_p, player.func_110124_au()));
        tag.func_74782_a(NBT_KEY, (NBTBase)data);
    }
}

